/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.yyprotocol.core;

import com.yy.mobile.yyprotocol.core.Header;
import com.yy.mobile.yyprotocol.core.Marshallable;
import com.yy.mobile.yyprotocol.core.Pack;
import com.yy.mobile.yyprotocol.core.Uint32;
import java.nio.ByteBuffer;

public class Sender
extends Header {
    private static final int HEADER_SIZE = 10;
    private Pack pack = new Pack();
    private int bodySize;

    public Sender(long uri, Marshallable m) {
        this(new Uint32(uri), m);
    }

    public Sender(int uri, Marshallable m) {
        this(new Uint32(uri), m);
    }

    public Sender(Uint32 uri, Marshallable m) {
        this.setUri(uri);
        this.pack.getBuffer().position(this.headerSize());
        m.marshall(this.pack);
        this.bodySize = this.pack.size() - this.headerSize();
    }

    public void endPack() {
        this.pack.replaceUint32(4, this.uri);
        this.pack.replaceUint16(8, this.resCode);
        this.pack.replaceUint32(0, new Uint32(this.headerSize() + this.bodySize()));
        this.pack.getBuffer().position(this.headerSize() + this.bodySize());
        this.pack.getBuffer().flip();
    }

    public Pack getPack() {
        return this.pack;
    }

    public int headerSize() {
        return 10;
    }

    public int bodySize() {
        return this.bodySize;
    }

    public ByteBuffer getBuffer() {
        return this.getPack().getBuffer();
    }

    public byte[] getBytes() {
        return this.getPack().toBytes();
    }
}

