/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.log.logger.printer.writer;

import com.yy.mobile.util.log.PerfLog;
import com.yy.mobile.util.log.logger.ILogProtection;
import com.yy.mobile.util.log.logger.LogProtection;
import com.yy.mobile.util.log.logger.printer.AndroidPrinter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractFileWriter {
    protected Writer mFileWriter;
    protected volatile boolean mUseBuffer = true;
    protected ILogProtection mLogProtection;
    private static final String TAG = "AbstractFileWriter";

    public AbstractFileWriter() {
        this(null);
    }

    public AbstractFileWriter(Writer fileWriter) {
        this.mFileWriter = fileWriter;
        this.mLogProtection = new LogProtection();
    }

    public void writer(String msg, long msgTime) throws IOException {
        if (this.mLogProtection.errWarning()) {
            AndroidPrinter.log("W/:", TAG, null, "errWarning mFileWriter.write(msg,long) " + msg, new Object[0]);
            return;
        }
        if (msg == null || this.mFileWriter == null) {
            return;
        }
        try {
            this.mFileWriter.write(msg);
        }
        catch (IOException e) {
            this.mLogProtection.active();
            PerfLog.webLog("mlog", "mFileWriter.write(msg,long) " + e.getMessage());
            this.mFileWriter.write(msg);
        }
    }

    public void writer(String msg) throws IOException {
        if (this.mLogProtection.errWarning()) {
            AndroidPrinter.log("W/:", TAG, null, "errWarning mFileWriter.write(msg) " + msg, new Object[0]);
            return;
        }
        if (msg == null || this.mFileWriter == null) {
            return;
        }
        try {
            this.mFileWriter.write(msg);
        }
        catch (IOException e) {
            this.mLogProtection.active();
            PerfLog.webLog("mlog", "mFileWriter.write(msg) " + e.getMessage());
            this.mFileWriter.write(msg);
        }
    }

    public void flush() throws IOException {
        if (this.mLogProtection.errWarning()) {
            AndroidPrinter.log("W/:", TAG, null, "errWarning mFileWriter.flush", new Object[0]);
            return;
        }
        if (this.mFileWriter == null) {
            return;
        }
        try {
            this.mFileWriter.flush();
        }
        catch (IOException e) {
            this.mLogProtection.active();
            PerfLog.webLog("mlog", "mFileWriter.flush error " + e.getMessage());
            this.mFileWriter.flush();
        }
    }

    public void close() throws IOException {
        if (this.mFileWriter == null) {
            return;
        }
        try {
            this.mFileWriter.flush();
            this.mFileWriter.close();
        }
        catch (IOException e) {
            PerfLog.webLog("mlog", "mFileWriter.flush() mFileWriter.close() " + e.getMessage());
            this.mFileWriter.close();
        }
    }

    public void update(Writer fileWriter) {
        if (fileWriter == null) {
            return;
        }
        if (this.mFileWriter != null) {
            try {
                this.close();
            }
            catch (IOException e) {
                AndroidPrinter.log("E/:", TAG, e, " close error", new Object[0]);
                PerfLog.webLog("mlog", "AbstractFileWriter close error " + e.getMessage());
            }
        }
        this.mFileWriter = fileWriter;
    }

    public void setBuffered(boolean useBuffer) {
        this.mUseBuffer = useBuffer;
    }

    public abstract Writer createWrite(File var1) throws IOException;

    public void flush(boolean forced) throws IOException {
    }
}

