/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.log.logger.printer.filestrategy;

import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.logger.Utils;
import com.yy.mobile.util.log.logger.printer.filestrategy.IFileStrategy;
import java.io.File;
import java.util.Calendar;

public class SectionFileStrategy
implements IFileStrategy {
    public static final int SECTION_FILE_SIZE = 4;
    private static int FILE_SIZE_ONE_M = 1;
    private static final int CHECK_FILE_EXIST_GAP = 150;
    private static final int CHECK_TIME_GAP = 150;
    private String mDir;
    private String mFileNamePrefix;
    private String mCurrentFileName;
    private File mCurrentFile;
    private int[] mTimes = new int[5];
    private long mLastRenameTime;
    private long mNextRenameCheckTime;
    private int mCheckTimeAfterTimes = 150;
    private int mCheckFileSizeAfterTimes;
    private int mCheckFileExistAfterTimes = 150;
    private Calendar mCalendar = Calendar.getInstance();

    private int[] getTime(long timeMillis) {
        int[] time = new int[5];
        this.mCalendar.setTimeInMillis(timeMillis);
        time[0] = this.mCalendar.get(1);
        time[1] = this.mCalendar.get(2) + 1;
        time[2] = this.mCalendar.get(5);
        time[3] = this.mCalendar.get(11);
        time[4] = this.mCalendar.get(12);
        return time;
    }

    private String getLogFileName(int[] curTime) {
        boolean needChangeName = false;
        if (StringUtils.isEmpty(this.mCurrentFileName).booleanValue()) {
            needChangeName = true;
        }
        if (!needChangeName) {
            if (curTime[0] != this.mTimes[0]) {
                needChangeName = true;
            }
            if (curTime[1] != this.mTimes[1]) {
                needChangeName = true;
            }
            if (curTime[2] != this.mTimes[2]) {
                needChangeName = true;
            }
            if (curTime[3] != this.mTimes[3]) {
                needChangeName = true;
            }
            if (curTime[4] != this.mTimes[4]) {
                needChangeName = true;
            }
        }
        if (needChangeName) {
            this.mTimes = curTime;
            StringBuilder buffer = new StringBuilder(this.mFileNamePrefix + "_" + this.mTimes[0]);
            if (this.mTimes[1] > 9) {
                buffer.append("_");
                buffer.append(this.mTimes[1]);
            } else {
                buffer.append("_0");
                buffer.append(this.mTimes[1]);
            }
            if (this.mTimes[2] > 9) {
                buffer.append("_");
                buffer.append(this.mTimes[2]);
            } else {
                buffer.append("_0");
                buffer.append(this.mTimes[2]);
            }
            if (this.mTimes[3] > 9) {
                buffer.append("_");
                buffer.append(this.mTimes[3]);
            } else {
                buffer.append("_0");
                buffer.append(this.mTimes[3]);
            }
            if (this.mTimes[4] > 9) {
                buffer.append("_");
                buffer.append(this.mTimes[4]);
            } else {
                buffer.append("_0");
                buffer.append(this.mTimes[4]);
            }
            buffer.append(".txt");
            return buffer.toString();
        }
        return this.mCurrentFileName;
    }

    @Override
    public void updatePath(String dir, String fileNamePrefix) {
        if (Utils.equal(dir, this.mDir) && Utils.equal(fileNamePrefix, this.mFileNamePrefix)) {
            return;
        }
        this.mCurrentFileName = null;
        this.mCurrentFile = null;
        this.mDir = dir;
        this.mFileNamePrefix = fileNamePrefix;
        this.mTimes[0] = 0;
    }

    @Override
    public File getFile() {
        if (this.mCurrentFile != null) {
            if (this.mCheckFileExistAfterTimes > 0) {
                --this.mCheckFileExistAfterTimes;
            } else if (!this.mCurrentFile.exists()) {
                this.mCheckFileExistAfterTimes = 150;
                this.mCurrentFileName = null;
                this.mCurrentFile = null;
                this.mTimes[0] = 0;
            }
        }
        if (this.mCurrentFile == null) {
            if (Utils.isEmpty(this.mDir).booleanValue() || Utils.isEmpty(this.mFileNamePrefix).booleanValue()) {
                throw new RuntimeException("SectionFileStrategylogDir and logName must be not empty!");
            }
            this.createNewFile();
        }
        this.checkFile();
        return this.mCurrentFile;
    }

    private void checkFile() {
        boolean needCheckTime = true;
        if (this.mCheckFileSizeAfterTimes <= 0) {
            long fileSizeM = this.mCurrentFile.length() >>> 20;
            if (fileSizeM >= 4L) {
                this.createNewFile();
                needCheckTime = false;
            } else {
                this.mCheckFileSizeAfterTimes = fileSizeM > (long)FILE_SIZE_ONE_M ? 100 : 300;
            }
        } else {
            --this.mCheckFileSizeAfterTimes;
        }
        if (needCheckTime) {
            if (this.mCheckTimeAfterTimes > 0) {
                --this.mCheckTimeAfterTimes;
            } else {
                long time = System.currentTimeMillis();
                if (time < 0L || time < this.mLastRenameTime || time > this.mNextRenameCheckTime) {
                    this.createNewFile();
                }
            }
        }
    }

    @Override
    public File createNewFileForce() {
        this.createNewFile(true);
        return this.mCurrentFile;
    }

    private boolean createNewFile() {
        return this.createNewFile(false);
    }

    private boolean createNewFile(boolean forceCreate) {
        long curTime = System.currentTimeMillis();
        boolean create = this.createNewFile(this.getLogFileName(this.getTime(curTime)), forceCreate);
        if (create) {
            this.mLastRenameTime = curTime;
            this.mNextRenameCheckTime = 61 - this.mTimes[4] > 0 ? this.mLastRenameTime + (long)((61 - this.mTimes[4]) * 60 * 1000) : this.mLastRenameTime + 1800000L;
            this.mCheckTimeAfterTimes = 150;
        }
        return create;
    }

    private boolean createNewFile(String fileName, boolean forceCreate) {
        if (!Utils.equal(fileName, this.mCurrentFileName) || forceCreate) {
            this.mCurrentFileName = fileName;
            this.mCurrentFile = new File(this.mDir, this.mCurrentFileName);
            Utils.ensureFileExist(this.mCurrentFile);
            this.mCheckFileSizeAfterTimes = 0;
            this.mCheckFileExistAfterTimes = 150;
            return true;
        }
        return false;
    }
}

