/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.log;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.StatFs;
import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.pref2.SharedPreferencesUtils;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.asynctask.ScheduledTask;
import com.yy.mobile.util.log.LogCompressListener;
import com.yy.mobile.util.log.LogCurrentWritingPath;
import com.yy.mobile.util.log.LogZipCompress;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.log.PerfLog;
import com.yy.mobile.util.valid.BlankUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogManager {
    private static final String TAG = "LogManager";
    private static LogManager mInstance;
    public static final String LOG_EXT = ".txt";
    public static final String LOG_TAG = "yymobile_log_files";
    public static final String LOG_RECORDS = "yy_log_records";
    public static final String OLD_LOGS = "logs.txt";
    public static final String UNCAUGHT_EXCEPTIONS_LOGS = "uncaught_exception.txt";
    public static final String UNCAUGHT_EXCEPTIONS_LOGS_ZIP = "uncaught_exception.zip";
    public static final String LOG_DESCRIPTION = "log_description.txt";
    public static final String LOG_ACTIVITY = "log_activity.txt";
    private static final float AVERAGE_LOG_ZIP_COMPRESSION_RATIO = 0.15f;
    private static Context mContext;
    private static final String PATTERN_STR = "[0-9]{4}_[0-9]{2}_[0-9]{2}_[0-9]{2}";
    private static final String PATTERN_WITH_MINUTE_STR = "[0-9]{4}_[0-9]{2}_[0-9]{2}_[0-9]{2}_[0-9]{2}";
    private static final String LOG_DATE_FORMAT_STR = "yyyy_MM_dd_HH";
    private static final String LOG_DATE_WITH_MINUTE_FORMAT_STR = "yyyy_MM_dd_HH_mm";
    private static Pattern PATTERN;
    private static Pattern PATTERN_WITH_MINUTE;
    public static final int MAX_FILE_SIZE = 101;
    public static final int SDK_LOG_FILE_LIMIT_ZIP_SIZE = 5;
    public static final int LOG_FILE_LIMIT_NUM = 15;
    public static final int LOG_DIR_NOT_EXIST = -8;
    public static final int NO_LOG_FILES_EXIST = -9;
    public static final int LOG_COMPRESS_FAILED = -10;
    public static final int SD_CARD_NOT_ENOUGH_FREE_SIZE = -11;
    private LogCompressListener listener;
    private LogProvider mLogProvider;
    private LogCurrentWritingPath pathListener;
    private String mNowWorkUserLogFileName = "";
    public static final long DAY_DELAY = 604800000L;
    private static String sDirCrashDump;

    private LogManager() {
    }

    public static synchronized LogManager getInstance() {
        if (mInstance == null) {
            mInstance = new LogManager();
        }
        return mInstance;
    }

    public void setCompressListener(LogCompressListener listener) {
        this.listener = listener;
    }

    public LogCurrentWritingPath getPathListener() {
        return this.pathListener;
    }

    public void setNowWorkUserLogFileName(@NonNull String filePath) {
        this.mNowWorkUserLogFileName = filePath;
    }

    public String getNowWorkUserLogFileName() {
        return this.mNowWorkUserLogFileName;
    }

    public void setPathListener(LogCurrentWritingPath pathListener) {
        this.pathListener = pathListener;
    }

    public void setLogProvider(LogProvider logProvider) {
        this.mLogProvider = logProvider;
    }

    public static Context getContext() {
        return mContext;
    }

    public static void setContext(Context mContext) {
        LogManager.mContext = mContext;
    }

    public void addSingleLogRecord(String logName) {
        String records = this.getLogRecord();
        if (BlankUtil.isBlank(records)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("|" + logName);
            this.setLogRecord(buffer.toString());
        } else if (!records.contains(logName)) {
            StringBuffer buffer = new StringBuffer(records);
            buffer.append("|" + logName);
            this.setLogRecord(buffer.toString());
        } else {
            return;
        }
    }

    public void removeSingleLogRecord(String logName) {
        String records = this.getLogRecord();
        if (BlankUtil.isBlank(records)) {
            return;
        }
        if (!records.contains(logName)) {
            return;
        }
        String target = records.replaceAll("\\|" + logName, "");
        this.setLogRecord(target);
    }

    public String getLogRecord() {
        if (BasicConfig.getInstance().getAppContext() != null) {
            return SharedPreferencesUtils.getSharedPreferences(BasicConfig.getInstance().getAppContext(), LOG_TAG, 0).getString(LOG_RECORDS, null);
        }
        return null;
    }

    public void setLogRecord(String allLogNames) {
        if (BasicConfig.getInstance().getAppContext() == null) {
            return;
        }
        SharedPreferencesUtils.getSharedPreferences(BasicConfig.getInstance().getAppContext(), LOG_TAG, 0).edit().putString(LOG_RECORDS, allLogNames).apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createLogDescriptionFile() {
        File logFile;
        MLog.info(TAG, "createLogDescriptionFile() called.", new Object[0]);
        String records = this.getLogRecord();
        String descriptionDir = MLog.getLogPath();
        String descriptionFilePath = MLog.getLogPath() + File.separator + LOG_DESCRIPTION;
        File dirFile = new File(descriptionDir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        if ((logFile = new File(descriptionFilePath)).exists() && !logFile.isDirectory()) {
            logFile.delete();
        }
        try {
            logFile.createNewFile();
        }
        catch (IOException e) {
            MLog.error((Object)TAG, "printStackTrace", e, new Object[0]);
            PerfLog.webLog("mlog", "createLogDescriptionFile" + e.getMessage());
        }
        StringBuffer buffer = new StringBuffer("");
        if (!BlankUtil.isBlank(records)) {
            String[] list;
            for (String s : list = records.split("\\|")) {
                if (BlankUtil.isBlank(s)) continue;
                buffer.append(s);
                buffer.append("\r\n");
            }
        } else {
            buffer.append("There is no log record, log description is blank.");
        }
        String descriptionStr = buffer.toString();
        FileWriter fileWriter = null;
        BufferedWriter bufWriter = null;
        try {
            fileWriter = new FileWriter(logFile, true);
            bufWriter = new BufferedWriter(fileWriter, 32768);
            bufWriter.write(descriptionStr);
        }
        catch (IOException e) {
            MLog.error((Object)TAG, "printStackTrace", e, new Object[0]);
            PerfLog.webLog("mlog", "bufWriter.write " + e.getMessage());
        }
        finally {
            try {
                if (bufWriter != null) {
                    bufWriter.flush();
                    bufWriter.close();
                }
            }
            catch (IOException e) {
                MLog.error((Object)TAG, "printStackTrace", e, new Object[0]);
                PerfLog.webLog("mlog", "bufWriter.flush() " + e.getMessage());
            }
        }
        return descriptionFilePath;
    }

    public void deleteOldLogs() {
        MLog.info(TAG, "deleteOldLogs() called.", new Object[0]);
        String dir = MLog.getLogPath();
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            return;
        }
        long now = System.currentTimeMillis();
        File[] files = dirFile.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (this.checkCompressed(file.getName()) && file.length() < 200L) {
                MLog.info(TAG, "deleteOldLogs() : " + file.getName() + " deleted , because of abnormal file size.", new Object[0]);
                this.removeLogFile(file);
            }
            long backupTime = this.parseLogCreateTime(file);
            long fileSize = file.length() >>> 20;
            if (fileSize >= 101L) {
                MLog.info(TAG, "deleteOldLogs() : " + file.getName() + " deleted , because of abnormal file size.", new Object[0]);
                this.removeLogFile(file);
                continue;
            }
            if (now - backupTime <= 604800000L) continue;
            MLog.info(TAG, "deleteOldLogs() : " + file.getName() + " deleted , because this file is overdue.", new Object[0]);
            this.removeLogFile(file);
        }
    }

    private void removeLogFile(File file) {
        if (file.exists() && !file.isDirectory() && file.getName().contains(".")) {
            this.removeSingleLogRecord(file.getName().substring(0, file.getName().indexOf(".")));
        }
        file.delete();
    }

    public void checkAndCompressLog() {
        MLog.info(TAG, "checkAndCompressLog() called", new Object[0]);
        String dir = MLog.getLogPath();
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            return;
        }
        final File[] files = dirFile.listFiles();
        if (files == null) {
            return;
        }
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                for (File file : files) {
                    String currentTime = CommonUtils.getSimpleDateFormat(LogManager.LOG_DATE_WITH_MINUTE_FORMAT_STR).format(new Date());
                    if (file.getName().equals(LogManager.OLD_LOGS) || file.getName().equals(LogManager.UNCAUGHT_EXCEPTIONS_LOGS) || file.getName().equals(LogManager.LOG_DESCRIPTION) || file.getName().equals(LogManager.LOG_ACTIVITY) || file.getName().equals(LogManager.this.getNowWorkUserLogFileName())) {
                        MLog.info(LogManager.TAG, "\u65e7\u7cfb\u7edf\u8f93\u51fa\u7684\u65e5\u5fd7\u3001\u5f02\u5e38\u65e5\u5fd7\u3001\u65e5\u5fd7\u63cf\u8ff0\u6587\u4ef6\uff0c\u4e0d\u538b " + file.getName(), new Object[0]);
                        continue;
                    }
                    if (!file.getName().endsWith(LogManager.LOG_EXT) || file.getName().contains(currentTime) || !LogManager.this.containsPattern(file)) continue;
                    try {
                        MLog.info(LogManager.TAG, "checkAndCompressLog() : " + file.getName() + " is compressed.", new Object[0]);
                        LogZipCompress.getInstance().compress(file);
                        file.delete();
                    }
                    catch (Throwable e) {
                        PerfLog.webLog("mlog", "LogZipCompress.getInstance().compress(file); " + e.getMessage());
                        MLog.error((Object)LogManager.TAG, "printStackTrace", e, new Object[0]);
                    }
                }
            }
        });
    }

    public String uncaughtExceptionsLogsPath() {
        return MLog.getLogPath() + File.separator + UNCAUGHT_EXCEPTIONS_LOGS;
    }

    public String uncaughtExceptionsLogsPathZip() {
        return MLog.getLogPath() + File.separator + UNCAUGHT_EXCEPTIONS_LOGS_ZIP;
    }

    public String activityLogsPath() {
        return MLog.getLogPath() + File.separator + LOG_ACTIVITY;
    }

    public File getUncaughtCrashDumpLogsFileName() {
        File dir = new File(sDirCrashDump);
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        ArrayList<File> dumpfiles = new ArrayList<File>();
        for (File f : files) {
            if (!f.getName().endsWith(".dmp")) continue;
            dumpfiles.add(f);
        }
        if (dumpfiles.isEmpty()) {
            return null;
        }
        File latesFile = (File)dumpfiles.get(0);
        for (File file : dumpfiles) {
            if (file.lastModified() <= latesFile.lastModified()) continue;
            latesFile = file;
        }
        return latesFile;
    }

    public String tempDecompressDir() {
        return MLog.getLogPath() + File.separator + "tempDir" + File.separator;
    }

    public boolean collectLogByTime(long startTimeMils, long endTimeMils, final long uid) {
        File crashDumpFile;
        File activityLogFilePath;
        ArrayList<File> sdkFiles;
        MLog.info(TAG, "collectLogByTime() called.", new Object[0]);
        if (this.mLogProvider == null) {
            return false;
        }
        ArrayList<File> appLogFiles = new ArrayList<File>();
        if (!this.mLogProvider.fillAppLogs(appLogFiles, this.listener)) {
            return false;
        }
        final ArrayList<File> srcLogFiles = new ArrayList<File>();
        final ArrayList<File> destLogFiles = new ArrayList<File>();
        final String tempDir = this.tempDecompressDir();
        MLog.info(TAG, "collectLogByTime() : generating log description", new Object[0]);
        String logDescFilePath = this.createLogDescriptionFile();
        if (!BlankUtil.isBlank(logDescFilePath)) {
            destLogFiles.add(new File(logDescFilePath));
        }
        if (!this.mLogProvider.fillSdkLogs(sdkFiles = new ArrayList<File>(), this.listener)) {
            return false;
        }
        destLogFiles.addAll(sdkFiles);
        ArrayList<File> extraFiles = new ArrayList<File>();
        if (!this.mLogProvider.fillExtraFiles(extraFiles, this.listener)) {
            return false;
        }
        destLogFiles.addAll(extraFiles);
        MLog.info(TAG, "collectLogByTime() : collecting UNCAUGHT_EXCEPTIONS log", new Object[0]);
        File uncaughtExceptionFile = new File(this.uncaughtExceptionsLogsPath());
        if (uncaughtExceptionFile.exists()) {
            destLogFiles.add(uncaughtExceptionFile);
        }
        if ((activityLogFilePath = new File(this.activityLogsPath())).exists()) {
            destLogFiles.add(activityLogFilePath);
        }
        if ((crashDumpFile = this.getUncaughtCrashDumpLogsFileName()) != null) {
            destLogFiles.add(crashDumpFile);
        }
        MLog.info(TAG, "collectLogByTime() : collecting normal logs between time point(" + startTimeMils + ") and (" + endTimeMils + ")", new Object[0]);
        long createTime = 0L;
        long zipSize = 0L;
        for (File file : appLogFiles) {
            createTime = this.parseLogCreateTime(file);
            if (file.isDirectory() || !this.containsPattern(file) || createTime == 0L || createTime < startTimeMils || createTime > endTimeMils) continue;
            srcLogFiles.add(file);
            zipSize += file.length();
        }
        if (this.getSDFreeSize() <= zipSize * 10L) {
            if (this.listener != null) {
                this.listener.onCompressError(-11);
            }
            return false;
        }
        final File temp = new File(tempDir);
        if (temp.exists() && temp.isDirectory()) {
            LogManager.deleteDir(temp);
        }
        ScheduledTask.getInstance().scheduledDelayed(new Runnable(){

            @Override
            public void run() {
                File[] tempFiles;
                if (srcLogFiles.size() > 0) {
                    MLog.info(LogManager.TAG, "collectLogByTime() : Logs packing task started", new Object[0]);
                    for (Object file : srcLogFiles) {
                        if (LogManager.this.checkCompressed(((File)file).getName())) {
                            try {
                                if (((File)file).length() < 200L) {
                                    LogManager.this.removeLogFile((File)file);
                                    PerfLog.webLog("mlog", "\u5c0f\u4e8e200\u5b57\u8282\u7684\u538b\u7f29\u6587\u4ef6\u53ef\u4ee5\u5224\u5b9a\u4e3a\u5f02\u5e38\u7684\u6587\u4ef6");
                                    continue;
                                }
                                LogZipCompress.getInstance().decompress((File)file, tempDir);
                            }
                            catch (Exception e) {
                                PerfLog.webLog("mlog", "file:" + ((File)file).getName() + "  removeLogFile(file) " + e.getMessage());
                                MLog.error((Object)LogManager.TAG, "file:" + ((File)file).getName() + " printStackTrace", e.getMessage());
                            }
                            continue;
                        }
                        destLogFiles.add(file);
                    }
                }
                if ((tempFiles = new File(tempDir).listFiles()) != null) {
                    for (File file : tempFiles) {
                        if (destLogFiles.contains(file)) continue;
                        destLogFiles.add(file);
                    }
                }
                if (destLogFiles.size() > 0) {
                    Pair<Integer, String> pack = LogZipCompress.getInstance().compressFiles((List<File>)destLogFiles, uid);
                    if ((Integer)pack.first != 0 || BlankUtil.isBlank((String)pack.second)) {
                        if (LogManager.this.listener != null) {
                            LogManager.this.listener.onCompressError((Integer)pack.first);
                        }
                    } else if (LogManager.this.listener != null) {
                        LogManager.this.listener.onCompressFinished((String)pack.second);
                    }
                }
                LogManager.deleteDir(temp);
                MLog.info(LogManager.TAG, "collectLogByTime() : Logs packing task finished", new Object[0]);
            }
        }, 0L);
        return true;
    }

    public boolean collectLogBySize(long collectTimePoint, int sizeInMB, long uid) {
        return this.collectLogBySize(collectTimePoint, sizeInMB, uid, "");
    }

    public boolean collectLogBySize(long collectTimePoint, int sizeInMB, final long uid, String imagePath) {
        File crashDumpFile;
        File activityLogFilePath;
        File uncaughtExceptionFileZip;
        File imageFile;
        MLog.info(TAG, "collectLogBySize() called", new Object[0]);
        if (this.mLogProvider == null) {
            return false;
        }
        ArrayList<File> appLogFiles = new ArrayList<File>();
        if (!this.mLogProvider.fillAppLogs(appLogFiles, this.listener)) {
            return false;
        }
        final ArrayList<File> sdkLogFiles = new ArrayList<File>();
        if (!this.mLogProvider.fillSdkLogs(sdkLogFiles, this.listener)) {
            return false;
        }
        ArrayList<File> extraFiles = new ArrayList<File>();
        if (!this.mLogProvider.fillExtraFiles(extraFiles, this.listener)) {
            return false;
        }
        final ArrayList<File> srcLogFiles = new ArrayList<File>();
        final ArrayList<File> destLogFiles = new ArrayList<File>();
        TreeMap<Long, String> fileList = new TreeMap<Long, String>(new Comparator<Long>(){

            @Override
            public int compare(Long lhs, Long rhs) {
                return rhs.compareTo(lhs);
            }
        });
        final String tempDir = this.tempDecompressDir();
        float residualSize = sizeInMB * 1024 * 1024;
        MLog.info(TAG, "collectLogBySize() : generating log description", new Object[0]);
        String logDescFilePath = this.createLogDescriptionFile();
        if (!BlankUtil.isBlank(logDescFilePath)) {
            File f = new File(logDescFilePath);
            destLogFiles.add(f);
        }
        MLog.info(TAG, "collectLogBySize() : collecting SDK logs", new Object[0]);
        float sdkFileZipSize = 5242880.0f;
        for (File f : sdkLogFiles) {
            sdkFileZipSize -= (float)f.length() * 0.15f;
        }
        if (sdkFileZipSize < 0.0f && sdkLogFiles.size() > 0) {
            MLog.info(TAG, "collectLogBySize() : SDK Logs size exceeds the limit , starting to filter these SDK logs", new Object[0]);
            File removeFile = (File)sdkLogFiles.get(0);
            long time = ((File)sdkLogFiles.get(0)).lastModified();
            while (sdkFileZipSize < 0.0f) {
                for (File f : sdkLogFiles) {
                    if (f.lastModified() >= time) continue;
                    removeFile = f;
                    time = f.lastModified();
                }
                if (removeFile == null) continue;
                sdkLogFiles.remove(removeFile);
                sdkFileZipSize += (float)removeFile.length() * 0.15f;
                if (sdkLogFiles.size() <= 0) continue;
                removeFile = (File)sdkLogFiles.get(0);
                time = ((File)sdkLogFiles.get(0)).lastModified();
            }
        }
        if (!BlankUtil.isBlank(imagePath) && (imageFile = new File(imagePath)).exists()) {
            destLogFiles.add(new File(imagePath));
        }
        MLog.info(TAG, "collectLogBySize() : collecting UNCAUGHT_EXCEPTIONS log", new Object[0]);
        File uncaughtExceptionFile = new File(this.uncaughtExceptionsLogsPath());
        if (uncaughtExceptionFile.exists()) {
            destLogFiles.add(uncaughtExceptionFile);
        }
        if ((uncaughtExceptionFileZip = new File(this.uncaughtExceptionsLogsPathZip())).exists()) {
            destLogFiles.add(uncaughtExceptionFileZip);
        }
        if ((activityLogFilePath = new File(this.activityLogsPath())).exists()) {
            destLogFiles.add(activityLogFilePath);
        }
        if ((crashDumpFile = this.getUncaughtCrashDumpLogsFileName()) != null) {
            destLogFiles.add(crashDumpFile);
        }
        destLogFiles.addAll(extraFiles);
        MLog.info(TAG, "collectLogBySize() : collecting normal logs around this time point(" + collectTimePoint + ")", new Object[0]);
        long intervalTime = 0L;
        long zipSize = 0L;
        for (File file : appLogFiles) {
            if (!this.containsPattern(file)) continue;
            intervalTime = this.parseLogCreateTime(file);
            if (fileList.containsKey(intervalTime)) {
                intervalTime += (long)((int)(Math.random() * 1000.0) + 1);
            }
            fileList.put(intervalTime, file.getAbsolutePath());
        }
        MLog.info(TAG, "fileList:" + fileList.toString(), new Object[0]);
        Iterator iterator = fileList.entrySet().iterator();
        while (iterator.hasNext() && residualSize > 0.0f) {
            Map.Entry entry = iterator.next();
            MLog.info(TAG, "fileList:" + entry.toString(), new Object[0]);
            String value = (String)entry.getValue();
            File f = new File(value);
            if (!f.exists() || f.isDirectory()) continue;
            if (this.checkCompressed(f.getName())) {
                if (!(residualSize - (float)f.length() >= 0.0f)) continue;
                residualSize -= (float)f.length();
                srcLogFiles.add(f);
                continue;
            }
            if (!(residualSize - (float)f.length() * 0.15f >= 0.0f)) continue;
            residualSize -= (float)f.length() * 0.15f;
            srcLogFiles.add(f);
        }
        if (this.getSDFreeSize() <= zipSize * 10L) {
            if (this.listener != null) {
                PerfLog.webLog("mlog", "SD_CARD_NOT_ENOUGH_FREE_SIZE");
            }
            this.listener.onCompressError(-11);
            return false;
        }
        final File temp = new File(tempDir);
        if (temp.exists() && temp.isDirectory()) {
            LogManager.deleteDir(temp);
        }
        ScheduledTask.getInstance().scheduledDelayed(new Runnable(){

            @Override
            public void run() {
                File[] tempFiles;
                MLog.info(LogManager.TAG, "collectLogBySize() : Logs packing task started", new Object[0]);
                if (srcLogFiles.size() > 0) {
                    for (File[] file : srcLogFiles) {
                        if (LogManager.this.checkCompressed(file.getName())) {
                            try {
                                if (file.length() < 200L) {
                                    LogManager.this.removeLogFile((File)file);
                                    PerfLog.webLog("mlog", "\u68c0\u67e5\uff1a\u538b\u7f29\u6587\u4ef6\u957f\u5ea6\u82e5\u5c0f\u4e8e200\u57fa\u672c\u53ef\u5224\u5b9a\u4e3a\u5f02\u5e38\u6587\u4ef6\uff0c\u5220\u9664\uff0c\u9632\u6b62\u89e3\u538b\u65f6\u51fa\u5f02\u5e38");
                                    continue;
                                }
                                LogZipCompress.getInstance().decompress((File)file, tempDir);
                            }
                            catch (Exception e) {
                                PerfLog.webLog("mlog", "printStackTrace " + file.getName() + " removeLogFile(file) " + e.getMessage());
                                MLog.error((Object)LogManager.TAG, "printStackTrace", e.getMessage());
                            }
                            continue;
                        }
                        destLogFiles.add(file);
                    }
                }
                if ((tempFiles = new File(tempDir).listFiles()) != null) {
                    for (File file : tempFiles) {
                        if (destLogFiles.contains(file)) continue;
                        destLogFiles.add(file);
                    }
                }
                MLog.info(LogManager.TAG, "destLogFiles: " + destLogFiles.toString(), new Object[0]);
                if (destLogFiles.size() > 0) {
                    Pair<Integer, String> pack = LogZipCompress.getInstance().compressFiles((List<File>)destLogFiles, (List<File>)sdkLogFiles, uid);
                    if ((Integer)pack.first != 0 || BlankUtil.isBlank((String)pack.second)) {
                        if (LogManager.this.listener != null) {
                            LogManager.this.listener.onCompressError((Integer)pack.first);
                        }
                    } else if (LogManager.this.listener != null) {
                        LogManager.this.listener.onCompressFinished((String)pack.second);
                    }
                }
                LogManager.deleteDir(temp);
                MLog.info(LogManager.TAG, "collectLogBySize() : Logs packing task finished", new Object[0]);
            }
        }, 0L);
        return true;
    }

    public boolean collectLogBySize(long collectTimePoint, int sizeInMB, final long uid, List<String> imagePaths) {
        File crashDumpFile;
        File activityLogFilePath;
        File uncaughtExceptionFileZip;
        MLog.info(TAG, "collectLogBySize() called", new Object[0]);
        if (this.mLogProvider == null) {
            return false;
        }
        ArrayList<File> appLogFiles = new ArrayList<File>();
        if (!this.mLogProvider.fillAppLogs(appLogFiles, this.listener)) {
            return false;
        }
        final ArrayList<File> sdkLogFiles = new ArrayList<File>();
        if (!this.mLogProvider.fillSdkLogs(sdkLogFiles, this.listener)) {
            return false;
        }
        ArrayList<File> extraFiles = new ArrayList<File>();
        if (!this.mLogProvider.fillExtraFiles(extraFiles, this.listener)) {
            return false;
        }
        final ArrayList<File> srcLogFiles = new ArrayList<File>();
        final ArrayList<File> destLogFiles = new ArrayList<File>();
        TreeMap<Long, String> fileList = new TreeMap<Long, String>(new Comparator<Long>(){

            @Override
            public int compare(Long lhs, Long rhs) {
                return rhs.compareTo(lhs);
            }
        });
        final String tempDir = this.tempDecompressDir();
        float residualSize = sizeInMB * 1024 * 1024;
        MLog.info(TAG, "collectLogBySize() : generating log description", new Object[0]);
        String logDescFilePath = this.createLogDescriptionFile();
        if (!BlankUtil.isBlank(logDescFilePath)) {
            File f = new File(logDescFilePath);
            destLogFiles.add(f);
        }
        MLog.info(TAG, "collectLogBySize() : collecting SDK logs", new Object[0]);
        float sdkFileZipSize = 5242880.0f;
        for (File f : sdkLogFiles) {
            sdkFileZipSize -= (float)f.length() * 0.15f;
        }
        if (sdkFileZipSize < 0.0f && sdkLogFiles.size() > 0) {
            MLog.info(TAG, "collectLogBySize() : SDK Logs size exceeds the limit , starting to filter these SDK logs", new Object[0]);
            Object removeFile = (File)sdkLogFiles.get(0);
            long time = ((File)sdkLogFiles.get(0)).lastModified();
            while (sdkFileZipSize < 0.0f) {
                for (File f : sdkLogFiles) {
                    if (f.lastModified() >= time) continue;
                    removeFile = f;
                    time = f.lastModified();
                }
                if (removeFile == null) continue;
                sdkLogFiles.remove(removeFile);
                sdkFileZipSize += (float)((File)removeFile).length() * 0.15f;
                if (sdkLogFiles.size() <= 0) continue;
                removeFile = (File)sdkLogFiles.get(0);
                time = ((File)sdkLogFiles.get(0)).lastModified();
            }
        }
        for (String imagePath : imagePaths) {
            File imageFile;
            if (BlankUtil.isBlank(imagePath) || !(imageFile = new File(imagePath)).exists()) continue;
            destLogFiles.add(new File(imagePath));
        }
        MLog.info(TAG, "collectLogBySize() : collecting UNCAUGHT_EXCEPTIONS log", new Object[0]);
        File uncaughtExceptionFile = new File(this.uncaughtExceptionsLogsPath());
        if (uncaughtExceptionFile.exists()) {
            destLogFiles.add(uncaughtExceptionFile);
        }
        if ((uncaughtExceptionFileZip = new File(this.uncaughtExceptionsLogsPathZip())).exists()) {
            destLogFiles.add(uncaughtExceptionFileZip);
        }
        if ((activityLogFilePath = new File(this.activityLogsPath())).exists()) {
            destLogFiles.add(activityLogFilePath);
        }
        if ((crashDumpFile = this.getUncaughtCrashDumpLogsFileName()) != null) {
            destLogFiles.add(crashDumpFile);
        }
        destLogFiles.addAll(extraFiles);
        MLog.info(TAG, "collectLogBySize() : collecting normal logs around this time point(" + collectTimePoint + ")", new Object[0]);
        long intervalTime = 0L;
        long zipSize = 0L;
        for (File file : appLogFiles) {
            if (!this.containsPattern(file)) continue;
            intervalTime = this.parseLogCreateTime(file);
            if (fileList.containsKey(intervalTime)) {
                intervalTime += (long)((int)(Math.random() * 1000.0) + 1);
            }
            fileList.put(intervalTime, file.getAbsolutePath());
        }
        MLog.info(TAG, "fileList:" + fileList.toString(), new Object[0]);
        Iterator iterator = fileList.entrySet().iterator();
        while (iterator.hasNext() && residualSize > 0.0f) {
            Map.Entry entry = iterator.next();
            MLog.info(TAG, "fileList:" + entry.toString(), new Object[0]);
            String value = (String)entry.getValue();
            File f = new File(value);
            if (!f.exists() || f.isDirectory()) continue;
            if (this.checkCompressed(f.getName())) {
                if (!(residualSize - (float)f.length() >= 0.0f)) continue;
                residualSize -= (float)f.length();
                srcLogFiles.add(f);
                continue;
            }
            if (!(residualSize - (float)f.length() * 0.15f >= 0.0f)) continue;
            residualSize -= (float)f.length() * 0.15f;
            srcLogFiles.add(f);
        }
        if (this.getSDFreeSize() <= zipSize * 10L) {
            if (this.listener != null) {
                PerfLog.webLog("mlog", "SD_CARD_NOT_ENOUGH_FREE_SIZE");
            }
            this.listener.onCompressError(-11);
            return false;
        }
        final File temp = new File(tempDir);
        if (temp.exists() && temp.isDirectory()) {
            LogManager.deleteDir(temp);
        }
        ScheduledTask.getInstance().scheduledDelayed(new Runnable(){

            @Override
            public void run() {
                File[] tempFiles;
                MLog.info(LogManager.TAG, "collectLogBySize() : Logs packing task started", new Object[0]);
                if (srcLogFiles.size() > 0) {
                    for (File[] file : srcLogFiles) {
                        if (LogManager.this.checkCompressed(file.getName())) {
                            try {
                                if (file.length() < 200L) {
                                    LogManager.this.removeLogFile((File)file);
                                    PerfLog.webLog("mlog", "\u68c0\u67e5\uff1a\u538b\u7f29\u6587\u4ef6\u957f\u5ea6\u82e5\u5c0f\u4e8e200\u57fa\u672c\u53ef\u5224\u5b9a\u4e3a\u5f02\u5e38\u6587\u4ef6\uff0c\u5220\u9664\uff0c\u9632\u6b62\u89e3\u538b\u65f6\u51fa\u5f02\u5e38");
                                    continue;
                                }
                                LogZipCompress.getInstance().decompress((File)file, tempDir);
                            }
                            catch (Exception e) {
                                PerfLog.webLog("mlog", "printStackTrace " + file.getName() + " removeLogFile(file) " + e.getMessage());
                                MLog.error((Object)LogManager.TAG, "printStackTrace", e.getMessage());
                            }
                            continue;
                        }
                        destLogFiles.add(file);
                    }
                }
                if ((tempFiles = new File(tempDir).listFiles()) != null) {
                    for (File file : tempFiles) {
                        if (destLogFiles.contains(file)) continue;
                        destLogFiles.add(file);
                    }
                }
                MLog.info(LogManager.TAG, "destLogFiles: " + destLogFiles.toString(), new Object[0]);
                if (destLogFiles.size() > 0) {
                    Pair<Integer, String> pack = LogZipCompress.getInstance().compressFiles((List<File>)destLogFiles, (List<File>)sdkLogFiles, uid);
                    if ((Integer)pack.first != 0 || BlankUtil.isBlank((String)pack.second)) {
                        if (LogManager.this.listener != null) {
                            LogManager.this.listener.onCompressError((Integer)pack.first);
                        }
                    } else if (LogManager.this.listener != null) {
                        LogManager.this.listener.onCompressFinished((String)pack.second);
                    }
                }
                LogManager.deleteDir(temp);
                MLog.info(LogManager.TAG, "collectLogBySize() : Logs packing task finished", new Object[0]);
            }
        }, 0L);
        return true;
    }

    public long parseLogCreateTime(File logFile) {
        long time = logFile.lastModified();
        if (logFile.getName().contains(".")) {
            String logName = logFile.getName().substring(0, logFile.getName().indexOf("."));
            Matcher matcherMinute = PATTERN_WITH_MINUTE.matcher(logName);
            if (matcherMinute.find()) {
                String dateStr = logName.substring(matcherMinute.start(), matcherMinute.end());
                try {
                    time = CommonUtils.getSimpleDateFormat(LOG_DATE_WITH_MINUTE_FORMAT_STR).parse(dateStr).getTime();
                }
                catch (ParseException e) {
                    PerfLog.webLog("mlog", "parseLogCreateTime new " + e.getMessage());
                    MLog.error((Object)TAG, "printStackTrace", e.getMessage());
                }
            } else {
                Matcher matcher = PATTERN.matcher(logName);
                if (matcher.find()) {
                    String dateStr = logName.substring(matcher.start(), matcher.end());
                    try {
                        time = CommonUtils.getSimpleDateFormat(LOG_DATE_FORMAT_STR).parse(dateStr).getTime();
                    }
                    catch (ParseException e) {
                        PerfLog.webLog("mlog", "parseLogCreateTime old " + e.getMessage());
                        MLog.error((Object)TAG, "printStackTrace", e.getMessage());
                    }
                }
            }
        }
        return time;
    }

    public boolean containsPattern(File file) {
        String name = file.getName();
        Matcher matcherMinute = PATTERN_WITH_MINUTE.matcher(name);
        if (matcherMinute.find()) {
            return true;
        }
        Matcher matcher = PATTERN.matcher(name);
        return matcher.find();
    }

    public boolean checkCompressed(String fileName) {
        return fileName.endsWith(".zip") || fileName.endsWith(".7z");
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = LogManager.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public long getSDFreeSize() {
        try {
            File path = Environment.getExternalStorageDirectory();
            StatFs sf = new StatFs(path.getPath());
            long blockSize = sf.getBlockSize();
            long freeBlocks = sf.getAvailableBlocks();
            return freeBlocks * blockSize;
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, "getSDFreeSize 0", new Object[0]);
            return 0L;
        }
    }

    static {
        PATTERN = Pattern.compile(PATTERN_STR);
        PATTERN_WITH_MINUTE = Pattern.compile(PATTERN_WITH_MINUTE_STR);
        sDirCrashDump = "/sdcard/com.duowan.mobile/crash/";
    }

    public static interface LogProvider {
        public boolean fillAppLogs(List<File> var1, LogCompressListener var2);

        public boolean fillSdkLogs(List<File> var1, LogCompressListener var2);

        public boolean fillExtraFiles(List<File> var1, LogCompressListener var2);
    }
}

