/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.util.Log;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.io.InputStream;

public class YYImageUtils {
    public static final int IMAGE_COMPRESS_RATE = 75;
    public static final int IMAGE_SCALE_WIDTH = 800;
    public static final int IMAGE_SCALE_HEIGHT = 800;
    private static Bitmap sDefaultMalePhoto = null;
    private static Bitmap sDefaultMalePhotoOffline = null;
    private static Bitmap sDefaultFemalePhotoOffline = null;
    private static Bitmap sDefaultMalePhotoBitmap = null;
    private static Bitmap sDefaultFemalePhotoBitmap = null;

    public static Bitmap decodeFile(String filePath) {
        return YYImageUtils.decodeFile(filePath, null);
    }

    public static Bitmap decodeByWidth(String filePath, int desiredWidth) {
        try {
            return YYImageUtils.decodeFileOrThrow(filePath, desiredWidth, 0);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Bitmap decodeBySize(String filePath, int size) {
        Rect rect = YYImageUtils.decodeBmpSize(filePath);
        if (rect.width() > rect.height()) {
            return YYImageUtils.decodeByWidth(filePath, size);
        }
        return YYImageUtils.decodeByHeight(filePath, size);
    }

    public static Rect decodeBmpSize(String filePath) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opts);
        return new Rect(0, 0, opts.outWidth, opts.outHeight);
    }

    public static Rect decodeBmpSizeBy(String filePath, int desiredWidth, int desiredHeight) {
        BitmapFactory.Options opts = YYImageUtils.getProperOptions(filePath, desiredWidth, desiredHeight, false);
        if (opts == null) {
            return null;
        }
        return new Rect(0, 0, opts.outWidth, opts.outHeight);
    }

    public static Bitmap decodeByHeight(String filePath, int desiredHeight) {
        try {
            return YYImageUtils.decodeFileOrThrow(filePath, 0, desiredHeight);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Bitmap decodeByWidthOrThrow(String filePath, int desiredWidth) {
        return YYImageUtils.decodeFileOrThrow(filePath, desiredWidth, 0);
    }

    public static Bitmap decodeByHeightOrThrow(String filePath, int desiredHeight) {
        return YYImageUtils.decodeFileOrThrow(filePath, 0, desiredHeight);
    }

    public static Bitmap decodeFile(String filePath, int desiredWidth, int desiredHeight) {
        try {
            return YYImageUtils.decodeFileOrThrow(filePath, desiredWidth, desiredHeight);
        }
        catch (Throwable e) {
            MLog.warn("decoeFile", "fail to decode %s, %s", filePath, e.toString());
            return null;
        }
    }

    public static Bitmap decodeResource(Context context, int resId, int desiredWidth, int desiredHeight) {
        if (desiredWidth <= 0 && desiredHeight <= 0) {
            return YYImageUtils.decodeResource(context, resId);
        }
        try {
            return YYImageUtils.decodeResOrThrow(context, resId, desiredWidth, desiredHeight, true);
        }
        catch (Throwable e) {
            MLog.error("YYImageUtils", e);
            return null;
        }
    }

    public static Bitmap decodeResource(Context context, int resId) {
        try {
            Bitmap res = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId);
            return res;
        }
        catch (OutOfMemoryError e) {
            MLog.error("YYImageUtils", e);
            return null;
        }
    }

    public static Bitmap decodeFileOrThrow(String filePath, int desiredWidth, int desiredHeight) {
        return YYImageUtils.decodeFileOrThrow(filePath, desiredWidth, desiredHeight, true);
    }

    public static Bitmap decodeFileOrThrow(String filePath, int desiredWidth, int desiredHeight, boolean isMemoryPrior) {
        BitmapFactory.Options opts = YYImageUtils.getProperOptions(filePath, desiredWidth, desiredHeight, isMemoryPrior);
        if (opts == null) {
            return null;
        }
        opts.inJustDecodeBounds = false;
        Bitmap bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opts);
        return bmp;
    }

    public static BitmapFactory.Options getProperOptions(byte[] data, int desiredWidth, int desiredHeight, boolean isMemoryPrior) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
        if (opts.outWidth <= 0 || opts.outHeight <= 0) {
            return null;
        }
        int sampleSize = YYImageUtils.calSampleSize(desiredWidth, desiredHeight, isMemoryPrior, opts);
        if (desiredHeight > 0 || desiredWidth > 0) {
            do {
                opts.inSampleSize = sampleSize++;
                BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
            } while (desiredWidth > 0 && opts.outWidth > desiredWidth || desiredHeight > 0 && opts.outHeight > desiredHeight);
        }
        return opts;
    }

    private static BitmapFactory.Options getProperOptions(String filePath, int desiredWidth, int desiredHeight, boolean isMemoryPrior) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opts);
        if (opts.outWidth <= 0 || opts.outHeight <= 0) {
            return null;
        }
        int sampleSize = YYImageUtils.calSampleSize(desiredWidth, desiredHeight, isMemoryPrior, opts);
        if (desiredHeight > 0 || desiredWidth > 0) {
            do {
                opts.inSampleSize = sampleSize++;
                BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opts);
            } while (desiredWidth > 0 && opts.outWidth > desiredWidth || desiredHeight > 0 && opts.outHeight > desiredHeight);
        }
        return opts;
    }

    public static Bitmap decodeResOrThrow(Context context, int drawableId, int desiredWidth, int desiredHeight, boolean isMemoryPrior) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        Resources res = context.getResources();
        BitmapFactory.decodeResource((Resources)res, (int)drawableId, (BitmapFactory.Options)opts);
        if (opts.outWidth <= 0 || opts.outHeight <= 0) {
            return null;
        }
        int sampleSize = YYImageUtils.calSampleSize(desiredWidth, desiredHeight, isMemoryPrior, opts);
        opts.inJustDecodeBounds = false;
        opts.inSampleSize = sampleSize;
        Bitmap ret = BitmapFactory.decodeResource((Resources)res, (int)drawableId, (BitmapFactory.Options)opts);
        return ret;
    }

    private static int calSampleSize(int desiredWidth, int desiredHeight, boolean isMemoryPrior, BitmapFactory.Options opts) {
        int sampleSize = 1;
        if (desiredWidth == 0 && desiredHeight == 0) {
            sampleSize = 1;
        } else if (desiredHeight == 0) {
            sampleSize = (opts.outWidth + desiredWidth - 1) / desiredWidth;
        } else if (desiredWidth == 0) {
            sampleSize = (opts.outHeight + desiredHeight - 1) / desiredHeight;
        } else {
            int horRatio = (opts.outWidth + desiredWidth - 1) / desiredWidth;
            int verRatio = (opts.outHeight + desiredHeight - 1) / desiredHeight;
            sampleSize = isMemoryPrior ? Math.max(horRatio, verRatio) : Math.min(horRatio, verRatio);
        }
        return sampleSize;
    }

    public static Bitmap decodeFile(String filePath, BitmapFactory.Options opt) {
        if (StringUtils.isNullOrEmpty(filePath)) {
            return null;
        }
        Bitmap bmp = null;
        try {
            File file = new File(filePath);
            if (file.isFile()) {
                bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opt);
            } else {
                MLog.error(YYImageUtils.class, filePath + " is not a file", new Object[0]);
            }
        }
        catch (OutOfMemoryError err) {
            MLog.error(YYImageUtils.class, "oom: " + filePath, new Object[0]);
            bmp = null;
        }
        return bmp;
    }

    public static Bitmap resizeBitmap(Bitmap bitmap, int maxBorderLength, boolean recycle) {
        float ratio;
        if (bitmap == null) {
            return null;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int newHeight = 0;
        int newWidth = 0;
        if (width > height) {
            ratio = (float)height / (float)width;
            newWidth = maxBorderLength;
            newHeight = (int)((float)newWidth * ratio);
        } else if (height > width) {
            ratio = (float)width / (float)height;
            newHeight = maxBorderLength;
            newWidth = (int)((float)newHeight * ratio);
        } else {
            newWidth = maxBorderLength;
            newHeight = maxBorderLength;
        }
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        try {
            Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            if (recycle && !bitmap.isRecycled() && bitmap != resizedBitmap) {
                bitmap.recycle();
            }
            return resizedBitmap;
        }
        catch (OutOfMemoryError e) {
            MLog.error(YYImageUtils.class, "lcy resizeBitmap OOM %s", e, new Object[0]);
            return null;
        }
    }

    public static boolean resizeAndRotateImage(String imageFile, String newFileName, int maxWidth, int maxHeight, Matrix matrix) {
        return YYImageUtils.resizeAndRotateImage(imageFile, newFileName, maxWidth, maxHeight, matrix, 75);
    }

    public static int calInSampleSize(BitmapFactory.Options options, int destWidth, int destHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > destWidth || width > destHeight) {
            int widthRatio;
            int heightRatio = (int)Math.floor((float)height / (float)destHeight);
            int n = inSampleSize = heightRatio < (widthRatio = (int)Math.floor((float)width / (float)destWidth)) ? heightRatio : widthRatio;
            if (inSampleSize <= 0) {
                inSampleSize = 1;
            }
            while (ImageUtil.isBitmapOverSize(inSampleSize, width, height)) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }

    public static boolean resizeImage(String imageFile, String newFileName, int destWidth, int destHeight, Matrix matrix, int quality) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
        int originWidth = options.outWidth;
        int originHeight = options.outHeight;
        if (originWidth <= 0 || originHeight <= 0) {
            MLog.error(YYImageUtils.class, "bitmap width or height is zero", new Object[0]);
            return false;
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = YYImageUtils.calInSampleSize(options, destWidth, destHeight);
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
            int decodedWidth = bitmap.getWidth();
            int decodedHeight = bitmap.getHeight();
            if (matrix == null) {
                matrix = new Matrix();
            }
            matrix.setScale((float)destWidth / (float)decodedWidth, (float)destHeight / (float)decodedHeight);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)decodedWidth, (int)decodedHeight, (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)"YYImageUtils", (String)"Empty Catch on resizeImage", (Throwable)e);
        }
        if (bitmap != null) {
            try {
                YYFileUtils out = YYFileUtils.openFile(newFileName);
                out.write(bitmap, quality);
                out.close();
                return true;
            }
            catch (Exception e) {
                MLog.error(YYImageUtils.class, e);
            }
        }
        return false;
    }

    public static boolean resizeAndRotateImage(String imageFile, String newFileName, int maxWidth, int maxHeight, Matrix matrix, int quality) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
        int originWidth = options.outWidth;
        int originHeight = options.outHeight;
        if (originWidth <= 0 || originHeight <= 0) {
            MLog.error(YYImageUtils.class, "bitmap width or height is zero", new Object[0]);
            return false;
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = ImageUtil.calculateInSampleSize(options, maxWidth, maxHeight);
        float factor = options.inSampleSize;
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
            int decodedWidth = bitmap.getWidth();
            int decodedHeight = bitmap.getHeight();
            int actualWidth = (int)((float)originWidth / factor);
            int actualHeight = (int)((float)originHeight / factor);
            if (matrix == null) {
                matrix = new Matrix();
            }
            matrix.setScale((float)actualWidth / (float)decodedWidth, (float)actualHeight / (float)decodedHeight);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)decodedWidth, (int)decodedHeight, (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)"YYImageUtils", (String)"Empty Catch on resizeAndRotateImage", (Throwable)e);
        }
        if (bitmap != null) {
            try {
                YYFileUtils out = YYFileUtils.openFile(newFileName);
                out.write(bitmap, quality);
                out.close();
                return true;
            }
            catch (Exception e) {
                MLog.error(YYImageUtils.class, e);
            }
        }
        return false;
    }

    public static int getRotate(String filepath) {
        try {
            ExifInterface exif = new ExifInterface(filepath);
            return exif.getAttributeInt("Orientation", 1);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getAngleFromRotateEnum(int rotate) {
        switch (rotate) {
            case 3: {
                return 180;
            }
            case 6: {
                return 90;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }

    public static Bitmap rotateAndResizeImage(Bitmap inBitmap, int maxWidth, int maxHeight, int rotate) {
        boolean needRotate;
        int imgWidth = inBitmap.getWidth();
        int imgHeight = inBitmap.getHeight();
        boolean needResize = imgWidth > maxWidth || imgHeight > maxHeight;
        boolean bl = needRotate = YYImageUtils.getAngleFromRotateEnum(rotate) != 0;
        if (needResize || needRotate) {
            Matrix matrix = new Matrix();
            if (needResize) {
                float scale = Math.min((float)maxWidth / (float)imgWidth, (float)maxHeight / (float)imgHeight);
                matrix.postScale(scale, scale);
            }
            if (needRotate) {
                matrix.postRotate((float)YYImageUtils.getAngleFromRotateEnum(rotate));
            }
            try {
                Bitmap resultBitmap = Bitmap.createBitmap((Bitmap)inBitmap, (int)0, (int)0, (int)imgWidth, (int)imgHeight, (Matrix)matrix, (boolean)true);
                return resultBitmap;
            }
            catch (OutOfMemoryError e) {
                Log.e((String)"YYImageUtils", (String)"Empty Catch on rotateAndResizeImage", (Throwable)e);
            }
        }
        return inBitmap;
    }

    public static Bitmap decodeImageFromStream(InputStream queryStream, InputStream decodeStream) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)queryStream, null, (BitmapFactory.Options)options);
        if (options.outWidth <= 0 || options.outHeight <= 0) {
            MLog.error(YYImageUtils.class, "bitmap width or height is zero", new Object[0]);
            return null;
        }
        options.inJustDecodeBounds = false;
        int widthScale = options.outWidth / 800;
        int heightScale = options.outHeight / 800;
        options.inSampleSize = widthScale > heightScale ? widthScale : heightScale;
        options.inScaled = false;
        try {
            Bitmap ret = BitmapFactory.decodeStream((InputStream)decodeStream, null, (BitmapFactory.Options)options);
            return ret;
        }
        catch (OutOfMemoryError e) {
            MLog.error((Object)"YYImageUtils", "decodeImageFromStream error, OOM", new Object[0]);
            return null;
        }
    }

    public static boolean saveBitmapToFile(Bitmap bitmap, String filename) throws Exception {
        boolean isSuccess = false;
        if (bitmap != null && filename != null) {
            YYFileUtils out = YYFileUtils.openFile(filename);
            isSuccess = out.write(bitmap, 75);
            out.close();
        }
        return isSuccess;
    }

    public static boolean isImage(InputStream queryStream) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        try {
            BitmapFactory.decodeStream((InputStream)queryStream, null, (BitmapFactory.Options)options);
            return options.outWidth > 0 && options.outHeight > 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isImage(File file) {
        if (file == null) {
            return false;
        }
        return YYImageUtils.isImage(file.getPath());
    }

    public static boolean isImage(String imageFile) {
        if (StringUtils.isNullOrEmpty(imageFile)) {
            return false;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        try {
            BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
            return options.outWidth > 0 && options.outHeight > 0;
        }
        catch (Throwable e) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose("YYImageUtils", "%d isn't image file", imageFile);
            }
            return false;
        }
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap, float roundPx) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color2 = -1;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-1);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static boolean isNotDefaultPortrait(Bitmap image) {
        return image != sDefaultFemalePhotoBitmap && image != sDefaultMalePhotoBitmap && image != sDefaultMalePhotoOffline && image != sDefaultFemalePhotoOffline && image != sDefaultMalePhoto && image != sDefaultMalePhotoOffline;
    }

    public static Bitmap getGrayBmp(Bitmap image) {
        if (image != null) {
            try {
                Bitmap grayscalBitmap = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
                Canvas canvas = new Canvas(grayscalBitmap);
                Paint paint = new Paint();
                ColorMatrix matrix = new ColorMatrix();
                matrix.setSaturation(0.0f);
                ColorMatrixColorFilter filter = new ColorMatrixColorFilter(matrix);
                paint.setColorFilter((ColorFilter)filter);
                canvas.drawBitmap(image, 0.0f, 0.0f, paint);
                return grayscalBitmap;
            }
            catch (Exception e) {
                MLog.error("Utils.getGrayBmp", e);
            }
            catch (OutOfMemoryError e) {
                MLog.error("Utils.getGrayBmp", e);
            }
        }
        return null;
    }

    public static Bitmap createClipBitmap(Bitmap bmp, Rect photoRect) {
        Bitmap portrait;
        block5: {
            portrait = null;
            try {
                if (bmp != null) {
                    int bmpWidth = bmp.getWidth();
                    int bmpHeight = bmp.getHeight();
                    if (bmpWidth > 0 && bmpHeight > 0) {
                        photoRect.right = photoRect.right > bmpWidth ? bmpWidth : photoRect.right;
                        photoRect.bottom = photoRect.bottom > bmpHeight ? bmpHeight : photoRect.bottom;
                        portrait = Bitmap.createBitmap((Bitmap)bmp, (int)photoRect.left, (int)photoRect.top, (int)photoRect.width(), (int)photoRect.height());
                        if (bmp != portrait && !bmp.isRecycled()) {
                            bmp.recycle();
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (!MLog.isLogLevelAboveDebug()) break block5;
                MLog.debug("hjinw", "e = " + e, new Object[0]);
            }
        }
        return portrait;
    }

    public static boolean renameFile(String oriPath, String newPath) {
        File file = new File(oriPath);
        File newFile = new File(newPath);
        return file.renameTo(newFile);
    }

    public static Bitmap decodeResource(Context context, int resId, BitmapFactory.Options opt) {
        try {
            Bitmap res = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)opt);
            return res;
        }
        catch (OutOfMemoryError e) {
            MLog.error("lcy", e);
            return null;
        }
    }

    public static Bitmap createBlended(Bitmap src) {
        if (src == null) {
            throw new IllegalArgumentException("Given src is null.");
        }
        Bitmap target = Bitmap.createBitmap((int)src.getWidth(), (int)src.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(target);
        c.drawBitmap(src, 0.0f, 0.0f, null);
        c.drawColor(-1895825408);
        return target;
    }

    public static Bitmap resize(Bitmap oriBitmap, int targetWidth, int targetHeight) {
        int height;
        float scaleHeight;
        if (oriBitmap == null) {
            return null;
        }
        int width = oriBitmap.getWidth();
        float scaleWidth = (float)targetWidth / (float)width;
        float scale = scaleWidth > (scaleHeight = (float)targetHeight / (float)(height = oriBitmap.getHeight())) ? scaleHeight : scaleWidth;
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        try {
            Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)oriBitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            return resizedBitmap;
        }
        catch (OutOfMemoryError e) {
            MLog.error(YYImageUtils.class, "resizeBitmap OOM %s", e, new Object[0]);
            return null;
        }
    }

    public static Bitmap resize(Bitmap oriBitmap, float scale) {
        if (oriBitmap == null) {
            return null;
        }
        int width = oriBitmap.getWidth();
        int height = oriBitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        try {
            Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)oriBitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            oriBitmap.recycle();
            return resizedBitmap;
        }
        catch (OutOfMemoryError e) {
            oriBitmap.recycle();
            MLog.error(YYImageUtils.class, "resizeBitmap OOM %s", e, new Object[0]);
            return null;
        }
    }

    public static int getCameraPhotoOrientation(String imagePath) {
        int rotate = 0;
        try {
            File imageFile = new File(imagePath);
            ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
            int orientation = exif.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 6: {
                    rotate = 90;
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"YYImageUtils", (String)"printStackTrace", (Throwable)e);
        }
        return rotate;
    }

    public static Bitmap fixPictureOrientation(String path, boolean replaceSrcFile, ImageConfig imageConfig, int quality) {
        Bitmap bitmap = ImageUtil.decodeSampledBitmapFile(path, imageConfig, true);
        if (replaceSrcFile) {
            try {
                String extension = YYFileUtils.getFileExtension(path);
                Bitmap.CompressFormat format = Bitmap.CompressFormat.JPEG;
                if (extension != null && extension.equalsIgnoreCase(".png")) {
                    format = Bitmap.CompressFormat.PNG;
                }
                YYFileUtils.saveBitmap(bitmap, path, format, quality);
            }
            catch (Throwable throwable) {
                MLog.error((Object)"YYImageUtils", "fixPictureOrientation saveBitmap error! " + throwable, new Object[0]);
            }
        }
        return bitmap;
    }

    public static int getPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)"YYImageUtils", "getPictureDegree error!" + throwable, new Object[0]);
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug("YYImageUtils", "getPictureDegree path:" + path + ", degree = " + degree, new Object[0]);
        }
        return degree;
    }

    public static interface PORTRAIT_OPS {
        public static final int SMALL = 0;
        public static final int BIG = 1;
        public static final int ORIGINAL = 2;
    }
}

