/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.os.Build;
import android.os.StrictMode;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.log.MLog;

public class StrictModeUtil {
    public static void openStrictMode() {
        if (BasicConfig.getInstance().isDebuggable() && Build.VERSION.SDK_INT >= 9) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug("StrictModeUtil", "Open StrictMode.", new Object[0]);
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectDiskReads().detectDiskWrites().detectNetwork().penaltyLog().build());
            StrictMode.VmPolicy.Builder vmBuilder = new StrictMode.VmPolicy.Builder().detectLeakedSqlLiteObjects().penaltyLog();
            if (Build.VERSION.SDK_INT >= 11) {
                vmBuilder.detectLeakedClosableObjects();
                vmBuilder.detectActivityLeaks();
            }
            if (Build.VERSION.SDK_INT >= 16) {
                vmBuilder.detectLeakedRegistrationObjects();
            }
            if (Build.VERSION.SDK_INT >= 18) {
                vmBuilder.detectFileUriExposure();
            }
            StrictMode.setVmPolicy((StrictMode.VmPolicy)vmBuilder.build());
        }
    }

    public static void stopStrictMode() {
        if (BasicConfig.getInstance().isDebuggable() && Build.VERSION.SDK_INT >= 9) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug("StrictModeUtil", "Stop StrictMode.", new Object[0]);
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().permitAll().build());
            StrictMode.setVmPolicy((StrictMode.VmPolicy)new StrictMode.VmPolicy.Builder().build());
        }
    }
}

