/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import tv.athena.util.ProcessorUtils;
import tv.athena.util.RuntimeInfo;

@SuppressLint(value={"SimpleDateFormat"})
public class Logger {
    private static ConcurrentHashMap<String, Logger> loggers = new ConcurrentHashMap();
    private static LoggerThread loggerThread;
    private static LogConfig config;
    private static List<String> logList;
    private String myTag;

    private Logger(String tag) {
        this.myTag = tag;
    }

    public String getTag() {
        return this.myTag;
    }

    public static void init(LogConfig cfg) {
        Logger.info("Logger", "init Logger");
        config = new LogConfig(cfg);
        RuntimeInfo.INSTANCE.appContext(BasicConfig.getInstance().getAppContext()).packageName(BasicConfig.getInstance().getAppContext().getPackageName()).processName(ProcessorUtils.INSTANCE.getMyProcessName()).isDebuggable(BasicConfig.getInstance().isDebuggable()).isMainProcess(FP.eq(RuntimeInfo.sPackageName, RuntimeInfo.sProcessName));
        Logger.initMLog(config);
    }

    public static void initMLog(LogConfig cfg) {
        if (cfg.policy != LogFilePolicy.NoLogFile) {
            String logDir = cfg.dir;
            MLog.LogOptions options = new MLog.LogOptions();
            options.logLevel = BasicConfig.getInstance().isDebuggable() ? 1 : 3;
            options.honorVerbose = false;
            options.logFileName = "logs.txt";
            MLog.initialize(logDir, options);
            MLog.info("Logger", "init MLog, logFilePath = " + logDir + File.separator + options.logFileName, new Object[0]);
        }
    }

    public static Logger getLogger(String tag) {
        Logger logger;
        if (StringUtils.isEmptyString(tag)) {
            tag = "Default";
        }
        try {
            logger = loggers.get(tag);
            if (logger == null) {
                logger = new Logger(tag);
                loggers.put(tag, logger);
            }
        }
        catch (Exception e) {
            MLog.error((Object)"Logger", "getLogger error! " + e, new Object[0]);
            logger = new Logger(tag);
        }
        return logger;
    }

    public static Logger getLogger(Class<?> cls) {
        if (cls == null) {
            return Logger.getLogger("");
        }
        return Logger.getLogger(cls.getSimpleName());
    }

    private static boolean isLoggable(LogLevel level) {
        return level.compareTo(Logger.config.outputLevel) >= 0;
    }

    private static String levelToString(LogLevel level) {
        String str = "";
        switch (level) {
            case Debug: {
                str = "Debug";
                break;
            }
            case Error: {
                str = "Error";
                break;
            }
            case Info: {
                str = "Info";
                break;
            }
            case Verbose: {
                str = "Verbose";
                break;
            }
            case Warn: {
                str = "Warn";
                break;
            }
            default: {
                str = "Debug";
            }
        }
        return str;
    }

    public static String getLogFilePath() {
        if (loggerThread != null) {
            return loggerThread.getFilePath();
        }
        return null;
    }

    private static void logToFile(String tag, LogLevel level, String message, Throwable t) {
        if (Logger.config.policy != LogFilePolicy.NoLogFile) {
            if (loggerThread == null || !loggerThread.isReady()) {
                logList.add(LoggerThread.getFormattedString(tag, level, message));
            } else {
                loggerThread.logToFile(tag, level, message, t);
            }
        }
    }

    public static void log(String tag, LogLevel level, String message) {
        if (Logger.isLoggable(level)) {
            message = Logger.msgForTextLog(tag, message);
            switch (level) {
                case Debug: {
                    MLog.debugWithoutLineNumber(tag, message, new Object[0]);
                    break;
                }
                case Error: {
                    MLog.errorWithoutLineNumber((Object)tag, message, new Object[0]);
                    break;
                }
                case Info: {
                    MLog.infoWithoutLineNumber(tag, message, new Object[0]);
                    break;
                }
                case Verbose: {
                    MLog.verboseWithoutLineNumber(tag, message, new Object[0]);
                    break;
                }
                case Warn: {
                    MLog.warnWithoutLineNumber(tag, message, new Object[0]);
                    break;
                }
                default: {
                    MLog.debugWithoutLineNumber(tag, message, new Object[0]);
                }
            }
        }
    }

    private static void logError(String tag, String msg, Throwable tr) {
        if (Logger.isLoggable(LogLevel.Error)) {
            if (tr == null) {
                MLog.error((Object)tag, msg, new Object[0]);
            } else {
                MLog.error((Object)tag, msg, tr, new Object[0]);
            }
        }
    }

    private static String msgForTextLog(String tag, String message) {
        if (message == null) {
            message = "null";
        }
        int line = -1;
        String filename = "";
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(tag);
        sb.append("] ");
        sb.append(message);
        sb.append("(P:");
        sb.append(Process.myPid());
        sb.append(")");
        sb.append("(T:");
        if (Looper.getMainLooper() == Looper.myLooper()) {
            sb.append("Main&");
        } else {
            sb.append(Thread.currentThread().getId());
        }
        sb.append(")");
        if (filename != null) {
            sb.append(" at (");
            sb.append(filename);
        }
        if (line > 0) {
            sb.append(":");
            sb.append(line);
            sb.append(")");
        }
        return sb.toString();
    }

    public static void verbose(String tag, String message) {
        Logger.log(tag, LogLevel.Verbose, message);
    }

    public static void debug(String tag, String message) {
        Logger.log(tag, LogLevel.Debug, message);
    }

    public static void info(String tag, String message) {
        Logger.log(tag, LogLevel.Info, message);
    }

    public static void warn(String tag, String message) {
        Logger.log(tag, LogLevel.Warn, message);
    }

    public static void error(String tag, String message) {
        Logger.log(tag, LogLevel.Error, message);
    }

    public static void error(String tag, String message, Throwable throwable) {
        Logger.logError(tag, message, throwable);
    }

    public void verbose(String message) {
        Logger.verbose(this.myTag, message);
    }

    public void debug(String message) {
        Logger.debug(this.myTag, message);
    }

    public void info(String message) {
        Logger.info(this.myTag, message);
    }

    public void warn(String message) {
        Logger.warn(this.myTag, message);
    }

    public void error(String message) {
        Logger.error(this.myTag, message);
    }

    public void error(String message, Throwable throwable) {
        Logger.logError(this.myTag, message, throwable);
    }

    public static void onTerminate() {
        if (loggerThread != null) {
            loggerThread.sendFlush();
        }
    }

    static {
        config = new LogConfig();
        logList = Collections.synchronizedList(new ArrayList());
    }

    private static class LoggerThread
    extends Thread {
        private static final int LogMessageType = 0;
        private static final int TimerMessageType = 1;
        private static final int LogThrowableType = 2;
        private static final int FlushLog = 3;
        private LogThreadHandler handler;
        private LogConfig config;
        private String filePath;
        private boolean isReady = false;

        public LoggerThread(String name, LogConfig cfg) {
            super(name);
            this.config = cfg;
        }

        public boolean isReady() {
            return this.isReady;
        }

        private static String getFormattedString(String tag, LogLevel level, String msg) {
            String thread = Looper.getMainLooper() == Looper.myLooper() ? "[Main]" : "[" + Thread.currentThread().getId() + "]";
            String strLevel = "[" + Logger.levelToString(level) + "]";
            String logMsg = thread + "[" + tag + "]" + strLevel + " " + msg;
            return logMsg;
        }

        public void logToFile(String tag, LogLevel level, String msg, Throwable t) {
            if (this.config.policy != LogFilePolicy.NoLogFile && level.compareTo(this.config.fileLevel) >= 0 && this.handler != null) {
                String logMsg = LoggerThread.getFormattedString(tag, level, msg);
                Message threadMessage = null;
                if (t == null) {
                    threadMessage = this.handler.obtainMessage(0);
                    threadMessage.obj = logMsg;
                } else {
                    threadMessage = this.handler.obtainMessage(2);
                    threadMessage.obj = logMsg;
                    Bundle b = new Bundle();
                    b.putSerializable("throwable", (Serializable)t);
                    threadMessage.setData(b);
                }
                if (threadMessage != null) {
                    this.handler.sendMessage(threadMessage);
                }
            }
        }

        public void sendFlush() {
            if (this.handler != null) {
                this.handler.sendEmptyMessage(3);
            }
        }

        public String getFilePath() {
            return this.filePath;
        }

        @Override
        public void run() {
            Looper.prepare();
            File logDir = new File(this.config.dir);
            if (!logDir.exists()) {
                Logger.info("Logger", "create log dir: " + logDir.getAbsolutePath());
                logDir.mkdirs();
            }
            SimpleDateFormat f = this.config.policy == LogFilePolicy.PerLaunch ? CommonUtils.getSimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS") : CommonUtils.getSimpleDateFormat("yyyy-MM-dd");
            this.filePath = this.config.dir + "/" + f.format(new Date()) + ".log";
            Logger.info("Logger", "log file name: " + this.filePath);
            this.handler = new LogThreadHandler(this);
            this.isReady = true;
            ArrayList list = new ArrayList(logList);
            try {
                if (list.size() > 0) {
                    Logger.debug("Logger", "write logs before logger thread ready to file: " + list.size());
                    for (String s : list) {
                        this.handler.writeLine(s);
                    }
                    this.handler.flush(true);
                }
            }
            catch (IOException e) {
                Log.e((String)"Logger", (String)"printStackTrace", (Throwable)e);
            }
            logList.clear();
            list.clear();
            list = null;
            Looper.loop();
        }

        private static class LogThreadHandler
        extends Handler {
            private SimpleDateFormat dateFormat;
            private BufferedWriter writer;
            private LoggerThread loggerThread;
            private int logCounter;
            private long lastFlushTime;

            private void writeLine(String formattedStr) throws IOException {
                if (this.writer != null) {
                    this.writer.write(this.dateFormat.format(new Date()) + " " + formattedStr);
                    this.writer.newLine();
                }
            }

            public LogThreadHandler(LoggerThread thread) {
                this.loggerThread = thread;
                this.dateFormat = CommonUtils.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                boolean append = ((LoggerThread)this.loggerThread).config.policy != LogFilePolicy.PerLaunch;
                try {
                    FileWriter fw = new FileWriter(this.loggerThread.filePath, append);
                    this.writer = new BufferedWriter(fw);
                    if (((LoggerThread)this.loggerThread).config.policy == LogFilePolicy.PerDay) {
                        this.writer.newLine();
                    }
                    this.writeLine(LoggerThread.getFormattedString("Logger", ((LoggerThread)this.loggerThread).config.fileLevel, "---------------------Log Begin---------------------"));
                    this.flush(true);
                }
                catch (IOException e) {
                    this.writer = null;
                    Log.e((String)"Logger", (String)"printStackTrace", (Throwable)e);
                }
                if (this.writer != null && ((LoggerThread)this.loggerThread).config.fileFlushInterval > 0) {
                    long time = ((LoggerThread)this.loggerThread).config.fileFlushInterval * 1000;
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            Message msg = LogThreadHandler.this.obtainMessage(1);
                            LogThreadHandler.this.sendMessage(msg);
                        }
                    }, time, time);
                }
            }

            public void flush(boolean force) throws IOException {
                if (this.writer != null) {
                    long now = System.currentTimeMillis();
                    if (now - this.lastFlushTime > (long)(((LoggerThread)this.loggerThread).config.fileFlushMinInterval * 1000)) {
                        this.writer.flush();
                        this.lastFlushTime = System.currentTimeMillis();
                        this.logCounter = 0;
                    } else {
                        ++this.logCounter;
                    }
                }
            }

            public void flushIfNeeded() throws IOException {
                if (this.logCounter > ((LoggerThread)this.loggerThread).config.fileFlushCount) {
                    this.flush(false);
                } else {
                    ++this.logCounter;
                }
            }

            public void handleMessage(Message msg) {
                if (this.writer == null) {
                    return;
                }
                try {
                    switch (msg.what) {
                        case 0: {
                            this.writeLine((String)msg.obj);
                            this.flushIfNeeded();
                            break;
                        }
                        case 2: {
                            this.writeLine((String)msg.obj);
                            Bundle data = msg.getData();
                            if (data != null) {
                                Throwable t = (Throwable)data.getSerializable("throwable");
                                if (t != null) {
                                    PrintWriter pw = new PrintWriter(this.writer);
                                    t.printStackTrace(pw);
                                    this.writer.newLine();
                                    this.flush(true);
                                    break;
                                }
                                this.flushIfNeeded();
                                break;
                            }
                            this.flushIfNeeded();
                            break;
                        }
                        case 1: {
                            this.flush(false);
                            break;
                        }
                        case 3: {
                            this.flush(true);
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    Log.e((String)"Logger", (String)"printStackTrace", (Throwable)e);
                }
            }
        }
    }

    public static class LogConfig {
        public String dir;
        public LogFilePolicy policy;
        public LogLevel outputLevel;
        public LogLevel fileLevel;
        public int fileFlushCount;
        public int fileFlushInterval;
        public int fileFlushMinInterval;

        public LogConfig() {
            this.policy = LogFilePolicy.PerLaunch;
            this.outputLevel = LogLevel.Verbose;
            this.fileLevel = LogLevel.Info;
            this.fileFlushCount = 10;
            this.fileFlushInterval = 60;
            this.fileFlushMinInterval = 10;
        }

        public LogConfig(LogConfig cfg) {
            this.dir = cfg.dir;
            this.policy = cfg.policy;
            this.outputLevel = cfg.outputLevel;
            this.fileLevel = cfg.fileLevel;
            this.fileFlushCount = cfg.fileFlushCount;
            this.fileFlushInterval = cfg.fileFlushInterval;
            this.fileFlushMinInterval = cfg.fileFlushMinInterval;
        }
    }

    public static enum LogFilePolicy {
        NoLogFile,
        PerDay,
        PerLaunch;

    }

    public static enum LogLevel {
        Verbose,
        Debug,
        Info,
        Warn,
        Error;

    }
}

