/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.toast;

import android.content.Context;
import android.content.ContextWrapper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Toast;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.widget.toast.BadTokenListener;
import com.yy.mobile.util.log.MLog;

final class SafeToastContext
extends ContextWrapper {
    @NonNull
    private Toast toast;
    @Nullable
    private BadTokenListener badTokenListener;

    SafeToastContext(@NonNull Context base, @NonNull Toast toast) {
        super(base.getApplicationContext());
        this.toast = toast;
    }

    public Context getApplicationContext() {
        return new ApplicationContextWrapper(this.getBaseContext().getApplicationContext());
    }

    public void setBadTokenListener(@NonNull BadTokenListener badTokenListener) {
        this.badTokenListener = badTokenListener;
    }

    private final class WindowManagerWrapper
    implements WindowManager {
        private static final String TAG = "WindowManagerWrapper";
        @NonNull
        private final WindowManager base;

        private WindowManagerWrapper(WindowManager base) {
            this.base = base;
        }

        public Display getDefaultDisplay() {
            return this.base.getDefaultDisplay();
        }

        public void removeViewImmediate(View view) {
            this.base.removeViewImmediate(view);
        }

        public void addView(View view, ViewGroup.LayoutParams params) {
            block6: {
                try {
                    Log.d((String)TAG, (String)"WindowManager's addView(view, params) has been hooked.");
                    this.base.addView(view, params);
                }
                catch (Throwable e) {
                    Log.i((String)TAG, (String)e.getMessage());
                    if (e instanceof WindowManager.BadTokenException && SafeToastContext.this.badTokenListener != null) {
                        SafeToastContext.this.badTokenListener.onBadTokenCaught(SafeToastContext.this.toast);
                    }
                    try {
                        if (view != null) {
                            this.base.removeViewImmediate(view);
                        }
                    }
                    catch (Throwable t) {
                        MLog.info(TAG, "t:" + t, new Object[0]);
                    }
                    if (!BasicConfig.getInstance().isDebuggable() || e instanceof WindowManager.BadTokenException) break block6;
                    MLog.info(TAG, "\u95ee\u9898\u89e3\u51b3\u4e86", new Object[0]);
                }
            }
        }

        public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
            this.base.updateViewLayout(view, params);
        }

        public void removeView(View view) {
            this.base.removeView(view);
        }
    }

    private final class ApplicationContextWrapper
    extends ContextWrapper {
        private ApplicationContextWrapper(Context base) {
            super(base);
        }

        public Object getSystemService(@NonNull String name) {
            if ("window".equals(name)) {
                return new WindowManagerWrapper((WindowManager)this.getBaseContext().getSystemService(name));
            }
            return super.getSystemService(name);
        }
    }
}

