/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.switchbutton;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.CompoundButton;
import com.yy.mobile.framework.R;
import com.yy.mobile.ui.widget.switchbutton.method.AllCapsTransformationMethod;
import com.yy.mobile.ui.widget.switchbutton.method.TransformationMethodCompat2;
import com.yy.mobile.util.log.MLog;

public class Switch
extends CompoundButton {
    private static final String TAG = "Switch";
    private static final int TOUCH_MODE_IDLE = 0;
    private static final int TOUCH_MODE_DOWN = 1;
    private static final int TOUCH_MODE_DRAGGING = 2;
    private static final int SANS = 1;
    private static final int SERIF = 2;
    private static final int MONOSPACE = 3;
    private Drawable mThumbDrawable;
    private Drawable mTrackDrawable;
    private int mThumbTextPadding;
    private int mSwitchMinWidth;
    private int mSwitchPadding;
    private CharSequence mTextOn;
    private CharSequence mTextOff;
    private int mTouchMode;
    private int mTouchSlop;
    private float mTouchX;
    private float mTouchY;
    private VelocityTracker mVelocityTracker = VelocityTracker.obtain();
    private int mMinFlingVelocity;
    private float mThumbPosition;
    private int mSwitchWidth;
    private int mSwitchHeight;
    private int mThumbWidth;
    private int mSwitchLeft;
    private int mSwitchTop;
    private int mSwitchRight;
    private int mSwitchBottom;
    private TextPaint mTextPaint;
    private ColorStateList mTextColors;
    private Layout mOnLayout;
    private Layout mOffLayout;
    private TransformationMethodCompat2 mSwitchTransformationMethod;
    private final Rect mTempRect = new Rect();
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};

    public Switch(Context context) {
        this(context, null);
    }

    public Switch(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.switch_switchStyle);
    }

    public Switch(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mTextPaint = new TextPaint(1);
        Resources res = this.getResources();
        this.mTextPaint.density = res.getDisplayMetrics().density;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Switch, defStyle, 0);
        this.mThumbDrawable = a.getDrawable(R.styleable.Switch_switch_thumb);
        this.mTrackDrawable = a.getDrawable(R.styleable.Switch_switch_track);
        this.mTextOn = a.getText(R.styleable.Switch_switch_textOn);
        this.mTextOff = a.getText(R.styleable.Switch_switch_textOff);
        this.mThumbTextPadding = a.getDimensionPixelSize(R.styleable.Switch_switch_thumbTextPadding, 0);
        this.mSwitchMinWidth = a.getDimensionPixelSize(R.styleable.Switch_switch_switchMinWidth, 0);
        this.mSwitchPadding = a.getDimensionPixelSize(R.styleable.Switch_switch_switchPadding, 0);
        int appearance = a.getResourceId(R.styleable.Switch_switch_switchTextAppearance, 0);
        if (appearance != 0) {
            this.setSwitchTextAppearance(context, appearance);
        }
        a.recycle();
        ViewConfiguration config = ViewConfiguration.get((Context)context);
        this.mTouchSlop = config.getScaledTouchSlop();
        this.mMinFlingVelocity = config.getScaledMinimumFlingVelocity();
        this.refreshDrawableState();
        this.setChecked(this.isChecked());
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
    }

    public void setSwitchTextAppearance(Context context, int resid) {
        TypedArray appearance = context.obtainStyledAttributes(resid, R.styleable.TextAppearanceSwitch);
        ColorStateList colors = appearance.getColorStateList(R.styleable.TextAppearanceSwitch_textColor);
        this.mTextColors = colors != null ? colors : this.getTextColors();
        int ts = appearance.getDimensionPixelSize(R.styleable.TextAppearanceSwitch_textSize, 0);
        if (ts != 0 && (float)ts != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize((float)ts);
            this.requestLayout();
        }
        int typefaceIndex = appearance.getInt(R.styleable.TextAppearanceSwitch_typeface, -1);
        int styleIndex = appearance.getInt(R.styleable.TextAppearanceSwitch_textStyle, -1);
        this.setSwitchTypefaceByIndex(typefaceIndex, styleIndex);
        boolean allCaps = appearance.getBoolean(R.styleable.TextAppearanceSwitch_atextAllCaps, false);
        if (allCaps) {
            this.mSwitchTransformationMethod = new AllCapsTransformationMethod(this.getContext());
            this.mSwitchTransformationMethod.setLengthChangesAllowed(true);
        } else {
            this.mSwitchTransformationMethod = null;
        }
        appearance.recycle();
    }

    private void setSwitchTypefaceByIndex(int typefaceIndex, int styleIndex) {
        Typeface tf = null;
        switch (typefaceIndex) {
            case 1: {
                tf = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                tf = Typeface.SERIF;
                break;
            }
            case 3: {
                tf = Typeface.MONOSPACE;
                break;
            }
        }
        this.setSwitchTypeface(tf, styleIndex);
    }

    public void setSwitchTypeface(Typeface tf, int style2) {
        if (style2 > 0) {
            tf = tf == null ? Typeface.defaultFromStyle((int)style2) : Typeface.create((Typeface)tf, (int)style2);
            this.setSwitchTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style2 & ~typefaceStyle;
            this.mTextPaint.setFakeBoldText((need & 1) != 0);
            this.mTextPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setSwitchTypeface(tf);
        }
    }

    public void setSwitchTypeface(Typeface tf) {
        if (this.mTextPaint.getTypeface() != tf) {
            this.mTextPaint.setTypeface(tf);
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setSwitchPadding(int pixels) {
        this.mSwitchPadding = pixels;
        this.requestLayout();
    }

    public int getSwitchPadding() {
        return this.mSwitchPadding;
    }

    public void setSwitchMinWidth(int pixels) {
        this.mSwitchMinWidth = pixels;
        this.requestLayout();
    }

    public int getSwitchMinWidth() {
        return this.mSwitchMinWidth;
    }

    public void setThumbTextPadding(int pixels) {
        this.mThumbTextPadding = pixels;
        this.requestLayout();
    }

    public int getThumbTextPadding() {
        return this.mThumbTextPadding;
    }

    public void setTrackDrawable(Drawable track) {
        this.mTrackDrawable = track;
        this.requestLayout();
    }

    public void setTrackResource(int resId) {
        this.setTrackDrawable(this.getContext().getResources().getDrawable(resId));
    }

    public Drawable getTrackDrawable() {
        return this.mTrackDrawable;
    }

    public void setThumbDrawable(Drawable thumb) {
        this.mThumbDrawable = thumb;
        this.requestLayout();
    }

    public void setThumbResource(int resId) {
        this.setThumbDrawable(this.getContext().getResources().getDrawable(resId));
    }

    public Drawable getThumbDrawable() {
        return this.mThumbDrawable;
    }

    public CharSequence getTextOn() {
        return this.mTextOn;
    }

    public void setTextOn(CharSequence textOn) {
        this.mTextOn = textOn;
        this.requestLayout();
    }

    public CharSequence getTextOff() {
        return this.mTextOff;
    }

    public void setTextOff(CharSequence textOff) {
        this.mTextOff = textOff;
        this.requestLayout();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        try {
            if (this.mOnLayout == null) {
                this.mOnLayout = this.makeLayout(this.mTextOn);
            }
            if (this.mOffLayout == null) {
                this.mOffLayout = this.makeLayout(this.mTextOff);
            }
            this.mTrackDrawable.getPadding(this.mTempRect);
            int maxTextWidth = Math.max(this.mOnLayout.getWidth(), this.mOffLayout.getWidth());
            int switchWidth = Math.max(this.mSwitchMinWidth, maxTextWidth * 2 + this.mThumbTextPadding * 4 + this.mTempRect.left + this.mTempRect.right);
            int switchHeight = this.mTrackDrawable.getIntrinsicHeight();
            this.mThumbWidth = maxTextWidth + this.mThumbTextPadding * 2;
            this.mSwitchWidth = switchWidth;
            this.mSwitchHeight = switchHeight;
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            int measuredHeight = this.getMeasuredHeight();
            if (measuredHeight < switchHeight) {
                this.setMeasuredDimension(this.getMeasuredWidth(), switchHeight);
            }
        }
        catch (Throwable throwable) {
            MLog.error(TAG, throwable);
        }
    }

    private Layout makeLayout(CharSequence text) {
        CharSequence transformed = this.mSwitchTransformationMethod != null ? this.mSwitchTransformationMethod.getTransformation(text, (View)this) : text;
        float desiredWidth = 0.0f;
        if (this.mTextPaint != null && transformed != null) {
            desiredWidth = Layout.getDesiredWidth((CharSequence)transformed, (TextPaint)this.mTextPaint);
        }
        return new StaticLayout(transformed, this.mTextPaint, (int)Math.ceil(desiredWidth), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
    }

    private boolean hitThumb(float x, float y) {
        this.mThumbDrawable.getPadding(this.mTempRect);
        int thumbTop = this.mSwitchTop - this.mTouchSlop;
        int thumbLeft = this.mSwitchLeft + (int)(this.mThumbPosition + 0.5f) - this.mTouchSlop;
        int thumbRight = thumbLeft + this.mThumbWidth + this.mTempRect.left + this.mTempRect.right + this.mTouchSlop;
        int thumbBottom = this.mSwitchBottom + this.mTouchSlop;
        return x > (float)thumbLeft && x < (float)thumbRight && y > (float)thumbTop && y < (float)thumbBottom;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getActionMasked();
        block0 : switch (action) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                if (!this.isEnabled() || !this.hitThumb(x, y)) break;
                this.mTouchMode = 1;
                this.mTouchX = x;
                this.mTouchY = y;
                break;
            }
            case 2: {
                switch (this.mTouchMode) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        float x = ev.getX();
                        float y = ev.getY();
                        if (!(Math.abs(x - this.mTouchX) > (float)this.mTouchSlop) && !(Math.abs(y - this.mTouchY) > (float)this.mTouchSlop)) break block0;
                        this.mTouchMode = 2;
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                        this.mTouchX = x;
                        this.mTouchY = y;
                        return true;
                    }
                    case 2: {
                        float x = ev.getX();
                        float dx = x - this.mTouchX;
                        float newPos = Math.max(0.0f, Math.min(this.mThumbPosition + dx, (float)this.getThumbScrollRange()));
                        if (newPos != this.mThumbPosition) {
                            this.mThumbPosition = newPos;
                            this.mTouchX = x;
                            this.invalidate();
                        }
                        return true;
                    }
                }
                break;
            }
            case 1: 
            case 3: {
                if (this.mTouchMode == 2) {
                    this.stopDrag(ev);
                    return true;
                }
                this.mTouchMode = 0;
                this.mVelocityTracker.clear();
                break;
            }
        }
        return super.onTouchEvent(ev);
    }

    private void cancelSuperTouch(MotionEvent ev) {
        MotionEvent cancel = MotionEvent.obtain((MotionEvent)ev);
        cancel.setAction(3);
        super.onTouchEvent(cancel);
        cancel.recycle();
    }

    private void stopDrag(MotionEvent ev) {
        this.mTouchMode = 0;
        boolean commitChange = ev.getAction() == 1 && this.isEnabled();
        this.cancelSuperTouch(ev);
        if (commitChange) {
            this.mVelocityTracker.computeCurrentVelocity(1000);
            float xvel = this.mVelocityTracker.getXVelocity();
            boolean newState = Math.abs(xvel) > (float)this.mMinFlingVelocity ? xvel > 0.0f : this.getTargetCheckedState();
            this.animateThumbToCheckedState(newState);
        } else {
            this.animateThumbToCheckedState(this.isChecked());
        }
    }

    private void animateThumbToCheckedState(boolean newCheckedState) {
        this.setChecked(newCheckedState);
    }

    private boolean getTargetCheckedState() {
        return this.mThumbPosition >= (float)(this.getThumbScrollRange() / 2);
    }

    private void setThumbPosition(boolean checked) {
        this.mThumbPosition = checked ? (float)this.getThumbScrollRange() : 0.0f;
    }

    public void setChecked(boolean checked) {
        super.setChecked(checked);
        this.setThumbPosition(this.isChecked());
        this.invalidate();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.setThumbPosition(this.isChecked());
        int switchRight = this.getWidth() - this.getPaddingRight();
        int switchLeft = switchRight - this.mSwitchWidth;
        int switchTop = 0;
        int switchBottom = 0;
        switch (this.getGravity() & 0x70) {
            default: {
                switchTop = this.getPaddingTop();
                switchBottom = switchTop + this.mSwitchHeight;
                break;
            }
            case 16: {
                switchTop = (this.getPaddingTop() + this.getHeight() - this.getPaddingBottom()) / 2 - this.mSwitchHeight / 2;
                switchBottom = switchTop + this.mSwitchHeight;
                break;
            }
            case 80: {
                switchBottom = this.getHeight() - this.getPaddingBottom();
                switchTop = switchBottom - this.mSwitchHeight;
            }
        }
        this.mSwitchLeft = switchLeft;
        this.mSwitchTop = switchTop;
        this.mSwitchBottom = switchBottom;
        this.mSwitchRight = switchRight;
    }

    protected void onDraw(Canvas canvas) {
        Layout switchText;
        super.onDraw(canvas);
        int switchLeft = this.mSwitchLeft;
        int switchTop = this.mSwitchTop;
        int switchRight = this.mSwitchRight;
        int switchBottom = this.mSwitchBottom;
        this.mTrackDrawable.setBounds(switchLeft, switchTop, switchRight, switchBottom);
        this.mTrackDrawable.draw(canvas);
        canvas.save();
        this.mTrackDrawable.getPadding(this.mTempRect);
        int switchInnerLeft = switchLeft + this.mTempRect.left;
        int switchInnerTop = switchTop + this.mTempRect.top;
        int switchInnerRight = switchRight - this.mTempRect.right;
        int switchInnerBottom = switchBottom - this.mTempRect.bottom;
        canvas.clipRect(switchInnerLeft, switchTop, switchInnerRight, switchBottom);
        this.mThumbDrawable.getPadding(this.mTempRect);
        int thumbPos = (int)(this.mThumbPosition + 0.5f);
        int thumbLeft = switchInnerLeft - this.mTempRect.left + thumbPos;
        int thumbRight = switchInnerLeft + thumbPos + this.mThumbWidth + this.mTempRect.right;
        if (!this.getTargetCheckedState()) {
            this.mThumbDrawable.setBounds(thumbLeft, switchTop, thumbLeft + (switchBottom - switchTop), switchBottom);
        } else {
            this.mThumbDrawable.setBounds(thumbRight - (switchBottom - switchTop), switchTop, thumbRight, switchBottom);
        }
        this.mThumbDrawable.draw(canvas);
        if (this.mTextColors != null) {
            this.mTextPaint.setColor(this.mTextColors.getColorForState(this.getDrawableState(), this.mTextColors.getDefaultColor()));
        }
        this.mTextPaint.drawableState = this.getDrawableState();
        Layout layout2 = switchText = this.getTargetCheckedState() ? this.mOnLayout : this.mOffLayout;
        if (switchText != null) {
            canvas.translate((float)((thumbLeft + thumbRight) / 2 - switchText.getWidth() / 2), (float)((switchInnerTop + switchInnerBottom) / 2 - switchText.getHeight() / 2));
            switchText.draw(canvas);
        }
        canvas.restore();
    }

    public int getCompoundPaddingRight() {
        int padding = super.getCompoundPaddingRight() + this.mSwitchWidth;
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            padding += this.mSwitchPadding;
        }
        return padding;
    }

    private int getThumbScrollRange() {
        if (this.mTrackDrawable == null) {
            return 0;
        }
        this.mTrackDrawable.getPadding(this.mTempRect);
        return this.mSwitchWidth - this.mThumbWidth - this.mTempRect.left - this.mTempRect.right;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            Switch.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        int[] myDrawableState = this.getDrawableState();
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setState(myDrawableState);
        }
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.setState(myDrawableState);
        }
        this.invalidate();
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mThumbDrawable || who == this.mTrackDrawable;
    }
}

