/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.stickyListHeaders;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListView;
import android.widget.SectionIndexer;
import com.yy.mobile.framework.R;
import com.yy.mobile.ui.widget.stickyListHeaders.AdapterWrapper;
import com.yy.mobile.ui.widget.stickyListHeaders.SectionIndexerAdapterWrapper;
import com.yy.mobile.ui.widget.stickyListHeaders.StickyListHeadersAdapter;
import com.yy.mobile.ui.widget.stickyListHeaders.WrapperView;
import com.yy.mobile.ui.widget.stickyListHeaders.WrapperViewList;

public class StickyListHeadersListView
extends FrameLayout {
    private WrapperViewList mList;
    private View mHeader;
    private Long mHeaderId;
    private Integer mHeaderPosition;
    private Integer mHeaderOffset;
    private AbsListView.OnScrollListener mOnScrollListenerDelegate;
    private AdapterWrapper mAdapter;
    private boolean mAreHeadersSticky = true;
    private boolean mClippingToPadding = true;
    private boolean mIsDrawingListUnderStickyHeader = true;
    private int mStickyHeaderTopOffset = 0;
    private int mPaddingLeft = 0;
    private int mPaddingTop = 0;
    private int mPaddingRight = 0;
    private int mPaddingBottom = 0;
    private OnHeaderClickListener mOnHeaderClickListener;
    private OnStickyHeaderOffsetChangedListener mOnStickyHeaderOffsetChangedListener;
    private OnStickyHeaderChangedListener mOnStickyHeaderChangedListener;
    private AdapterWrapperDataSetObserver mDataSetObserver;
    private Drawable mDivider;
    private int mDividerHeight;

    public StickyListHeadersListView(Context context) {
        this(context, null);
    }

    public StickyListHeadersListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public StickyListHeadersListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mList = new WrapperViewList(context);
        this.mDivider = this.mList.getDivider();
        this.mDividerHeight = this.mList.getDividerHeight();
        this.mList.setDivider(null);
        this.mList.setDividerHeight(0);
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.StickyListHeadersListView, 0, 0);
            try {
                int padding = a.getDimensionPixelSize(R.styleable.StickyListHeadersListView_android_padding, 0);
                this.mPaddingLeft = a.getDimensionPixelSize(R.styleable.StickyListHeadersListView_android_paddingLeft, padding);
                this.mPaddingTop = a.getDimensionPixelSize(R.styleable.StickyListHeadersListView_android_paddingTop, padding);
                this.mPaddingRight = a.getDimensionPixelSize(R.styleable.StickyListHeadersListView_android_paddingRight, padding);
                this.mPaddingBottom = a.getDimensionPixelSize(R.styleable.StickyListHeadersListView_android_paddingBottom, padding);
                this.setPadding(this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight, this.mPaddingBottom);
                this.mClippingToPadding = a.getBoolean(R.styleable.StickyListHeadersListView_android_clipToPadding, true);
                super.setClipToPadding(true);
                this.mList.setClipToPadding(this.mClippingToPadding);
                int scrollBars = a.getInt(R.styleable.StickyListHeadersListView_android_scrollbars, 512);
                this.mList.setVerticalScrollBarEnabled((scrollBars & 0x200) != 0);
                this.mList.setHorizontalScrollBarEnabled((scrollBars & 0x100) != 0);
                if (Build.VERSION.SDK_INT >= 9) {
                    this.mList.setOverScrollMode(a.getInt(R.styleable.StickyListHeadersListView_android_overScrollMode, 0));
                }
                this.mList.setFadingEdgeLength(a.getDimensionPixelSize(R.styleable.StickyListHeadersListView_android_fadingEdgeLength, this.mList.getVerticalFadingEdgeLength()));
                int fadingEdge = a.getInt(R.styleable.StickyListHeadersListView_android_requiresFadingEdge, 0);
                if (fadingEdge == 4096) {
                    this.mList.setVerticalFadingEdgeEnabled(false);
                    this.mList.setHorizontalFadingEdgeEnabled(true);
                } else if (fadingEdge == 8192) {
                    this.mList.setVerticalFadingEdgeEnabled(true);
                    this.mList.setHorizontalFadingEdgeEnabled(false);
                } else {
                    this.mList.setVerticalFadingEdgeEnabled(false);
                    this.mList.setHorizontalFadingEdgeEnabled(false);
                }
                this.mList.setCacheColorHint(a.getColor(R.styleable.StickyListHeadersListView_android_cacheColorHint, this.mList.getCacheColorHint()));
                if (Build.VERSION.SDK_INT >= 11) {
                    this.mList.setChoiceMode(a.getInt(R.styleable.StickyListHeadersListView_android_choiceMode, this.mList.getChoiceMode()));
                }
                this.mList.setDrawSelectorOnTop(a.getBoolean(R.styleable.StickyListHeadersListView_android_drawSelectorOnTop, false));
                this.mList.setFastScrollEnabled(a.getBoolean(R.styleable.StickyListHeadersListView_android_fastScrollEnabled, this.mList.isFastScrollEnabled()));
                if (Build.VERSION.SDK_INT >= 11) {
                    this.mList.setFastScrollAlwaysVisible(a.getBoolean(R.styleable.StickyListHeadersListView_android_fastScrollAlwaysVisible, this.mList.isFastScrollAlwaysVisible()));
                }
                this.mList.setScrollBarStyle(a.getInt(R.styleable.StickyListHeadersListView_android_scrollbarStyle, 0));
                if (a.hasValue(R.styleable.StickyListHeadersListView_android_listSelector)) {
                    this.mList.setSelector(a.getDrawable(R.styleable.StickyListHeadersListView_android_listSelector));
                }
                this.mList.setScrollingCacheEnabled(a.getBoolean(R.styleable.StickyListHeadersListView_android_scrollingCache, this.mList.isScrollingCacheEnabled()));
                if (a.hasValue(R.styleable.StickyListHeadersListView_android_divider)) {
                    this.mDivider = a.getDrawable(R.styleable.StickyListHeadersListView_android_divider);
                }
                this.mDividerHeight = a.getDimensionPixelSize(R.styleable.StickyListHeadersListView_android_dividerHeight, this.mDividerHeight);
                this.mList.setTranscriptMode(a.getInt(R.styleable.StickyListHeadersListView_android_transcriptMode, 0));
                this.mAreHeadersSticky = a.getBoolean(R.styleable.StickyListHeadersListView_hasStickyHeaders, true);
                this.mIsDrawingListUnderStickyHeader = a.getBoolean(R.styleable.StickyListHeadersListView_isDrawingListUnderStickyHeader, true);
            }
            finally {
                a.recycle();
            }
        }
        this.mList.setLifeCycleListener(new WrapperViewListLifeCycleListener());
        this.mList.setOnScrollListener(new WrapperListScrollListener());
        this.addView((View)this.mList);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.measureHeader(this.mHeader);
    }

    private void ensureHeaderHasCorrectLayoutParams(View header) {
        ViewGroup.LayoutParams lp = header.getLayoutParams();
        if (lp == null) {
            lp = new FrameLayout.LayoutParams(-1, -2);
            header.setLayoutParams(lp);
        } else if (lp.height == -1) {
            lp.height = -2;
            header.setLayoutParams(lp);
        }
    }

    private void measureHeader(View header) {
        if (header != null) {
            int width = this.getMeasuredWidth() - this.mPaddingLeft - this.mPaddingRight;
            int parentWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
            int parentHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            this.measureChild(header, parentWidthMeasureSpec, parentHeightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mList.layout(0, 0, this.mList.getMeasuredWidth(), this.getHeight());
        if (this.mHeader != null) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mHeader.getLayoutParams();
            int headerTop = lp.topMargin + this.stickyHeaderTop();
            this.mHeader.layout(this.mPaddingLeft, headerTop, this.mHeader.getMeasuredWidth() + this.mPaddingLeft, headerTop + this.mHeader.getMeasuredHeight());
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mList.getVisibility() == 0 || this.mList.getAnimation() != null) {
            this.drawChild(canvas, (View)this.mList, 0L);
        }
    }

    private void clearHeader() {
        if (this.mHeader != null) {
            this.removeView(this.mHeader);
            this.mHeader = null;
            this.mHeaderId = null;
            this.mHeaderPosition = null;
            this.mHeaderOffset = null;
            this.mList.setTopClippingLength(0);
            this.updateHeaderVisibilities();
        }
    }

    private void updateOrClearHeader(int firstVisiblePosition) {
        boolean isHeaderPositionOutsideAdapterRange;
        View firstItem;
        int adapterCount;
        int n = adapterCount = this.mAdapter == null ? 0 : this.mAdapter.getCount();
        if (adapterCount == 0 || !this.mAreHeadersSticky) {
            return;
        }
        int headerViewCount = this.mList.getHeaderViewsCount();
        int headerPosition = firstVisiblePosition - headerViewCount;
        if (this.mList.getChildCount() > 0 && (firstItem = this.mList.getChildAt(0)).getBottom() < this.stickyHeaderTop()) {
            ++headerPosition;
        }
        boolean doesListHaveChildren = this.mList.getChildCount() != 0;
        boolean isFirstViewBelowTop = doesListHaveChildren && this.mList.getFirstVisiblePosition() == 0 && this.mList.getChildAt(0).getTop() >= this.stickyHeaderTop();
        boolean bl = isHeaderPositionOutsideAdapterRange = headerPosition > adapterCount - 1 || headerPosition < 0;
        if (!doesListHaveChildren || isHeaderPositionOutsideAdapterRange || isFirstViewBelowTop) {
            this.clearHeader();
            return;
        }
        this.updateHeader(headerPosition);
    }

    private void updateHeader(int headerPosition) {
        if (this.mHeaderPosition == null || this.mHeaderPosition != headerPosition) {
            this.mHeaderPosition = headerPosition;
            long headerId = this.mAdapter.getHeaderId(headerPosition);
            if (this.mHeaderId == null || this.mHeaderId != headerId) {
                this.mHeaderId = headerId;
                View header = this.mAdapter.getHeaderView(this.mHeaderPosition, this.mHeader, (ViewGroup)this);
                if (this.mHeader != header) {
                    if (header == null) {
                        throw new NullPointerException("header may not be null");
                    }
                    this.swapHeader(header);
                }
                this.ensureHeaderHasCorrectLayoutParams(this.mHeader);
                this.measureHeader(this.mHeader);
                if (this.mOnStickyHeaderChangedListener != null) {
                    this.mOnStickyHeaderChangedListener.onStickyHeaderChanged(this, this.mHeader, headerPosition, this.mHeaderId);
                }
                this.mHeaderOffset = null;
            }
        }
        int headerOffset = 0;
        int headerBottom = this.mHeader.getMeasuredHeight() + this.stickyHeaderTop();
        for (int i = 0; i < this.mList.getChildCount(); ++i) {
            View child = this.mList.getChildAt(i);
            boolean doesChildHaveHeader = child instanceof WrapperView && ((WrapperView)child).hasHeader();
            boolean isChildFooter = this.mList.containsFooterView(child);
            if (child.getTop() < this.stickyHeaderTop() || !doesChildHaveHeader && !isChildFooter) continue;
            headerOffset = Math.min(child.getTop() - headerBottom, 0);
            break;
        }
        this.setHeaderOffet(headerOffset);
        if (!this.mIsDrawingListUnderStickyHeader) {
            this.mList.setTopClippingLength(this.mHeader.getMeasuredHeight() + this.mHeaderOffset);
        }
        this.updateHeaderVisibilities();
    }

    private void swapHeader(View newHeader) {
        if (this.mHeader != null) {
            this.removeView(this.mHeader);
        }
        this.mHeader = newHeader;
        this.addView(this.mHeader);
        this.mHeader.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (StickyListHeadersListView.this.mOnHeaderClickListener != null) {
                    StickyListHeadersListView.this.mOnHeaderClickListener.onHeaderClick(StickyListHeadersListView.this, StickyListHeadersListView.this.mHeader, StickyListHeadersListView.this.mHeaderPosition, StickyListHeadersListView.this.mHeaderId, true);
                }
            }
        });
    }

    private void updateHeaderVisibilities() {
        int top = this.mHeader != null ? this.mHeader.getMeasuredHeight() + (this.mHeaderOffset != null ? this.mHeaderOffset : 0) : (this.mClippingToPadding ? this.mPaddingTop : 0);
        int childCount = this.mList.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            WrapperView wrapperViewChild;
            View child = this.mList.getChildAt(i);
            if (!(child instanceof WrapperView) || !(wrapperViewChild = (WrapperView)child).hasHeader()) continue;
            View childHeader = wrapperViewChild.mHeader;
            if (wrapperViewChild.getTop() < top) {
                if (childHeader.getVisibility() == 4) continue;
                childHeader.setVisibility(4);
                continue;
            }
            if (childHeader.getVisibility() == 0) continue;
            childHeader.setVisibility(0);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void setHeaderOffet(int offset) {
        if (this.mHeaderOffset == null || this.mHeaderOffset != offset) {
            this.mHeaderOffset = offset;
            if (Build.VERSION.SDK_INT >= 11) {
                this.mHeader.setTranslationY((float)this.mHeaderOffset.intValue());
            } else {
                ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mHeader.getLayoutParams();
                params.topMargin = this.mHeaderOffset;
                this.mHeader.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            if (this.mOnStickyHeaderOffsetChangedListener != null) {
                this.mOnStickyHeaderOffsetChangedListener.onStickyHeaderOffsetChanged(this, this.mHeader, -this.mHeaderOffset.intValue());
            }
        }
    }

    private boolean isStartOfSection(int position) {
        return position == 0 || this.mAdapter.getHeaderId(position) != this.mAdapter.getHeaderId(position - 1);
    }

    private int getHeaderOverlap(int position) {
        boolean isStartOfSection = this.isStartOfSection(Math.max(0, position - this.getHeaderViewsCount()));
        if (!isStartOfSection) {
            View header = this.mAdapter.getHeaderView(position, null, (ViewGroup)this.mList);
            if (header == null) {
                throw new NullPointerException("header may not be null");
            }
            this.ensureHeaderHasCorrectLayoutParams(header);
            this.measureHeader(header);
            return header.getMeasuredHeight();
        }
        return 0;
    }

    private int stickyHeaderTop() {
        return this.mStickyHeaderTopOffset + (this.mClippingToPadding ? this.mPaddingTop : 0);
    }

    public void setAreHeadersSticky(boolean areHeadersSticky) {
        this.mAreHeadersSticky = areHeadersSticky;
        if (!areHeadersSticky) {
            this.clearHeader();
        } else {
            this.updateOrClearHeader(this.mList.getFixedFirstVisibleItem());
        }
        this.mList.invalidate();
    }

    public boolean areHeadersSticky() {
        return this.mAreHeadersSticky;
    }

    @Deprecated
    public boolean getAreHeadersSticky() {
        return this.areHeadersSticky();
    }

    public void setStickyHeaderTopOffset(int stickyHeaderTopOffset) {
        this.mStickyHeaderTopOffset = stickyHeaderTopOffset;
        this.updateOrClearHeader(this.mList.getFixedFirstVisibleItem());
    }

    public int getStickyHeaderTopOffset() {
        return this.mStickyHeaderTopOffset;
    }

    public void setDrawingListUnderStickyHeader(boolean drawingListUnderStickyHeader) {
        this.mIsDrawingListUnderStickyHeader = drawingListUnderStickyHeader;
        this.mList.setTopClippingLength(0);
    }

    public boolean isDrawingListUnderStickyHeader() {
        return this.mIsDrawingListUnderStickyHeader;
    }

    public void setOnHeaderClickListener(OnHeaderClickListener listener) {
        this.mOnHeaderClickListener = listener;
        if (this.mAdapter != null) {
            if (this.mOnHeaderClickListener != null) {
                this.mAdapter.setOnHeaderClickListener(new AdapterWrapperHeaderClickHandler());
            } else {
                this.mAdapter.setOnHeaderClickListener(null);
            }
        }
    }

    public void setOnStickyHeaderOffsetChangedListener(OnStickyHeaderOffsetChangedListener listener) {
        this.mOnStickyHeaderOffsetChangedListener = listener;
    }

    public void setOnStickyHeaderChangedListener(OnStickyHeaderChangedListener listener) {
        this.mOnStickyHeaderChangedListener = listener;
    }

    public View getListChildAt(int index) {
        return this.mList.getChildAt(index);
    }

    public int getListChildCount() {
        return this.mList.getChildCount();
    }

    public ListView getWrappedList() {
        return this.mList;
    }

    private boolean requireSdkVersion(int versionCode) {
        if (Build.VERSION.SDK_INT < versionCode) {
            Log.e((String)"StickyListHeaders", (String)("Api lvl must be at least " + versionCode + " to call this method"));
            return false;
        }
        return true;
    }

    public void setAdapter(StickyListHeadersAdapter adapter) {
        if (adapter == null) {
            this.mList.setAdapter(null);
            this.clearHeader();
            return;
        }
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.mAdapter = adapter instanceof SectionIndexer ? new SectionIndexerAdapterWrapper(this.getContext(), adapter) : new AdapterWrapper(this.getContext(), adapter);
        this.mDataSetObserver = new AdapterWrapperDataSetObserver();
        this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
        if (this.mOnHeaderClickListener != null) {
            this.mAdapter.setOnHeaderClickListener(new AdapterWrapperHeaderClickHandler());
        } else {
            this.mAdapter.setOnHeaderClickListener(null);
        }
        this.mAdapter.setDivider(this.mDivider, this.mDividerHeight);
        this.mList.setAdapter(this.mAdapter);
        this.clearHeader();
    }

    public StickyListHeadersAdapter getAdapter() {
        return this.mAdapter == null ? null : this.mAdapter.mDelegate;
    }

    public void setDivider(Drawable divider) {
        this.mDivider = divider;
        if (this.mAdapter != null) {
            this.mAdapter.setDivider(this.mDivider, this.mDividerHeight);
        }
    }

    public void setDividerHeight(int dividerHeight) {
        this.mDividerHeight = dividerHeight;
        if (this.mAdapter != null) {
            this.mAdapter.setDivider(this.mDivider, this.mDividerHeight);
        }
    }

    public Drawable getDivider() {
        return this.mDivider;
    }

    public int getDividerHeight() {
        return this.mDividerHeight;
    }

    public void setOnScrollListener(AbsListView.OnScrollListener onScrollListener) {
        this.mOnScrollListenerDelegate = onScrollListener;
    }

    public void setOnTouchListener(final View.OnTouchListener l) {
        if (l != null) {
            this.mList.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    return l.onTouch((View)StickyListHeadersListView.this, event);
                }
            });
        } else {
            this.mList.setOnTouchListener(null);
        }
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.mList.setOnItemClickListener(listener);
    }

    public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
        this.mList.setOnItemLongClickListener(listener);
    }

    public void addHeaderView(View v, Object data, boolean isSelectable) {
        this.mList.addHeaderView(v, data, isSelectable);
    }

    public void addHeaderView(View v) {
        this.mList.addHeaderView(v);
    }

    public void removeHeaderView(View v) {
        this.mList.removeHeaderView(v);
    }

    public int getHeaderViewsCount() {
        return this.mList.getHeaderViewsCount();
    }

    public void addFooterView(View v) {
        this.mList.addFooterView(v);
    }

    public void removeFooterView(View v) {
        this.mList.removeFooterView(v);
    }

    public int getFooterViewsCount() {
        return this.mList.getFooterViewsCount();
    }

    public void setEmptyView(View v) {
        this.mList.setEmptyView(v);
    }

    public View getEmptyView() {
        return this.mList.getEmptyView();
    }

    public boolean isVerticalScrollBarEnabled() {
        return this.mList.isVerticalScrollBarEnabled();
    }

    public boolean isHorizontalScrollBarEnabled() {
        return this.mList.isHorizontalScrollBarEnabled();
    }

    public void setVerticalScrollBarEnabled(boolean verticalScrollBarEnabled) {
        this.mList.setVerticalScrollBarEnabled(verticalScrollBarEnabled);
    }

    public void setHorizontalScrollBarEnabled(boolean horizontalScrollBarEnabled) {
        this.mList.setHorizontalScrollBarEnabled(horizontalScrollBarEnabled);
    }

    @TargetApi(value=9)
    public int getOverScrollMode() {
        if (this.requireSdkVersion(9)) {
            return this.mList.getOverScrollMode();
        }
        return 0;
    }

    @TargetApi(value=9)
    public void setOverScrollMode(int mode) {
        if (this.requireSdkVersion(9) && this.mList != null) {
            this.mList.setOverScrollMode(mode);
        }
    }

    @TargetApi(value=8)
    public void smoothScrollBy(int distance, int duration) {
        if (this.requireSdkVersion(8)) {
            this.mList.smoothScrollBy(distance, duration);
        }
    }

    @TargetApi(value=11)
    public void smoothScrollByOffset(int offset) {
        if (this.requireSdkVersion(11)) {
            this.mList.smoothScrollByOffset(offset);
        }
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=8)
    public void smoothScrollToPosition(int position) {
        if (this.requireSdkVersion(8)) {
            if (Build.VERSION.SDK_INT < 11) {
                this.mList.smoothScrollToPosition(position);
            } else {
                int offset = this.mAdapter == null ? 0 : this.getHeaderOverlap(position);
                this.mList.smoothScrollToPositionFromTop(position, offset -= this.mClippingToPadding ? 0 : this.mPaddingTop);
            }
        }
    }

    @TargetApi(value=8)
    public void smoothScrollToPosition(int position, int boundPosition) {
        if (this.requireSdkVersion(8)) {
            this.mList.smoothScrollToPosition(position, boundPosition);
        }
    }

    @TargetApi(value=11)
    public void smoothScrollToPositionFromTop(int position, int offset) {
        if (this.requireSdkVersion(11)) {
            offset += this.mAdapter == null ? 0 : this.getHeaderOverlap(position);
            this.mList.smoothScrollToPositionFromTop(position, offset -= this.mClippingToPadding ? 0 : this.mPaddingTop);
        }
    }

    @TargetApi(value=11)
    public void smoothScrollToPositionFromTop(int position, int offset, int duration) {
        if (this.requireSdkVersion(11)) {
            offset += this.mAdapter == null ? 0 : this.getHeaderOverlap(position);
            this.mList.smoothScrollToPositionFromTop(position, offset -= this.mClippingToPadding ? 0 : this.mPaddingTop, duration);
        }
    }

    public void setSelection(int position) {
        this.setSelectionFromTop(position, 0);
    }

    public void setSelectionAfterHeaderView() {
        this.mList.setSelectionAfterHeaderView();
    }

    public void setSelectionFromTop(int position, int y) {
        y += this.mAdapter == null ? 0 : this.getHeaderOverlap(position);
        this.mList.setSelectionFromTop(position, y -= this.mClippingToPadding ? 0 : this.mPaddingTop);
    }

    public void setSelector(Drawable sel) {
        this.mList.setSelector(sel);
    }

    public void setSelector(int resID) {
        this.mList.setSelector(resID);
    }

    public int getFirstVisiblePosition() {
        return this.mList.getFirstVisiblePosition();
    }

    public int getLastVisiblePosition() {
        return this.mList.getLastVisiblePosition();
    }

    @TargetApi(value=11)
    public void setChoiceMode(int choiceMode) {
        this.mList.setChoiceMode(choiceMode);
    }

    @TargetApi(value=11)
    public void setItemChecked(int position, boolean value) {
        this.mList.setItemChecked(position, value);
    }

    @TargetApi(value=11)
    public int getCheckedItemCount() {
        if (this.requireSdkVersion(11)) {
            return this.mList.getCheckedItemCount();
        }
        return 0;
    }

    @TargetApi(value=8)
    public long[] getCheckedItemIds() {
        if (this.requireSdkVersion(8)) {
            return this.mList.getCheckedItemIds();
        }
        return null;
    }

    @TargetApi(value=11)
    public int getCheckedItemPosition() {
        return this.mList.getCheckedItemPosition();
    }

    @TargetApi(value=11)
    public SparseBooleanArray getCheckedItemPositions() {
        return this.mList.getCheckedItemPositions();
    }

    public int getCount() {
        return this.mList.getCount();
    }

    public Object getItemAtPosition(int position) {
        return this.mList.getItemAtPosition(position);
    }

    public long getItemIdAtPosition(int position) {
        return this.mList.getItemIdAtPosition(position);
    }

    public void setOnCreateContextMenuListener(View.OnCreateContextMenuListener l) {
        this.mList.setOnCreateContextMenuListener(l);
    }

    public boolean showContextMenu() {
        return this.mList.showContextMenu();
    }

    public void invalidateViews() {
        this.mList.invalidateViews();
    }

    public void setClipToPadding(boolean clipToPadding) {
        if (this.mList != null) {
            this.mList.setClipToPadding(clipToPadding);
        }
        this.mClippingToPadding = clipToPadding;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.mPaddingLeft = left;
        this.mPaddingTop = top;
        this.mPaddingRight = right;
        this.mPaddingBottom = bottom;
        if (this.mList != null) {
            this.mList.setPadding(left, top, right, bottom);
        }
        super.setPadding(0, 0, 0, 0);
        this.requestLayout();
    }

    protected void recomputePadding() {
        this.setPadding(this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight, this.mPaddingBottom);
    }

    public int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    public int getPaddingRight() {
        return this.mPaddingRight;
    }

    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public void setFastScrollEnabled(boolean fastScrollEnabled) {
        this.mList.setFastScrollEnabled(fastScrollEnabled);
    }

    @TargetApi(value=11)
    public void setFastScrollAlwaysVisible(boolean alwaysVisible) {
        if (this.requireSdkVersion(11)) {
            this.mList.setFastScrollAlwaysVisible(alwaysVisible);
        }
    }

    @TargetApi(value=11)
    public boolean isFastScrollAlwaysVisible() {
        if (Build.VERSION.SDK_INT < 11) {
            return false;
        }
        return this.mList.isFastScrollAlwaysVisible();
    }

    public void setScrollBarStyle(int style2) {
        this.mList.setScrollBarStyle(style2);
    }

    public int getScrollBarStyle() {
        return this.mList.getScrollBarStyle();
    }

    public int getPositionForView(View view) {
        return this.mList.getPositionForView(view);
    }

    @TargetApi(value=11)
    public void setMultiChoiceModeListener(AbsListView.MultiChoiceModeListener listener) {
        if (this.requireSdkVersion(11)) {
            this.mList.setMultiChoiceModeListener(listener);
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (superState != View.BaseSavedState.EMPTY_STATE) {
            throw new IllegalStateException("Handling non empty state of parent class is not implemented");
        }
        return this.mList.onSaveInstanceState();
    }

    public void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState((Parcelable)View.BaseSavedState.EMPTY_STATE);
        this.mList.onRestoreInstanceState(state);
    }

    @TargetApi(value=14)
    public boolean canScrollVertically(int direction) {
        return this.mList.canScrollVertically(direction);
    }

    public void setTranscriptMode(int mode) {
        this.mList.setTranscriptMode(mode);
    }

    private class AdapterWrapperHeaderClickHandler
    implements AdapterWrapper.OnHeaderClickListener {
        private AdapterWrapperHeaderClickHandler() {
        }

        @Override
        public void onHeaderClick(View header, int itemPosition, long headerId) {
            StickyListHeadersListView.this.mOnHeaderClickListener.onHeaderClick(StickyListHeadersListView.this, header, itemPosition, headerId, false);
        }
    }

    private class WrapperViewListLifeCycleListener
    implements WrapperViewList.LifeCycleListener {
        private WrapperViewListLifeCycleListener() {
        }

        @Override
        public void onDispatchDrawOccurred(Canvas canvas) {
            if (Build.VERSION.SDK_INT < 8) {
                StickyListHeadersListView.this.updateOrClearHeader(StickyListHeadersListView.this.mList.getFixedFirstVisibleItem());
            }
            if (StickyListHeadersListView.this.mHeader != null) {
                if (StickyListHeadersListView.this.mClippingToPadding) {
                    canvas.save();
                    canvas.clipRect(0, StickyListHeadersListView.this.mPaddingTop, StickyListHeadersListView.this.getRight(), StickyListHeadersListView.this.getBottom());
                    StickyListHeadersListView.this.drawChild(canvas, StickyListHeadersListView.this.mHeader, 0L);
                    canvas.restore();
                } else {
                    StickyListHeadersListView.this.drawChild(canvas, StickyListHeadersListView.this.mHeader, 0L);
                }
            }
        }
    }

    private class WrapperListScrollListener
    implements AbsListView.OnScrollListener {
        private WrapperListScrollListener() {
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (StickyListHeadersListView.this.mOnScrollListenerDelegate != null) {
                StickyListHeadersListView.this.mOnScrollListenerDelegate.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
            StickyListHeadersListView.this.updateOrClearHeader(StickyListHeadersListView.this.mList.getFixedFirstVisibleItem());
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (StickyListHeadersListView.this.mOnScrollListenerDelegate != null) {
                StickyListHeadersListView.this.mOnScrollListenerDelegate.onScrollStateChanged(view, scrollState);
            }
        }
    }

    private class AdapterWrapperDataSetObserver
    extends DataSetObserver {
        private AdapterWrapperDataSetObserver() {
        }

        public void onChanged() {
            StickyListHeadersListView.this.clearHeader();
        }

        public void onInvalidated() {
            StickyListHeadersListView.this.clearHeader();
        }
    }

    public static interface OnStickyHeaderChangedListener {
        public void onStickyHeaderChanged(StickyListHeadersListView var1, View var2, int var3, long var4);
    }

    public static interface OnStickyHeaderOffsetChangedListener {
        public void onStickyHeaderOffsetChanged(StickyListHeadersListView var1, View var2, int var3);
    }

    public static interface OnHeaderClickListener {
        public void onHeaderClick(StickyListHeadersListView var1, View var2, int var3, long var4, boolean var6);
    }
}

