/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.ui.widget.menudrawer.DraggableDrawer;
import com.yy.mobile.ui.widget.menudrawer.Position;
import com.yy.mobile.ui.widget.menudrawer.ViewHelper;
import com.yy.mobile.util.log.MLog;

public class SlidingDrawer
extends DraggableDrawer {
    private static final String TAG = "OverlayDrawer";
    private DisplayMetrics displayMetrics = new DisplayMetrics();

    SlidingDrawer(Activity activity, int dragMode) {
        super(activity, dragMode);
    }

    public SlidingDrawer(Context context) {
        super(context);
    }

    public SlidingDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SlidingDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void initDrawer(Context context, AttributeSet attrs, int defStyle) {
        super.initDrawer(context, attrs, defStyle);
        super.addView((View)this.mMenuContainer, -1, new ViewGroup.LayoutParams(-1, -1));
        super.addView((View)this.mContentContainer, -1, new ViewGroup.LayoutParams(-1, -1));
    }

    @Override
    public void openMenu(boolean animate) {
        int animateTo = 0;
        switch (this.getPosition()) {
            case LEFT: 
            case TOP: {
                animateTo = this.mMenuSize;
                break;
            }
            case RIGHT: 
            case BOTTOM: {
                animateTo = -this.mMenuSize;
                break;
            }
        }
        this.animateOffsetTo(animateTo, 0, animate);
    }

    @Override
    public void closeMenu(boolean animate) {
        this.animateOffsetTo(0, 0, animate);
    }

    @Override
    protected void onOffsetPixelsChanged(int offsetPixels) {
        if (USE_TRANSLATIONS) {
            switch (this.getPosition()) {
                case TOP: 
                case BOTTOM: {
                    this.mContentContainer.setTranslationY(offsetPixels);
                    break;
                }
                default: {
                    this.mContentContainer.setTranslationX(offsetPixels);
                    break;
                }
            }
        } else {
            switch (this.getPosition()) {
                case TOP: 
                case BOTTOM: {
                    this.mContentContainer.offsetTopAndBottom(offsetPixels - this.mContentContainer.getTop());
                    break;
                }
                default: {
                    this.mContentContainer.offsetLeftAndRight(offsetPixels - this.mContentContainer.getLeft());
                }
            }
        }
        this.offsetMenu(offsetPixels);
        this.invalidate();
    }

    @Override
    protected void initPeekScroller() {
        switch (this.getPosition()) {
            case RIGHT: 
            case BOTTOM: {
                int dx = -this.mMenuSize / 3;
                this.mPeekScroller.startScroll(0, 0, dx, 0, 5000);
                break;
            }
            default: {
                int dx = this.mMenuSize / 3;
                this.mPeekScroller.startScroll(0, 0, dx, 0, 5000);
                break;
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.onOffsetPixelsChanged((int)this.mOffsetPixels);
    }

    @Override
    protected void drawOverlay(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        int offsetPixels = (int)this.mOffsetPixels;
        float openRatio = Math.abs(this.mOffsetPixels) / (float)this.mMenuSize;
        switch (this.getPosition()) {
            case LEFT: {
                this.mMenuOverlay.setBounds(0, 0, offsetPixels, height);
                break;
            }
            case RIGHT: {
                this.mMenuOverlay.setBounds(width + offsetPixels, 0, width, height);
                break;
            }
            case TOP: {
                this.mMenuOverlay.setBounds(0, 0, width, offsetPixels);
                break;
            }
            case BOTTOM: {
                this.mMenuOverlay.setBounds(0, height + offsetPixels, width, height);
                break;
            }
        }
        this.mMenuOverlay.setAlpha((int)(185.0f * (1.0f - openRatio)));
        this.mMenuOverlay.draw(canvas);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        int height = b - t;
        if (USE_TRANSLATIONS) {
            this.mContentContainer.layout(0, 0, width, height);
        } else {
            int offsetPixels = (int)this.mOffsetPixels;
            if (this.getPosition() == Position.LEFT || this.getPosition() == Position.RIGHT) {
                this.mContentContainer.layout(offsetPixels, 0, width + offsetPixels, height);
            } else {
                this.mContentContainer.layout(0, offsetPixels, width, height + offsetPixels);
            }
        }
        switch (this.getPosition()) {
            case LEFT: {
                this.mMenuContainer.layout(0, 0, this.mMenuSize, height);
                break;
            }
            case RIGHT: {
                this.mMenuContainer.layout(width - this.mMenuSize, 0, width, height);
                break;
            }
            case TOP: {
                this.mMenuContainer.layout(0, 0, width, this.mMenuSize);
                break;
            }
            case BOTTOM: {
                this.mMenuContainer.layout(0, height - this.mMenuSize, width, height);
                break;
            }
        }
    }

    private void offsetMenu(int offsetPixels) {
        if (!this.mOffsetMenu || this.mMenuSize == 0) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int menuSize = this.mMenuSize;
        int sign = (int)(this.mOffsetPixels / Math.abs(this.mOffsetPixels));
        float openRatio = Math.abs(this.mOffsetPixels) / (float)menuSize;
        int offset = (int)(-0.25f * ((1.0f - openRatio) * (float)menuSize) * (float)sign);
        switch (this.getPosition()) {
            case LEFT: {
                if (USE_TRANSLATIONS) {
                    if (offsetPixels > 0) {
                        this.mMenuContainer.setTranslationX(offset);
                        break;
                    }
                    this.mMenuContainer.setTranslationX(-menuSize);
                    break;
                }
                this.mMenuContainer.offsetLeftAndRight(offset - this.mMenuContainer.getLeft());
                this.mMenuContainer.setVisibility(offsetPixels == 0 ? 4 : 0);
                break;
            }
            case RIGHT: {
                if (USE_TRANSLATIONS) {
                    if (offsetPixels != 0) {
                        this.mMenuContainer.setTranslationX(offset);
                        break;
                    }
                    this.mMenuContainer.setTranslationX(menuSize);
                    break;
                }
                int oldOffset = this.mMenuContainer.getRight() - width;
                int offsetBy = offset - oldOffset;
                this.mMenuContainer.offsetLeftAndRight(offsetBy);
                this.mMenuContainer.setVisibility(offsetPixels == 0 ? 4 : 0);
                break;
            }
            case TOP: {
                if (USE_TRANSLATIONS) {
                    if (offsetPixels > 0) {
                        this.mMenuContainer.setTranslationY(offset);
                        break;
                    }
                    this.mMenuContainer.setTranslationY(-menuSize);
                    break;
                }
                this.mMenuContainer.offsetTopAndBottom(offset - this.mMenuContainer.getTop());
                this.mMenuContainer.setVisibility(offsetPixels == 0 ? 4 : 0);
                break;
            }
            case BOTTOM: {
                if (USE_TRANSLATIONS) {
                    if (offsetPixels != 0) {
                        this.mMenuContainer.setTranslationY(offset);
                        break;
                    }
                    this.mMenuContainer.setTranslationY(menuSize);
                    break;
                }
                int oldOffset = this.mMenuContainer.getBottom() - height;
                int offsetBy = offset - oldOffset;
                this.mMenuContainer.offsetTopAndBottom(offsetBy);
                this.mMenuContainer.setVisibility(offsetPixels == 0 ? 4 : 0);
                break;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int menuHeightMeasureSpec;
        int menuWidthMeasureSpec;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode == 0 || heightMode == 0) {
            throw new IllegalStateException("Must measure with an exact size");
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mOffsetPixels == -1.0f) {
            this.openMenu(false);
        }
        switch (this.getPosition()) {
            case TOP: 
            case BOTTOM: {
                menuWidthMeasureSpec = SlidingDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)width);
                menuHeightMeasureSpec = SlidingDrawer.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)this.mMenuSize);
                break;
            }
            default: {
                menuWidthMeasureSpec = SlidingDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)this.mMenuSize);
                menuHeightMeasureSpec = SlidingDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)height);
            }
        }
        this.mMenuContainer.measure(menuWidthMeasureSpec, menuHeightMeasureSpec);
        int contentWidthMeasureSpec = SlidingDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)width);
        int contentHeightMeasureSpec = SlidingDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)height);
        this.mContentContainer.measure(contentWidthMeasureSpec, contentHeightMeasureSpec);
        this.setMeasuredDimension(width, height);
        this.updateTouchAreaSize();
    }

    private boolean isContentTouch(int x, int y) {
        boolean contentTouch = false;
        switch (this.getPosition()) {
            case LEFT: {
                contentTouch = ViewHelper.getLeft((View)this.mContentContainer) < x;
                break;
            }
            case RIGHT: {
                contentTouch = ViewHelper.getRight((View)this.mContentContainer) > x;
                break;
            }
            case TOP: {
                contentTouch = ViewHelper.getTop((View)this.mContentContainer) < y;
                break;
            }
            case BOTTOM: {
                contentTouch = ViewHelper.getBottom((View)this.mContentContainer) > y;
                break;
            }
        }
        return contentTouch;
    }

    protected boolean onDownAllowDrag(int x, int y) {
        switch (this.getPosition()) {
            case LEFT: {
                return !this.mMenuVisible && this.mInitialMotionX <= (float)this.mTouchSize || this.mMenuVisible && this.mInitialMotionX >= this.mOffsetPixels;
            }
            case RIGHT: {
                int width = this.getWidth();
                int initialMotionX = (int)this.mInitialMotionX;
                return !this.mMenuVisible && initialMotionX >= width - this.mTouchSize || this.mMenuVisible && (float)initialMotionX <= (float)width + this.mOffsetPixels;
            }
            case TOP: {
                return !this.mMenuVisible && this.mInitialMotionY <= (float)this.mTouchSize || this.mMenuVisible && this.mInitialMotionY >= this.mOffsetPixels;
            }
            case BOTTOM: {
                int height = this.getHeight();
                return !this.mMenuVisible && this.mInitialMotionY >= (float)(height - this.mTouchSize) || this.mMenuVisible && this.mInitialMotionY <= (float)height + this.mOffsetPixels;
            }
        }
        return false;
    }

    protected boolean onMoveAllowDrag(int x, int y, float dx, float dy) {
        switch (this.getPosition()) {
            case LEFT: {
                return !this.mMenuVisible && this.mInitialMotionX <= (float)this.mTouchSize && dx > 0.0f || this.mMenuVisible && (float)x >= this.mOffsetPixels;
            }
            case RIGHT: {
                int width = this.getWidth();
                return !this.mMenuVisible && this.mInitialMotionX >= (float)(width - this.mTouchSize) && dx < 0.0f || this.mMenuVisible && (float)x <= (float)width + this.mOffsetPixels;
            }
            case TOP: {
                return !this.mMenuVisible && this.mInitialMotionY <= (float)this.mTouchSize && dy > 0.0f || this.mMenuVisible && (float)y >= this.mOffsetPixels;
            }
            case BOTTOM: {
                int height = this.getHeight();
                return !this.mMenuVisible && this.mInitialMotionY >= (float)(height - this.mTouchSize) && dy < 0.0f || this.mMenuVisible && (float)y <= (float)height + this.mOffsetPixels;
            }
        }
        return false;
    }

    protected void onMoveEvent(float dx, float dy) {
        switch (this.getPosition()) {
            case LEFT: {
                this.setOffsetPixels(Math.min(Math.max(this.mOffsetPixels + dx, 0.0f), (float)this.mMenuSize));
                break;
            }
            case RIGHT: {
                this.setOffsetPixels(Math.max(Math.min(this.mOffsetPixels + dx, 0.0f), (float)(-this.mMenuSize)));
                break;
            }
            case TOP: {
                this.setOffsetPixels(Math.min(Math.max(this.mOffsetPixels + dy, 0.0f), (float)this.mMenuSize));
                break;
            }
            case BOTTOM: {
                this.setOffsetPixels(Math.max(Math.min(this.mOffsetPixels + dy, 0.0f), (float)(-this.mMenuSize)));
                break;
            }
        }
    }

    protected void onUpEvent(int x, int y) {
        int offsetPixels = (int)this.mOffsetPixels;
        switch (this.getPosition()) {
            case LEFT: {
                if (this.mIsDragging) {
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
                    int initialVelocity = (int)this.getXVelocity(this.mVelocityTracker);
                    this.mLastMotionX = x;
                    this.animateOffsetTo(initialVelocity > 0 ? this.mMenuSize : 0, initialVelocity, true);
                    break;
                }
                if (!this.mMenuVisible || x <= offsetPixels) break;
                this.closeMenu();
                break;
            }
            case TOP: {
                if (this.mIsDragging) {
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
                    int initialVelocity = (int)this.getYVelocity(this.mVelocityTracker);
                    this.mLastMotionY = y;
                    this.animateOffsetTo(initialVelocity > 0 ? this.mMenuSize : 0, initialVelocity, true);
                    break;
                }
                if (!this.mMenuVisible || y <= offsetPixels) break;
                this.closeMenu();
                break;
            }
            case RIGHT: {
                int width = this.getWidth();
                if (this.mIsDragging) {
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
                    int initialVelocity = (int)this.getXVelocity(this.mVelocityTracker);
                    this.mLastMotionX = x;
                    this.animateOffsetTo(initialVelocity > 0 ? 0 : -this.mMenuSize, initialVelocity, true);
                    break;
                }
                if (!this.mMenuVisible || x >= width + offsetPixels) break;
                this.closeMenu();
                break;
            }
            case BOTTOM: {
                if (this.mIsDragging) {
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
                    int initialVelocity = (int)this.getYVelocity(this.mVelocityTracker);
                    this.mLastMotionY = y;
                    this.animateOffsetTo(initialVelocity < 0 ? -this.mMenuSize : 0, initialVelocity, true);
                    break;
                }
                if (!this.mMenuVisible || y >= this.getHeight() + offsetPixels) break;
                this.closeMenu();
                break;
            }
        }
    }

    protected boolean checkTouchSlop(float dx, float dy) {
        switch (this.getPosition()) {
            case TOP: 
            case BOTTOM: {
                return Math.abs(dy) > (float)this.mTouchSlop && Math.abs(dy) > Math.abs(dx);
            }
        }
        return Math.abs(dx) > (float)this.mTouchSlop && Math.abs(dx) > Math.abs(dy);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        if (action == 1 || action == 3) {
            this.mActivePointerId = -1;
            this.mIsDragging = false;
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            if (Math.abs(this.mOffsetPixels) > (float)(this.mMenuSize / 2)) {
                this.openMenu();
            } else {
                this.closeMenu();
            }
            return false;
        }
        if (action == 0 && this.mMenuVisible && this.isCloseEnough()) {
            this.setOffsetPixels(0.0f);
            this.stopAnimation();
            this.endPeek();
            this.setDrawerState(0);
            this.mIsDragging = false;
        }
        if (this.mMenuVisible) {
            int y;
            int x;
            int index = 0;
            if (this.mActivePointerId != -1) {
                index = ev.findPointerIndex(this.mActivePointerId);
                int n = index = index == -1 ? 0 : index;
            }
            if (this.isContentTouch(x = (int)ev.getX(index), y = (int)ev.getY(index))) {
                return true;
            }
        }
        if (!this.mMenuVisible && !this.mIsDragging && this.mTouchMode == 0) {
            return false;
        }
        if (action != 0 && this.mIsDragging) {
            return true;
        }
        switch (action) {
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                boolean allowDrag = this.onDownAllowDrag((int)this.mLastMotionX, (int)this.mLastMotionY);
                this.mActivePointerId = ev.getPointerId(0);
                if (!allowDrag) break;
                this.setDrawerState(this.mMenuVisible ? 8 : 0);
                this.stopAnimation();
                this.endPeek();
                this.mIsDragging = false;
                break;
            }
            case 2: {
                float y;
                float dy;
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = ev.findPointerIndex(activePointerId);
                if (pointerIndex == -1) {
                    this.mIsDragging = false;
                    this.mActivePointerId = -1;
                    this.endDrag();
                    this.closeMenu(true);
                    return false;
                }
                float x = ev.getX(pointerIndex);
                float dx = x - this.mLastMotionX;
                if (!this.checkTouchSlop(dx, dy = (y = ev.getY(pointerIndex)) - this.mLastMotionY)) break;
                if (this.mOnInterceptMoveEventListener != null && (this.mTouchMode == 2 || this.mMenuVisible) && this.canChildrenScroll((int)dx, (int)dy, (int)x, (int)y)) {
                    this.endDrag();
                    this.requestDisallowInterceptTouchEvent(true);
                    return false;
                }
                boolean allowDrag = this.onMoveAllowDrag((int)x, (int)y, dx, dy);
                if (!allowDrag) break;
                this.setDrawerState(2);
                this.mIsDragging = true;
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                break;
            }
            case 6: {
                this.onPointerUp(ev);
                this.mLastMotionX = ev.getX(ev.findPointerIndex(this.mActivePointerId));
                this.mLastMotionY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        return this.mIsDragging;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mMenuVisible && !this.mIsDragging && this.mTouchMode == 0) {
            return false;
        }
        int action = ev.getAction() & 0xFF;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        switch (action) {
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                boolean allowDrag = this.onDownAllowDrag((int)this.mLastMotionX, (int)this.mLastMotionY);
                this.mActivePointerId = ev.getPointerId(0);
                if (!allowDrag) break;
                this.stopAnimation();
                this.endPeek();
                this.startLayerTranslation();
                break;
            }
            case 2: {
                float y;
                float dy;
                float x;
                float dx;
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex == -1) {
                    this.mIsDragging = false;
                    this.mActivePointerId = -1;
                    this.endDrag();
                    this.closeMenu(true);
                    return false;
                }
                if (!this.mIsDragging && this.checkTouchSlop(dx = (x = ev.getX(pointerIndex)) - this.mLastMotionX, dy = (y = ev.getY(pointerIndex)) - this.mLastMotionY)) {
                    boolean allowDrag = this.onMoveAllowDrag((int)x, (int)y, dx, dy);
                    if (allowDrag) {
                        this.setDrawerState(2);
                        this.mIsDragging = true;
                        this.mLastMotionX = x;
                        this.mLastMotionY = y;
                    } else {
                        this.mInitialMotionX = x;
                        this.mInitialMotionY = y;
                    }
                }
                if (!this.mIsDragging) break;
                this.startLayerTranslation();
                x = ev.getX(pointerIndex);
                dx = x - this.mLastMotionX;
                y = ev.getY(pointerIndex);
                dy = y - this.mLastMotionY;
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                this.onMoveEvent(dx, dy);
                break;
            }
            case 1: 
            case 3: {
                int index = ev.findPointerIndex(this.mActivePointerId);
                index = index == -1 ? 0 : index;
                int x = (int)ev.getX(index);
                int y = (int)ev.getY(index);
                this.onUpEvent(x, y);
                this.mActivePointerId = -1;
                this.mIsDragging = false;
                break;
            }
            case 5: {
                int index = (ev.getAction() & 0xFF00) >> 8;
                this.mLastMotionX = ev.getX(index);
                this.mLastMotionY = ev.getY(index);
                this.mActivePointerId = ev.getPointerId(index);
                break;
            }
            case 6: {
                this.onPointerUp(ev);
                try {
                    this.mLastMotionX = ev.getX(ev.findPointerIndex(this.mActivePointerId));
                    this.mLastMotionY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                }
                catch (IllegalArgumentException e) {
                    MLog.error(TAG, e);
                }
                break;
            }
        }
        return true;
    }

    private void onPointerUp(MotionEvent ev) {
        int pointerIndex = ev.getActionIndex();
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionX = ev.getX(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }
}

