/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.keyboard;

import android.annotation.TargetApi;
import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.yy.mobile.framework.R;
import com.yy.mobile.ui.utils.DimensUtils;
import java.util.ArrayList;
import java.util.List;

public class TextGridView
extends GridView {
    private StringGridAdapter mAdapter;
    private TextItemClickListener mItemClickListener;

    public TextGridView(Context context) {
        super(context);
    }

    public TextGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setTextItemHeight(int height) {
        if (this.mAdapter != null) {
            this.mAdapter.setItemHeight(height);
        }
    }

    public void setTextItemNormalRes(int resId) {
        if (this.mAdapter != null) {
            this.mAdapter.setItemNormalRes(resId);
        }
    }

    public void setTextItemSelectRes(int resId) {
        if (this.mAdapter != null) {
            this.mAdapter.setItemSelectRes(resId);
        }
    }

    public void setTextList(List<String> list) {
        if (this.mAdapter == null) {
            this.mAdapter = new StringGridAdapter(this.getContext());
            this.setAdapter((ListAdapter)this.mAdapter);
            this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    List<StringGridAdapter.GridItem> dataList = TextGridView.this.mAdapter.getDataList();
                    int size = dataList.size();
                    if (size > position) {
                        for (int i = 0; i < size; ++i) {
                            dataList.get(i).setSelected(i == position);
                        }
                        TextGridView.this.mAdapter.notifyDataSetChanged();
                    }
                    if (TextGridView.this.mItemClickListener != null) {
                        TextGridView.this.mItemClickListener.onClick(dataList.get(position).strText, position);
                    }
                }
            });
        }
        this.mAdapter.setDataList(this.getWrapItemList(list));
    }

    private List<StringGridAdapter.GridItem> getWrapItemList(List<String> list) {
        ArrayList<StringGridAdapter.GridItem> retList = new ArrayList<StringGridAdapter.GridItem>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String str = list.get(i);
            if (i == 0) {
                retList.add(new StringGridAdapter.GridItem(str, true));
                continue;
            }
            retList.add(new StringGridAdapter.GridItem(str, false));
        }
        return retList;
    }

    public void setTextItemClickListener(TextItemClickListener listener) {
        this.mItemClickListener = listener;
    }

    public static class StringGridAdapter
    extends BaseAdapter {
        private Context mContext;
        private List<GridItem> mDataList = new ArrayList<GridItem>();
        private int mItemHeight = 50;
        private int mNormalResId = R.drawable.btn_input_select_normal;
        private int mSelectResId = R.drawable.btn_input_select_selected;

        public StringGridAdapter(Context context) {
            this.mContext = context;
        }

        public void setDataList(List<GridItem> data) {
            this.mDataList = data;
            this.notifyDataSetChanged();
        }

        public void setItemHeight(int height) {
            this.mItemHeight = height;
        }

        public void setItemNormalRes(int resId) {
            this.mNormalResId = resId;
        }

        public void setItemSelectRes(int resId) {
            this.mSelectResId = resId;
        }

        public List<GridItem> getDataList() {
            return this.mDataList;
        }

        public int getCount() {
            if (this.mDataList == null) {
                return 0;
            }
            return this.mDataList.size();
        }

        public GridItem getItem(int position) {
            if (this.mDataList == null || this.mDataList.isEmpty()) {
                return null;
            }
            return this.mDataList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        @TargetApi(value=16)
        public View getView(int position, View convertView, ViewGroup viewGroup) {
            GridItemViewHolder viewHolder;
            if (convertView == null) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.item_grid_select, null);
                viewHolder = new GridItemViewHolder();
                viewHolder.itemTextView = (TextView)convertView.findViewById(R.id.txt_grid);
                viewHolder.itemTextView.setHeight(DimensUtils.dip2pixel(convertView.getContext(), this.mItemHeight));
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (GridItemViewHolder)convertView.getTag();
            }
            GridItem gridItem = this.getItem(position);
            if (!TextUtils.isEmpty((CharSequence)gridItem.strText)) {
                viewHolder.itemTextView.setText((CharSequence)gridItem.strText);
            }
            if (gridItem.isSelected()) {
                viewHolder.itemTextView.setBackgroundResource(this.mSelectResId);
            } else {
                viewHolder.itemTextView.setBackgroundResource(this.mNormalResId);
            }
            return convertView;
        }

        public static class GridItemViewHolder {
            TextView itemTextView;
        }

        public static class GridItem {
            private String strText = "";
            private boolean selected = false;

            public GridItem(String text, boolean selected) {
                this.strText = text;
                this.selected = selected;
            }

            public String getText() {
                return this.strText;
            }

            public void setText(String text) {
                this.strText = text;
            }

            public boolean isSelected() {
                return this.selected;
            }

            public void setSelected(boolean selected) {
                this.selected = selected;
            }
        }
    }

    public static interface TextItemClickListener {
        public void onClick(String var1, int var2);
    }
}

