/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.keyboard;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import com.yy.mobile.framework.R;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.ui.widget.keyboard.BaseKeyboardView;
import java.lang.reflect.Field;
import java.util.List;

public class KeyboardRadioView
extends BaseKeyboardView {
    private RadioGroup mGroup;
    private OnItemClickListener mClickListener;
    private HorizontalScrollView mScrollView;

    public KeyboardRadioView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, DimensUtils.dip2pixel(this.getContext(), 44.0f));
        params.addRule(12);
        this.mScrollView = new HorizontalScrollView(this.getContext());
        this.mScrollView.setBackgroundColor(this.getResources().getColor(R.color.color_keyboard_select));
        this.mScrollView.setHorizontalScrollBarEnabled(false);
        this.addView((View)this.mScrollView, (ViewGroup.LayoutParams)params);
        LinearLayout layout2 = new LinearLayout(this.getContext());
        layout2.setOrientation(0);
        layout2.setGravity(16);
        this.mGroup = new RadioGroup(this.getContext());
        this.mGroup.setOrientation(0);
        this.mGroup.setGravity(16);
        LinearLayout.LayoutParams params1 = new LinearLayout.LayoutParams(-2, -1);
        params1.rightMargin = DimensUtils.dip2pixel(this.getContext(), 12.0f);
        layout2.addView((View)this.mGroup, (ViewGroup.LayoutParams)params1);
        this.mScrollView.addView((View)layout2);
        RelativeLayout.LayoutParams params2 = new RelativeLayout.LayoutParams(-1, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)params2);
    }

    public void setSelectList(List<String> list) {
        if (list != null && !list.isEmpty()) {
            this.mGroup.removeAllViews();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                final int index = i;
                final String text = list.get(i);
                RadioButton rb = new RadioButton(this.getContext());
                rb.setBackgroundResource(R.drawable.btn_input_select_selector);
                rb.setButtonDrawable(null);
                if (Build.VERSION.SDK_INT <= 19) {
                    try {
                        Field field = rb.getClass().getSuperclass().getDeclaredField("mButtonDrawable");
                        field.setAccessible(true);
                        field.set(rb, null);
                    }
                    catch (Exception e) {
                        Log.e((String)"KeyboardRadioView", (String)"printStackTrace", (Throwable)e);
                    }
                }
                rb.setPadding(DimensUtils.dip2pixel(this.getContext(), 16.0f), 0, DimensUtils.dip2pixel(this.getContext(), 16.0f), 0);
                rb.setTextSize(14.0f);
                rb.setGravity(16);
                rb.setText((CharSequence)text);
                rb.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (KeyboardRadioView.this.mClickListener != null) {
                            KeyboardRadioView.this.mClickListener.onClick(index, text);
                        }
                    }
                });
                RadioGroup.LayoutParams params = new RadioGroup.LayoutParams(-2, DimensUtils.dip2pixel(this.getContext(), 32.0f));
                params.setMargins(DimensUtils.dip2pixel(this.getContext(), 12.0f), 0, 0, 0);
                this.mGroup.addView((View)rb, (ViewGroup.LayoutParams)params);
            }
        }
    }

    public void setOnItemClick(OnItemClickListener listener) {
        this.mClickListener = listener;
    }

    @Override
    public void onKeyboardShow() {
    }

    @Override
    public void onKeyboardHide() {
    }

    @Override
    public void onFoucsChange(View v) {
    }

    public static interface OnItemClickListener {
        public void onClick(int var1, String var2);
    }
}

