/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.headerviewpager;

import android.graphics.Rect;
import android.view.MotionEvent;
import android.widget.ScrollView;
import com.yy.mobile.ui.widget.headerviewpager.ViewDelegate;

public class ScrollViewDelegate
implements ViewDelegate<ScrollView> {
    private final int[] mViewLocationResult = new int[2];
    private final Rect mRect = new Rect();

    @Override
    public boolean isViewBeingDragged(MotionEvent event, ScrollView view) {
        if (view.getChildCount() == 0) {
            return true;
        }
        view.getLocationOnScreen(this.mViewLocationResult);
        int viewLeft = this.mViewLocationResult[0];
        int viewTop = this.mViewLocationResult[1];
        this.mRect.set(viewLeft, viewTop, viewLeft + view.getWidth(), viewTop + view.getHeight());
        int rawX = (int)event.getRawX();
        int rawY = (int)event.getRawY();
        if (this.mRect.contains(rawX, rawY)) {
            return this.isReadyForPull(view, (float)(rawX - this.mRect.left), (float)(rawY - this.mRect.top));
        }
        return false;
    }

    @Override
    public boolean isReadyForPull(ScrollView view, float x, float y) {
        return view.getScrollY() <= 0;
    }
}

