/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.emoticons.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.GridView;
import com.yy.mobile.framework.R;
import com.yy.mobile.richtext.EmoticonFilter;
import com.yy.mobile.ui.widget.emoticons.IEmoticonsDataInterface;
import com.yy.mobile.ui.widget.emoticons.adapter.EmoticonsGridAdapter;
import java.util.ArrayList;
import java.util.List;

public class EmoticonsPageAdapter<T extends IEmoticonsDataInterface>
extends PagerAdapter {
    private Context mContext;
    private List<T> iconList = null;
    private final int iconsPerPage;
    private final int gridColumns;
    private EmoticonsGridAdapter.IEmoticonsInsertListener<T> mListener;

    public EmoticonsPageAdapter(Context context, List<T> list, EmoticonsGridAdapter.IEmoticonsInsertListener<T> listener, int iconsPerPage, int columns) {
        this.mContext = context;
        this.iconList = list;
        this.mListener = listener;
        this.iconsPerPage = iconsPerPage;
        this.gridColumns = columns;
    }

    public int getCount() {
        return (int)Math.ceil((double)this.iconList.size() / (double)this.iconsPerPage);
    }

    public boolean isViewFromObject(View view, Object o) {
        return view == o;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        int initialPosition;
        View layout2 = LayoutInflater.from((Context)this.mContext).inflate(R.layout.emoticons_grid, null);
        ArrayList<Object> gridList = new ArrayList<Object>();
        if (this.iconList.size() > 0 && this.iconList.get(0) instanceof EmoticonFilter.SmileItem) {
            for (int i = initialPosition = position * (this.iconsPerPage - 1); i < initialPosition + this.iconsPerPage - 1 && i < this.iconList.size(); ++i) {
                gridList.add(this.iconList.get(i));
            }
            EmoticonFilter.SmileItem delIcon = new EmoticonFilter.SmileItem();
            delIcon.mText = "/{del";
            delIcon.mIcon = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)R.drawable.icon_emot_del);
            gridList.add(delIcon);
        } else {
            for (int i = initialPosition = position * this.iconsPerPage; i < initialPosition + this.iconsPerPage && i < this.iconList.size(); ++i) {
                gridList.add(this.iconList.get(i));
            }
        }
        GridView grid = (GridView)layout2.findViewById(R.id.emoticons_grid);
        grid.setNumColumns(this.gridColumns);
        EmoticonsGridAdapter adapter = new EmoticonsGridAdapter(this.mContext, gridList, this.mListener);
        grid.setAdapter(adapter);
        grid.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Log.d((String)"hjinw", (String)("onItemClick position = " + position));
            }
        });
        container.addView(layout2);
        return layout2;
    }

    public void destroyItem(ViewGroup container, int positon, Object view) {
        container.removeView((View)view);
    }
}

