/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.button;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import com.yy.mobile.framework.R;

class TintButtonHelper {
    private View mView;
    private ColorStateList mImgTintList = null;
    private ColorStateList mBgTintList = null;
    private PorterDuff.Mode mImgTintMode = PorterDuff.Mode.MULTIPLY;
    private PorterDuff.Mode mBgTintMode = PorterDuff.Mode.MULTIPLY;
    private static float DEFAULT_IMG_PRESSED_ALPHA = 0.6f;
    private float mImgPressedAlpha = DEFAULT_IMG_PRESSED_ALPHA;

    TintButtonHelper(View view) {
        this.mView = view;
    }

    void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        if (attrs != null) {
            TypedArray a = this.mView.getContext().obtainStyledAttributes(attrs, R.styleable.TintButton, defStyleAttr, 0);
            this.mImgTintList = a.getColorStateList(R.styleable.TintButton_imgTint);
            this.mBgTintList = a.getColorStateList(R.styleable.TintButton_bgTint);
            this.mImgPressedAlpha = a.getFloat(R.styleable.TintButton_imgPressedAlpha, DEFAULT_IMG_PRESSED_ALPHA);
            a.recycle();
        }
    }

    void setImgTintList(ColorStateList tint) {
        this.mImgTintList = tint;
    }

    ColorStateList getImgTintList() {
        return this.mImgTintList;
    }

    void setImgTintMode(PorterDuff.Mode mode) {
        this.mImgTintMode = mode;
    }

    PorterDuff.Mode getImgTintMode() {
        return this.mImgTintMode;
    }

    void setBgTintList(ColorStateList tint) {
        this.mBgTintList = tint;
    }

    ColorStateList getBgTintList() {
        return this.mBgTintList;
    }

    void setBgTintMode(PorterDuff.Mode mode) {
        this.mBgTintMode = mode;
    }

    PorterDuff.Mode getBgTintMode() {
        return this.mBgTintMode;
    }

    float getImgPressedAlpha() {
        return this.mImgPressedAlpha;
    }

    void setImgPressedAlpha(float imgPressedAlpha) {
        this.mImgPressedAlpha = imgPressedAlpha;
    }

    void applyImageDrawable(Drawable drawable2) {
        if (drawable2 != null && !this.mView.isInEditMode()) {
            drawable2 = drawable2.mutate();
            TintButtonHelper.applyTint(drawable2, this.mView.getDrawableState(), this.mImgTintList, this.mImgTintMode);
            TintButtonHelper.applyImagePressedAlpha(drawable2, this.mView.getDrawableState(), this.mImgPressedAlpha);
        }
    }

    void applyImageDrawable(Drawable[] drawables) {
        if (drawables != null && !this.mView.isInEditMode()) {
            for (Drawable drawable2 : drawables) {
                if (drawable2 == null) continue;
                drawable2 = drawable2.mutate();
                TintButtonHelper.applyTint(drawable2, this.mView.getDrawableState(), this.mImgTintList, this.mImgTintMode);
                TintButtonHelper.applyImagePressedAlpha(drawable2, this.mView.getDrawableState(), this.mImgPressedAlpha);
            }
        }
    }

    void applyBackgroundDrawable(Drawable drawable2) {
        if (drawable2 != null && !this.mView.isInEditMode()) {
            drawable2 = drawable2.mutate();
            TintButtonHelper.applyTint(drawable2, this.mView.getDrawableState(), this.mBgTintList, this.mBgTintMode);
        }
    }

    private static void applyTint(Drawable drawable2, int[] drawableState, ColorStateList tintList, PorterDuff.Mode tintMode) {
        if (drawable2 == null || drawableState == null) {
            return;
        }
        if (tintList == null) {
            drawable2.clearColorFilter();
        } else {
            int defaultTintColor = -1;
            int color2 = tintList.getColorForState(drawableState, defaultTintColor);
            drawable2.setColorFilter(color2, tintMode);
        }
        if (Build.VERSION.SDK_INT <= 23) {
            drawable2.invalidateSelf();
        }
    }

    private static void applyImagePressedAlpha(Drawable drawable2, int[] drawableState, float imgPressedAlpha) {
        if (drawable2 == null || drawableState == null) {
            return;
        }
        float finalAlpha = 1.0f;
        for (int s : drawableState) {
            if (s != 16842919) continue;
            finalAlpha = Math.max(0.0f, Math.min(1.0f, imgPressedAlpha));
            break;
        }
        if (Build.VERSION.SDK_INT <= 19 || (float)drawable2.getAlpha() != finalAlpha) {
            drawable2.setAlpha((int)(finalAlpha * 255.0f));
        }
    }
}

