/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.arclayout;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import com.yy.mobile.ui.widget.arclayout.ArcLayoutSettings;

public class ArcRelativeLayout
extends RelativeLayout {
    private ArcLayoutSettings settings;
    private int height = 0;
    private int width = 0;
    private Path clipPath;

    public ArcRelativeLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public ArcRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public void init(Context context, AttributeSet attrs) {
        this.settings = new ArcLayoutSettings(context, attrs);
        if (Build.VERSION.SDK_INT < 18) {
            this.setLayerType(1, null);
        }
    }

    private Path createClipPath() {
        Path path = new Path();
        float arcHeight = this.settings.getArcHeight();
        float arcCorner = this.settings.getArcCorner();
        if (arcCorner > 0.0f) {
            path.moveTo(arcCorner, 0.0f);
            path.arcTo(new RectF(0.0f, 0.0f, 2.0f * arcCorner, 2.0f * arcCorner), 270.0f, -90.0f);
            if (this.settings.isCropInside()) {
                path.lineTo(0.0f, (float)this.height - arcHeight);
                path.quadTo((float)(this.width / 2), (float)this.height + arcHeight, (float)this.width, (float)this.height - arcHeight);
                path.lineTo((float)this.width, arcCorner * 2.0f);
                path.arcTo(new RectF((float)this.width - 2.0f * arcCorner, 0.0f, (float)this.width, 2.0f * arcCorner), 0.0f, -90.0f);
                path.close();
            } else {
                path.lineTo(0.0f, (float)this.height);
                path.quadTo((float)(this.width / 2), (float)this.height - 2.0f * arcHeight, (float)this.width, (float)this.height);
                path.lineTo((float)this.width, arcCorner * 2.0f);
                path.arcTo(new RectF((float)this.width - 2.0f * arcCorner, 0.0f, (float)this.width, 2.0f * arcCorner), 0.0f, -90.0f);
                path.close();
            }
        } else {
            if (arcHeight == 0.0f) {
                return null;
            }
            path.moveTo(0.0f, 0.0f);
            if (this.settings.isCropInside()) {
                path.lineTo(0.0f, (float)this.height - arcHeight);
                path.quadTo((float)(this.width / 2), (float)this.height + arcHeight, (float)this.width, (float)this.height - arcHeight);
            } else {
                path.lineTo(0.0f, (float)this.height);
                path.quadTo((float)(this.width / 2), (float)this.height - 2.0f * arcHeight, (float)this.width, (float)this.height);
            }
            path.lineTo((float)this.width, 0.0f);
            path.close();
        }
        return path;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.calculateLayout();
        }
    }

    private void calculateLayout() {
        if (this.settings == null) {
            return;
        }
        this.height = this.getMeasuredHeight();
        this.width = this.getMeasuredWidth();
        if (this.width > 0 && this.height > 0) {
            this.clipPath = this.createClipPath();
            if (this.clipPath == null) {
                return;
            }
            ViewCompat.setElevation((View)this, (float)this.settings.getElevation());
            if (Build.VERSION.SDK_INT >= 21 && this.settings.isCropInside()) {
                ViewCompat.setElevation((View)this, (float)this.settings.getElevation());
            }
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.clipPath == null) {
            super.dispatchDraw(canvas);
            return;
        }
        canvas.save();
        canvas.setDrawFilter((DrawFilter)new PaintFlagsDrawFilter(0, 3));
        canvas.clipPath(this.clipPath);
        super.dispatchDraw(canvas);
        canvas.restore();
    }

    public void setArcHeight(int height) {
        this.settings.setArcHeight(height);
        this.requestLayout();
    }

    public void setArcCorner(float corner) {
        this.settings.setArcCorner(corner);
        this.requestLayout();
    }
}

