/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ViewHolderAdapterCompatV2<T>
extends BaseAdapter {
    List<T> mList;
    Map<Integer, ViewHolder> mViewHolderMap = new HashMap<Integer, ViewHolder>();

    public ViewHolderAdapterCompatV2(List<T> list) {
        this.mList = list;
    }

    public List<T> getList() {
        return this.mList;
    }

    public void setList(List<T> mList) {
        this.mList = mList;
        this.notifyDataSetChanged();
    }

    public void addList(List<T> list) {
        if (this.mList != null) {
            this.mList.addAll(list);
            this.notifyDataSetChanged();
        }
    }

    public void add(T t) {
        if (this.mList != null) {
            this.mList.add(t);
            this.notifyDataSetChanged();
        }
    }

    public void delete(T t) {
        if (this.mList != null && this.mList.contains(t)) {
            this.mList.remove(t);
            this.notifyDataSetChanged();
        }
    }

    public ViewHolder findViewHolderForPosition(int position) {
        if (this.mViewHolderMap != null && this.mViewHolderMap.containsKey(position)) {
            return this.mViewHolderMap.get(position);
        }
        return null;
    }

    public int getCount() {
        if (this.mList != null) {
            return this.mList.size();
        }
        return 0;
    }

    public T getItem(int position) {
        if (this.mList != null && this.mList.size() > position) {
            return this.mList.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public final View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            convertView = this.onCreateView(parent, position);
            holder = new ViewHolder(convertView, this.getItemViewType(position));
            convertView.setTag((Object)holder);
        }
        holder = (ViewHolder)convertView.getTag();
        for (int i = 0; i < this.mViewHolderMap.size(); ++i) {
            if (this.mViewHolderMap.get(position) != holder) continue;
            this.mViewHolderMap.remove(position);
        }
        this.mViewHolderMap.put(new Integer(position), holder);
        this.onBindView(holder, position);
        return convertView;
    }

    public abstract View onCreateView(ViewGroup var1, int var2);

    public abstract void onBindView(ViewHolder var1, int var2);

    public class ViewHolder {
        private View mItemView;
        private SparseArray<View> mViewHolder = new SparseArray();
        private int mViewType;

        public View getItemView() {
            return this.mItemView;
        }

        public int getViewType() {
            return this.mViewType;
        }

        public ViewHolder(View convertView, int viewType) {
            this.mItemView = convertView;
            this.mViewType = viewType;
        }

        public <T extends View> T get(int id2) {
            View childView;
            if (this.mViewHolder == null) {
                this.mViewHolder = new SparseArray();
            }
            if ((childView = (View)this.mViewHolder.get(id2)) == null) {
                childView = this.mItemView.findViewById(id2);
                this.mViewHolder.put(id2, (Object)childView);
            }
            return (T)childView;
        }
    }
}

