/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ExpandableListView;
import com.yy.mobile.util.log.MLog;

public class PinnedHeaderExpandableListView
extends ExpandableListView
implements AbsListView.OnScrollListener {
    private static final String TAG = "PinnedHeaderExpandableListView";
    private View mHeaderView;
    private int mHeaderWidth;
    private int mHeaderHeight;
    private View mTouchTarget;
    private AbsListView.OnScrollListener mScrollListener;
    private PinnedHeaderListener mHeaderListener;
    private boolean mActionDownHappened = false;

    public PinnedHeaderExpandableListView(Context context) {
        super(context);
        this.initView();
    }

    public PinnedHeaderExpandableListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public PinnedHeaderExpandableListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    private void initView() {
        this.setFadingEdgeLength(0);
        this.setOnScrollListener(this);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        if (l != this) {
            this.mScrollListener = l;
        }
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
    }

    public void setPinnedHeaderListener(PinnedHeaderListener listener) {
        this.mHeaderListener = listener;
        if (listener == null) {
            this.mHeaderView = null;
            this.mHeaderHeight = 0;
            this.mHeaderWidth = 0;
            return;
        }
        this.mHeaderView = listener.getPinnedHeader();
        int firstVisiblePos = this.getFirstVisiblePosition();
        int firstVisibleGroupPos = PinnedHeaderExpandableListView.getPackedPositionGroup((long)this.getExpandableListPosition(firstVisiblePos));
        listener.updatePinnedHeader(this.mHeaderView, firstVisibleGroupPos);
        this.requestLayout();
        this.postInvalidate();
    }

    public PinnedHeaderListener getPinnedHeaderListener() {
        return this.mHeaderListener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mHeaderView == null) {
            return;
        }
        this.measureChild(this.mHeaderView, widthMeasureSpec, heightMeasureSpec);
        this.mHeaderWidth = this.mHeaderView.getMeasuredWidth();
        this.mHeaderHeight = this.mHeaderView.getMeasuredHeight();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mHeaderView == null) {
            return;
        }
        int delta = this.mHeaderView.getTop();
        this.mHeaderView.layout(0, delta, this.mHeaderWidth, this.mHeaderHeight + delta);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mHeaderView != null) {
            this.drawChild(canvas, this.mHeaderView, this.getDrawingTime());
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int x = (int)ev.getX();
        int y = (int)ev.getY();
        int pos = this.pointToPosition(x, y);
        if (this.mHeaderView != null && y >= this.mHeaderView.getTop() && y <= this.mHeaderView.getBottom()) {
            if (ev.getAction() == 0) {
                this.mTouchTarget = this.getTouchTarget(this.mHeaderView, x, y);
                this.mActionDownHappened = true;
            } else if (ev.getAction() == 1) {
                View touchTarget = this.getTouchTarget(this.mHeaderView, x, y);
                if (touchTarget == this.mTouchTarget && this.mTouchTarget.isClickable()) {
                    this.mTouchTarget.performClick();
                    this.invalidate(new Rect(0, 0, this.mHeaderWidth, this.mHeaderHeight));
                } else {
                    int groupPosition = PinnedHeaderExpandableListView.getPackedPositionGroup((long)this.getExpandableListPosition(pos));
                    if (groupPosition != -1 && this.mActionDownHappened) {
                        if (this.mHeaderListener == null) {
                            if (this.isGroupExpanded(groupPosition)) {
                                this.collapseGroup(groupPosition);
                            } else {
                                this.expandGroup(groupPosition);
                            }
                        } else {
                            this.mHeaderListener.onPinnedHeaderClick(groupPosition);
                        }
                    }
                }
                this.mActionDownHappened = false;
            }
            return true;
        }
        return super.dispatchTouchEvent(ev);
    }

    private View getTouchTarget(View view, int x, int y) {
        if (!(view instanceof ViewGroup)) {
            return view;
        }
        ViewGroup parent = (ViewGroup)view;
        int childrenCount = parent.getChildCount();
        boolean customOrder = this.isChildrenDrawingOrderEnabled();
        ViewGroup target = null;
        for (int i = childrenCount - 1; i >= 0; --i) {
            int childIndex = customOrder ? this.getChildDrawingOrder(childrenCount, i) : i;
            View child = parent.getChildAt(childIndex);
            if (!this.isTouchPointInView(child, x, y)) continue;
            target = child;
            break;
        }
        if (target == null) {
            target = parent;
        }
        return target;
    }

    private boolean isTouchPointInView(View view, int x, int y) {
        return view.isClickable() && y >= view.getTop() && y <= view.getBottom() && x >= view.getLeft() && x <= view.getRight();
    }

    public void requestRefreshHeader() {
        this.refreshHeader();
        this.invalidate(new Rect(0, 0, this.mHeaderWidth, this.mHeaderHeight));
    }

    protected void refreshHeader() {
        if (this.mHeaderView == null) {
            return;
        }
        int firstVisiblePos = this.getFirstVisiblePosition();
        int pos = firstVisiblePos + 1;
        int firstVisibleGroupPos = PinnedHeaderExpandableListView.getPackedPositionGroup((long)this.getExpandableListPosition(firstVisiblePos));
        int group = PinnedHeaderExpandableListView.getPackedPositionGroup((long)this.getExpandableListPosition(pos));
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "refreshHeader firstVisiblePos = " + firstVisiblePos + ", pos = " + pos + ", firstVisibleGroupPos = " + firstVisibleGroupPos + ", group = " + group, new Object[0]);
        }
        if (group == firstVisibleGroupPos + 1) {
            View view = this.getChildAt(1);
            if (view == null) {
                MLog.warn(TAG, "Warning : refreshHeader getChildAt(1)=null", new Object[0]);
                return;
            }
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug(TAG, "refreshHeader view.getTop() = " + view.getTop() + ", mHeaderHeight = " + this.mHeaderHeight, new Object[0]);
            }
            if (view.getTop() <= this.mHeaderHeight) {
                int delta = this.mHeaderHeight - view.getTop();
                this.mHeaderView.layout(0, -delta, this.mHeaderWidth, this.mHeaderHeight - delta);
            } else {
                this.mHeaderView.layout(0, 0, this.mHeaderWidth, this.mHeaderHeight);
            }
        } else {
            this.mHeaderView.layout(0, 0, this.mHeaderWidth, this.mHeaderHeight);
        }
        if (this.mHeaderListener != null) {
            this.mHeaderListener.updatePinnedHeader(this.mHeaderView, firstVisibleGroupPos);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (totalItemCount > 0) {
            this.refreshHeader();
        }
        if (this.mScrollListener != null) {
            this.mScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    public static interface PinnedHeaderListener {
        public View getPinnedHeader();

        public void updatePinnedHeader(View var1, int var2);

        public void onPinnedHeaderClick(int var1);
    }
}

