/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;

public class OnSwipeTouchListener {
    private final GestureDetector gestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new GestureListener());

    public boolean onTouchEvent(MotionEvent event) {
        return this.gestureDetector.onTouchEvent(event);
    }

    public boolean onSwipeRight() {
        return false;
    }

    public boolean onSwipeLeft() {
        return false;
    }

    public boolean onSwipeTop() {
        return false;
    }

    public boolean onSwipeBottom() {
        return false;
    }

    private final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private static final int SWIPE_THRESHOLD = 500;
        private static final int SWIPE_VELOCITY_THRESHOLD = 200;

        private GestureListener() {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            boolean result = false;
            try {
                float diffY = e2.getY() - e1.getY();
                float diffX = e2.getX() - e1.getX();
                if (Math.abs(diffX) > Math.abs(diffY)) {
                    if (Math.abs(diffX) > 500.0f && Math.abs(velocityX) > 200.0f) {
                        result = diffX > 0.0f ? OnSwipeTouchListener.this.onSwipeRight() : OnSwipeTouchListener.this.onSwipeLeft();
                    }
                } else if (Math.abs(diffY) > 500.0f && Math.abs(velocityY) > 200.0f) {
                    result = diffY > 0.0f ? OnSwipeTouchListener.this.onSwipeBottom() : OnSwipeTouchListener.this.onSwipeTop();
                }
            }
            catch (Exception exception) {
                Log.e((String)"OnSwipeTouchListener", (String)"printStackTrace", (Throwable)exception);
            }
            return result;
        }
    }
}

