/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.TextView;

public class JustifyTextView
extends TextView {
    private int mLineY;
    private int mViewWidth;

    public JustifyTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        TextPaint paint = this.getPaint();
        paint.setColor(this.getCurrentTextColor());
        paint.drawableState = this.getDrawableState();
        this.mViewWidth = this.getMeasuredWidth();
        CharSequence text = this.getText();
        this.mLineY = 0;
        this.mLineY = (int)((float)this.mLineY + this.getTextSize());
        Layout layout2 = this.getLayout();
        for (int i = 0; i < layout2.getLineCount(); ++i) {
            int lineStart = layout2.getLineStart(i);
            int lineEnd = layout2.getLineEnd(i);
            String line = text.toString().substring(lineStart, lineEnd);
            float width = StaticLayout.getDesiredWidth((CharSequence)text, (int)lineStart, (int)lineEnd, (TextPaint)this.getPaint());
            if (this.needScale(line)) {
                this.drawScaledText(canvas, lineStart, line, width);
            } else {
                canvas.drawText(line, 0.0f, (float)this.mLineY, (Paint)paint);
            }
            this.mLineY += this.getLineHeight();
        }
    }

    private void drawScaledText(Canvas canvas, int lineStart, String line, float lineWidth) {
        float x = 0.0f;
        if (this.isFirstLineOfParagraph(lineStart, line)) {
            String blanks = "  ";
            canvas.drawText(blanks, x, (float)this.mLineY, (Paint)this.getPaint());
            float bw = StaticLayout.getDesiredWidth((CharSequence)blanks, (TextPaint)this.getPaint());
            x += bw;
            line = line.substring(3);
        }
        float d = ((float)this.mViewWidth - lineWidth) / (float)line.length() - 1.0f;
        for (int i = 0; i < line.length(); ++i) {
            String c = String.valueOf(line.charAt(i));
            float cw = StaticLayout.getDesiredWidth((CharSequence)c, (TextPaint)this.getPaint());
            canvas.drawText(c, x, (float)this.mLineY, (Paint)this.getPaint());
            x += cw + d;
        }
    }

    private boolean isFirstLineOfParagraph(int lineStart, String line) {
        return line.length() > 3 && line.charAt(0) == ' ' && line.charAt(1) == ' ';
    }

    private boolean needScale(String line) {
        if (line.length() == 0) {
            return false;
        }
        return line.charAt(line.length() - 1) != '\n';
    }
}

