/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.statistic;

import android.os.SystemClock;
import com.yy.mobile.statistic.AbstractReportProperty;
import com.yy.mobile.statistic.StatisticDataContainer;
import com.yy.mobile.statistic.StatisticDataContainerInterface;
import com.yy.mobile.statistic.StatisticDataModelBase;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.asynctask.ScheduledTask;
import com.yy.mobile.util.log.MLog;
import java.util.HashMap;
import java.util.Map;

public class StatisticService {
    public static final long MINS_5 = 5L;
    public static final long MINS_1 = 1L;
    private static final String TAG = "StatisticService";
    private Map<Long, Map<String, StatisticDataContainerInterface>> taskMap;
    private AbstractReportProperty reportProperty;
    private ScheduledTask reportTask;
    private Map<Long, Runnable> reportCommandMap;
    private Map<Class<? extends StatisticDataModelBase>, StatisticDataModelBase> map = new HashMap<Class<? extends StatisticDataModelBase>, StatisticDataModelBase>();
    private static StatisticService mInstance;

    private StatisticService() {
        this.init();
    }

    public static synchronized StatisticService instance() {
        if (mInstance == null) {
            mInstance = new StatisticService();
        }
        return mInstance;
    }

    public void init() {
        this.map = new HashMap<Class<? extends StatisticDataModelBase>, StatisticDataModelBase>();
        this.reportTask = ScheduledTask.getInstance();
    }

    public void addReportContainer(final long interval, String reportUrl, StatisticDataContainerInterface containerInterface) {
        if (this.taskMap == null) {
            this.taskMap = new HashMap<Long, Map<String, StatisticDataContainerInterface>>();
        }
        if (!this.taskMap.containsKey(interval)) {
            HashMap map = new HashMap();
            this.taskMap.put(interval, map);
        }
        this.taskMap.get(interval).put(reportUrl, containerInterface);
        if (this.reportCommandMap == null) {
            this.reportCommandMap = new HashMap<Long, Runnable>();
        }
        if (!this.reportCommandMap.containsKey(interval)) {
            this.reportCommandMap.put(interval, new Runnable(){

                @Override
                public void run() {
                    Long context = SystemClock.elapsedRealtime();
                    StatisticService.this.postData(context, interval);
                    StatisticService.this.reportTask.scheduledDelayed(this, interval);
                }
            });
            this.start(interval);
        }
    }

    public void setReportProperty(AbstractReportProperty reportProperty) {
        this.reportProperty = reportProperty;
    }

    public void start(long interval) {
        if (this.reportCommandMap != null && this.reportCommandMap.containsKey(interval)) {
            this.reportTask.scheduledDelayed(this.reportCommandMap.get(interval), interval);
        }
    }

    public void stop(long interval) {
        if (this.reportCommandMap != null && this.reportCommandMap.containsKey(interval)) {
            this.reportTask.removeCallbacks(this.reportCommandMap.get(interval));
        }
    }

    public <T extends StatisticDataModelBase> T get(Class<T> clazz) {
        StatisticDataModelBase model = this.map.get(clazz);
        if (model == null) {
            try {
                model = (StatisticDataModelBase)clazz.newInstance();
                this.map.put(clazz, model);
            }
            catch (InstantiationException e) {
                MLog.error((Object)TAG, "register  " + e.toString(), new Object[0]);
            }
            catch (IllegalAccessException e) {
                MLog.error((Object)TAG, "register  " + e.toString(), new Object[0]);
            }
        }
        return (T)model;
    }

    private void postData(Object context, long interval) {
        if (context == null || this.taskMap == null || this.taskMap.isEmpty() || !this.taskMap.containsKey(interval)) {
            return;
        }
        for (Map.Entry<String, StatisticDataContainerInterface> entry : this.taskMap.get(interval).entrySet()) {
            String url = entry.getKey();
            StatisticDataContainerInterface containerInterface = entry.getValue();
            String jsonStr = containerInterface.getAsJson(context, this.reportProperty);
            if (FP.empty(url) || FP.empty(jsonStr)) {
                containerInterface.onReportFail(context);
                continue;
            }
            containerInterface.submitRequest(context, url, jsonStr);
        }
    }

    private void onPostSuc(Object context) {
        if (context != null) {
            StatisticDataContainer.instance().onReportSuc(context);
        }
    }

    private void onPostFail(Object context) {
        if (context != null) {
            StatisticDataContainer.instance().onReportFail(context);
        }
    }
}

