/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.statistic;

import android.os.Build;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.guid.GuidFactory;
import com.yy.mobile.http.DefaultRequestParam;
import com.yy.mobile.http.DefaultRetryPolicy;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.http.StringPostRequest;
import com.yy.mobile.statistic.AbstractReportProperty;
import com.yy.mobile.statistic.BaseStatisticDataContainer;
import com.yy.mobile.statistic.StatisticDataModelBase;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;

public class StatisticNewDataContainer
extends BaseStatisticDataContainer {
    private static final String TAG = "StatisticNewDataContainer";

    @Override
    public String getAsJson(Object context, AbstractReportProperty reportProperty) {
        if (context == null || FP.empty(this.dataList)) {
            return null;
        }
        try {
            Gson gson = this.mGsonBuilder.create();
            JsonObject jsonObject = new JsonObject();
            ArrayList<StatisticDataModelBase> list = new ArrayList<StatisticDataModelBase>();
            for (StatisticDataModelBase item : this.dataList) {
                if (item.isReporting) continue;
                item.reportContext = context;
                item.isReporting = true;
                list.add(item);
            }
            if (list.size() > 0) {
                jsonObject.add("playload", gson.toJsonTree(list));
            }
            if (gson.toJson((JsonElement)jsonObject).equals("{}")) {
                return null;
            }
            jsonObject.addProperty("ns", "mobperf");
            jsonObject.addProperty("platform", "android");
            jsonObject.addProperty("yyplatform", VersionUtil.getLocalVer(BasicConfig.getInstance().getAppContext()).toString());
            jsonObject.addProperty("sid", GuidFactory.getInstance().getGuid());
            jsonObject.addProperty("sysversion", "Android" + Build.VERSION.RELEASE);
            jsonObject.addProperty("time", (Number)System.currentTimeMillis());
            jsonObject.addProperty("device", Build.MANUFACTURER + "_" + Build.MODEL);
            return gson.toJson((JsonElement)jsonObject);
        }
        catch (Exception e) {
            MLog.error(TAG, e);
            return null;
        }
    }

    @Override
    public void submitRequest(final Object context, String url, String jsonData) {
        DefaultRequestParam param = new DefaultRequestParam();
        StringPostRequest<String> request = new StringPostRequest<String>(url, param, new ResponseListener<String>(){

            @Override
            public void onResponse(String response) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(StatisticNewDataContainer.TAG, "wallen postData succeed! " + response, new Object[0]);
                }
                StatisticNewDataContainer.this.onReportSuc(context);
            }
        }, new ResponseErrorListener(){

            @Override
            public void onErrorResponse(RequestError error) {
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose(StatisticNewDataContainer.TAG, "wallen reportByHttp : onErrorResponse", error.toString());
                }
                StatisticNewDataContainer.this.onReportFail(context);
            }
        });
        request.setContentType("application/json");
        request.setString(jsonData);
        request.setRunOnUIThread(true);
        request.setRetryPolicy(new DefaultRetryPolicy(5000, 1, 0.0f));
        RequestManager.instance().submitRequest(request);
    }

    @Override
    public void addData(StatisticDataModelBase dataModelBase) {
        if (dataModelBase == null) {
            return;
        }
        this.dataList.add(dataModelBase);
    }

    @Override
    public void onReportSuc(Object context) {
        for (StatisticDataModelBase item : this.dataList) {
            if (item.reportContext != context) continue;
            this.dataList.remove(item);
        }
    }

    @Override
    public void onReportFail(Object context) {
        for (StatisticDataModelBase item : this.dataList) {
            if (item.reportContext != context) continue;
            item.isReporting = false;
        }
    }

    @Override
    public void clear() {
        this.dataList.clear();
    }
}

