/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.statistic;

import android.os.SystemClock;
import com.yy.mobile.statistic.StatisticDataModelBase;
import com.yy.mobile.util.asynctask.ScheduledTask;
import com.yy.mobile.util.log.MLog;

public abstract class DurationStatisticDataModel
extends StatisticDataModelBase {
    private long beginTime;
    private boolean isRunning;
    private long timeoutMillis;
    private boolean ignoreEnd;
    private final ScheduledTask mTimeoutCheckTask = ScheduledTask.getInstance();
    private Runnable mTimeoutCommand = new Runnable(){

        @Override
        public void run() {
            DurationStatisticDataModel.this.onTimeout();
        }
    };

    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    protected abstract String getActionName();

    protected long onTimeout() {
        if (this.isRunning) {
            if (this.ignoreEnd) {
                this.isRunning = false;
            }
            return this.timeoutMillis;
        }
        return 0L;
    }

    protected final void removeTimeout() {
        this.mTimeoutCheckTask.removeCallbacks(this.mTimeoutCommand);
    }

    protected final long onEventBegin() {
        return this.onEventBegin(0L, false);
    }

    protected final long onEventBegin(long timeoutMillis, boolean ignoreEnd) {
        this.reset();
        this.beginTime = this.getTime();
        this.isRunning = true;
        if (timeoutMillis > 0L) {
            this.timeoutMillis = timeoutMillis;
            this.ignoreEnd = ignoreEnd;
            this.mTimeoutCheckTask.scheduledDelayed(this.mTimeoutCommand, timeoutMillis);
        }
        return this.beginTime;
    }

    protected final long onEventEnd() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug("DurationStatisticDataModel", "%s --> isRunning=%b, start:%d, timeNow:%d", this.getActionName(), this.isRunning, this.beginTime, this.getTime());
        }
        long duration = 0L;
        if (this.isRunning) {
            duration = this.getTimeSinceBegin();
            this.reset();
        }
        return duration;
    }

    protected final long onEventEnd(long bTime) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug("DurationStatisticDataModel", "%s --> isRunning=%b, start:%d, timeNow:%d", this.getActionName(), this.isRunning, this.beginTime, this.getTime());
        }
        long duration = 0L;
        if (this.isRunning) {
            duration = this.isRunning ? this.getTime() - bTime : 0L;
            this.reset();
        }
        return duration;
    }

    @Override
    protected void sendToContainer() {
        super.sendToContainer();
    }

    @Override
    protected void reset() {
        super.reset();
        this.removeTimeout();
        this.isRunning = false;
        this.ignoreEnd = false;
        this.beginTime = 0L;
        this.timeoutMillis = 0L;
    }

    private long getTime() {
        return SystemClock.elapsedRealtime();
    }

    public long getTimeSinceBegin() {
        return this.isRunning ? this.getTime() - this.beginTime : 0L;
    }
}

