/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.stackblur;

import android.graphics.Bitmap;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.sodynamicload.SoDynamicLoader;
import com.yy.mobile.util.DontProguardClass;
import com.yy.mobile.util.log.MLog;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

@DontProguardClass
public class NativeBlurProcess {
    private static AtomicBoolean isLoadLibraryOk = new AtomicBoolean(false);

    private static native void functionToBlur(Bitmap var0, int var1, int var2, int var3, int var4);

    public static Bitmap blur(Bitmap original, float radius, boolean useMultiThread) {
        if (!isLoadLibraryOk.get() || original == null) {
            MLog.info("NativeBlurProcess", original == null ? "original null!" : "isLoadLibraryOk false!", new Object[0]);
            return original;
        }
        long begin = 0L;
        if (BasicConfig.getInstance().isDebuggable()) {
            begin = System.currentTimeMillis();
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug("NativeBlurProcess", "blur begin, radius = " + radius, new Object[0]);
            }
        }
        Bitmap bitmapOut = original.copy(Bitmap.Config.ARGB_8888, true);
        NativeBlurProcess.functionToBlur(bitmapOut, (int)radius, 1, 0, 1);
        NativeBlurProcess.functionToBlur(bitmapOut, (int)radius, 1, 0, 2);
        if (BasicConfig.getInstance().isDebuggable() && MLog.isLogLevelAboveDebug()) {
            MLog.debug("NativeBlurProcess", "blur radius:" + radius + " end, cast time  = " + (System.currentTimeMillis() - begin), new Object[0]);
        }
        return bitmapOut;
    }

    static {
        try {
            SoDynamicLoader.loadSo("stackblur");
            isLoadLibraryOk.set(true);
            MLog.info("NativeBlurProcess", "loadLibrary success!", new Object[0]);
        }
        catch (Throwable throwable) {
            MLog.error((Object)"NativeBlurProcess", "loadLibrary error!" + throwable, new Object[0]);
        }
    }

    private static class NativeTask
    implements Callable<Void> {
        private final Bitmap bitmapOut;
        private final int radius;
        private final int totalCores;
        private final int coreIndex;
        private final int round;

        public NativeTask(Bitmap bitmapOut, int radius, int totalCores, int coreIndex, int round) {
            this.bitmapOut = bitmapOut;
            this.radius = radius;
            this.totalCores = totalCores;
            this.coreIndex = coreIndex;
            this.round = round;
        }

        @Override
        public Void call() throws Exception {
            NativeBlurProcess.functionToBlur(this.bitmapOut, this.radius, this.totalCores, this.coreIndex, this.round);
            return null;
        }
    }
}

