/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sodynamicload;

import android.content.Context;
import android.util.Log;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.sodynamicload.IStatsSubmiter;
import com.yy.mobile.util.StringUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class SoDynamicLoader {
    private static boolean sSwitch;
    private static String sDir;
    private static IStatsSubmiter sStatsSubmiter;

    public static void setData(String dirPath, boolean switchOk) {
        sSwitch = switchOk;
        sDir = dirPath;
    }

    public static void setStatsSubmiter(IStatsSubmiter statsSubmiter) {
        sStatsSubmiter = statsSubmiter;
    }

    public static void loadSo(String name) {
        if (!sSwitch || StringUtils.isEmpty(sDir).booleanValue()) {
            System.loadLibrary(name);
            return;
        }
        if (!"stackblur".equals(name)) {
            System.loadLibrary(name);
            return;
        }
        String downloadedSoName = SoDynamicLoader.getSoFullName(name);
        File downloadSo = new File(sDir, downloadedSoName);
        if (downloadSo.exists() && downloadSo.isFile()) {
            try {
                System.load(downloadSo.getPath());
                SoDynamicLoader.addLoadSoStatics(2, name, true, null);
            }
            catch (Throwable throwable) {
                SoDynamicLoader.addLoadSoStatics(2, name, false, throwable);
                SoDynamicLoader.loadLibrary(name);
            }
        } else {
            SoDynamicLoader.loadLibrary(name);
        }
    }

    private static void loadLibrary(String name) {
        try {
            System.loadLibrary(name);
            SoDynamicLoader.addLoadSoStatics(1, name, true, null);
        }
        catch (Throwable throwable) {
            SoDynamicLoader.addLoadSoStatics(1, name, false, throwable);
            throw throwable;
        }
    }

    public static void addLoadSoStatics(int loadType, String soName, boolean successed, Throwable throwable) {
        HashMap<String, String> keyAndValues = new HashMap<String, String>(12);
        keyAndValues.put("res", successed ? "1" : "0");
        keyAndValues.put("name", soName);
        keyAndValues.put("lot", String.valueOf(loadType));
        if (!successed) {
            if (throwable != null) {
                String throwableString = throwable.toString();
                if (throwableString.length() > 250) {
                    keyAndValues.put("exc", throwableString.substring(0, 250));
                } else {
                    keyAndValues.put("exc", throwableString);
                }
            }
            if (loadType == 1) {
                try {
                    ClassLoader loader;
                    Class<?> threadClazz = Class.forName("dalvik.system.VMStack");
                    Method method = threadClazz.getMethod("getCallingClassLoader", new Class[]{null});
                    if (method != null && (loader = (ClassLoader)method.invoke(null, new Object[]{null})) != null) {
                        keyAndValues.put("path", loader.getClass().getName());
                    }
                }
                catch (Throwable e) {
                    Log.e((String)"SoDynamicLoader", (String)"Empty Catch on addLoadSoStatics", (Throwable)e);
                }
                if (BasicConfig.getInstance().getAppContext() != null) {
                    String path = SoDynamicLoader.findSoInLibDir(SoDynamicLoader.getSoFullName(soName));
                    if (path == null) {
                        path = "";
                    }
                    keyAndValues.put("sopath", path);
                }
            }
        }
        SoDynamicLoader.addStats("loadso", keyAndValues);
    }

    public static String getSoFullName(String name) {
        return "lib" + name + ".so";
    }

    private static String findSoInLibDir(String soName) {
        Context context = BasicConfig.getInstance().getAppContext();
        if (context == null) {
            return null;
        }
        File path = context.getDir("lib", 0);
        String realPath = path.getParent() + File.separator + "lib";
        return SoDynamicLoader.findFileInDir(new File(realPath), soName);
    }

    private static String findFileInDir(File dir, String fileName) {
        File[] files;
        String path = null;
        if (dir != null && dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null && files.length > 0) {
            for (File tempFile : files) {
                if (tempFile == null || !tempFile.exists()) continue;
                if (StringUtils.equal(tempFile.getName(), fileName) && tempFile.isFile()) {
                    path = dir.getPath();
                    break;
                }
                if (tempFile.isDirectory() && (path = SoDynamicLoader.findFileInDir(tempFile, fileName)) != null) break;
            }
        }
        return path;
    }

    public static void addStats(String type, Map<String, String> keyAndValues) {
        if (sStatsSubmiter != null) {
            sStatsSubmiter.addStats(type, keyAndValues);
        }
    }
}

