/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import android.util.Pair;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.framework.R;
import com.yy.mobile.richtext.BaseRichTextFilter;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.ui.widget.emoticons.IEmoticonsDataInterface;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class EmoticonFilter
extends BaseRichTextFilter {
    private static final String TAG = "EmoticonFilter";
    private static final String[] sSmileCodes = new String[]{"/{wx", "/{dx", "/{tp", "/{jy", "/{pz", "/{fn", "/{ng", "/{hk", "/{kz", "/{ot", "/{se", "/{tx", "/{ka", "/{by", "/{am", "/{kun", "/{hp", "/{lh", "/{kx", "/{cy", "/{ll", "/{fd", "/{yw", "/{xu", "/{yun", "/{zs", "/{kl", "/{qd", "/{88", "/{dy", "/{zt", "/{bz", "/{yb", "/{dai", "/{sj", "/{hx", "/{gz", "/{kb", "/{kel", "/{qq", "/{wq", "/{yx", "/{zk", "/{bs", "/{bq", "/{ok", "/{zan", "/{ruo", "/{ws", "/{sl", "/{mg", "/{kw", "/{wen", "/{xd", "/{xs", "/{lw", "/{sd", "/{zd", "/{dao", "/{cc"};
    private static final int[] sSmileResId = new int[]{R.drawable.wx, R.drawable.dx, R.drawable.tp, R.drawable.jy, R.drawable.pz, R.drawable.fn, R.drawable.ng, R.drawable.hk, R.drawable.kz, R.drawable.ot, R.drawable.se, R.drawable.tx, R.drawable.ka, R.drawable.by, R.drawable.am, R.drawable.kun, R.drawable.hp, R.drawable.lh, R.drawable.kx, R.drawable.cy, R.drawable.ll, R.drawable.fd, R.drawable.yw, R.drawable.xu, R.drawable.yun, R.drawable.zs, R.drawable.kul, R.drawable.qd, R.drawable.bb, R.drawable.dy, R.drawable.zt, R.drawable.bz, R.drawable.yb, R.drawable.dai, R.drawable.sj, R.drawable.hx, R.drawable.gz, R.drawable.kb, R.drawable.kl, R.drawable.qq, R.drawable.wq, R.drawable.yx, R.drawable.zk, R.drawable.bs, R.drawable.bq, R.drawable.ok, R.drawable.zan, R.drawable.ruo, R.drawable.ws, R.drawable.sl, R.drawable.mg, R.drawable.kw, R.drawable.wen, R.drawable.xd, R.drawable.xs, R.drawable.lw, R.drawable.sd, R.drawable.zd, R.drawable.dao, R.drawable.cc};
    private static List<SmileItem> sSmileList = new ArrayList<SmileItem>(sSmileCodes.length);
    private static Set<SmileCompare> sSmileOrderSet = new TreeSet<SmileCompare>();
    public static final String FLAG = "/{";
    private static final String[] nSmileCodes = new String[]{"/{nbq", "/{ncy", "/{nse", "/{nxd", "/{nyb", "/{nkb", "/{nku", "/{not", "/{sjt", "/{xjt", "/{zjt", "/{yjt", "/{nbs", "/{ndx", "/{ngz", "/{nhx", "/{nlh", "/{nzs", "/{nsj", "/{ntx", "/{nwx", "/{nwq"};
    private static final int[] nSmileResId = new int[]{R.drawable.bq, R.drawable.cy, R.drawable.se, R.drawable.xd, R.drawable.yb, R.drawable.kb, R.drawable.ll, R.drawable.ot, R.drawable.sjt, R.drawable.xjt, R.drawable.zjt, R.drawable.yjt, R.drawable.bs, R.drawable.dx, R.drawable.gz, R.drawable.hx, R.drawable.lh, R.drawable.zs, R.drawable.sj, R.drawable.tx, R.drawable.wx, R.drawable.wq};
    private static List<SmileItem> nSmileList = new ArrayList<SmileItem>(nSmileCodes.length);
    private static Set<SmileCompare> nSmileOrderSet = new TreeSet<SmileCompare>();
    private static final String[] allSmileCodes = new String[]{"/{wx", "/{dx", "/{tp", "/{jy", "/{pz", "/{fn", "/{ng", "/{hk", "/{kz", "/{ot", "/{se", "/{tx", "/{ka", "/{by", "/{am", "/{kun", "/{hp", "/{lh", "/{kx", "/{cy", "/{ll", "/{fd", "/{yw", "/{xu", "/{yun", "/{zs", "/{kl", "/{qd", "/{88", "/{dy", "/{zt", "/{bz", "/{yb", "/{dai", "/{sj", "/{hx", "/{gz", "/{kb", "/{kel", "/{qq", "/{wq", "/{yx", "/{zk", "/{bs", "/{bq", "/{ok", "/{zan", "/{ruo", "/{ws", "/{sl", "/{mg", "/{kw", "/{wen", "/{xd", "/{xs", "/{lw", "/{sd", "/{zd", "/{dao", "/{cc", "/{nbq", "/{ncy", "/{nse", "/{nxd", "/{nyb", "/{nkb", "/{nku", "/{not", "/{sjt", "/{xjt", "/{zjt", "/{yjt", "/{nbs", "/{ndx", "/{ngz", "/{nhx", "/{nlh", "/{nzs", "/{nsj", "/{ntx", "/{nwx", "/{nwq"};
    private static final int[] allSmileResId = new int[]{R.drawable.wx, R.drawable.dx, R.drawable.tp, R.drawable.jy, R.drawable.pz, R.drawable.fn, R.drawable.ng, R.drawable.hk, R.drawable.kz, R.drawable.ot, R.drawable.se, R.drawable.tx, R.drawable.ka, R.drawable.by, R.drawable.am, R.drawable.kun, R.drawable.hp, R.drawable.lh, R.drawable.kx, R.drawable.cy, R.drawable.ll, R.drawable.fd, R.drawable.yw, R.drawable.xu, R.drawable.yun, R.drawable.zs, R.drawable.kul, R.drawable.qd, R.drawable.bb, R.drawable.dy, R.drawable.zt, R.drawable.bz, R.drawable.yb, R.drawable.dai, R.drawable.sj, R.drawable.hx, R.drawable.gz, R.drawable.kb, R.drawable.kl, R.drawable.qq, R.drawable.wq, R.drawable.yx, R.drawable.zk, R.drawable.bs, R.drawable.bq, R.drawable.ok, R.drawable.zan, R.drawable.ruo, R.drawable.ws, R.drawable.sl, R.drawable.mg, R.drawable.kw, R.drawable.wen, R.drawable.xd, R.drawable.xs, R.drawable.lw, R.drawable.sd, R.drawable.zd, R.drawable.dao, R.drawable.cc, R.drawable.bq, R.drawable.cy, R.drawable.se, R.drawable.xd, R.drawable.yb, R.drawable.kb, R.drawable.ll, R.drawable.ot, R.drawable.sjt, R.drawable.xjt, R.drawable.zjt, R.drawable.yjt, R.drawable.bs, R.drawable.dx, R.drawable.gz, R.drawable.hx, R.drawable.lh, R.drawable.zs, R.drawable.sj, R.drawable.tx, R.drawable.wx, R.drawable.wq};
    private static List<SmileItem> allSmileList = new ArrayList<SmileItem>(allSmileCodes.length);
    private static Set<SmileCompare> allSmileOrderSet = new TreeSet<SmileCompare>();
    public static final int SMILE_TYPE_GENERAL = 1;
    public static final int SMILE_TYPE_NEW = 2;
    private static final int MAX_LENGTH = 5;

    public static String[] getAllSmileCodes() {
        return allSmileCodes;
    }

    public static Set<SmileCompare> getNSmileSet(Context context) {
        if (nSmileOrderSet.isEmpty()) {
            EmoticonFilter.createNew(context);
        }
        return new TreeSet<SmileCompare>(nSmileOrderSet);
    }

    public static List<SmileItem> getAllSmileList(Context context) {
        if (allSmileList.isEmpty()) {
            EmoticonFilter.createAllNew(context);
        }
        return new ArrayList<SmileItem>(allSmileList);
    }

    public static List<SmileItem> getNSmileList(Context context) {
        if (nSmileList.isEmpty()) {
            EmoticonFilter.createNew(context);
        }
        return new ArrayList<SmileItem>(nSmileList);
    }

    public static List<SmileItem> getSmileList(Context context) {
        if (sSmileList.isEmpty()) {
            EmoticonFilter.create(context);
        }
        return new ArrayList<SmileItem>(sSmileList);
    }

    public static synchronized void createAllNew(Context context) {
        int count = allSmileCodes.length;
        if (context == null) {
            return;
        }
        if (!allSmileList.isEmpty()) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug(TAG, "nSmileList is not empty. return.", new Object[0]);
            }
            return;
        }
        for (int i = 0; i < count; ++i) {
            Bitmap bmp = BitmapFactory.decodeResource((Resources)context.getResources(), (int)allSmileResId[i]);
            SmileItem s = new SmileItem();
            s.mText = allSmileCodes[i];
            s.mIcon = bmp;
            s.mDrawable = new BitmapDrawable(context.getResources(), s.mIcon);
            int size = context.getResources().getDimensionPixelOffset(R.dimen.emotion_span_size);
            s.mDrawable.setBounds(0, 0, size, size);
            allSmileList.add(s);
            SmileCompare sc = new SmileCompare();
            sc.mItem = s;
            int length = s.mText.length();
            sc.mKeyBase = 0;
            sc.mKeyLength = length - 2;
            sc.mKey = new char[sc.mKeyLength];
            s.mText.getChars(2, length, sc.mKey, 0);
            try {
                allSmileOrderSet.add(sc);
                continue;
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, "EmoticonFilter createAllNew" + throwable, new Object[0]);
            }
        }
        SmileCompare.sTemp = new SmileCompare();
    }

    public static void createNew(Context context) {
        int count = nSmileCodes.length;
        if (context == null) {
            return;
        }
        if (!nSmileList.isEmpty()) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug(TAG, "nSmileList is not empty. return.", new Object[0]);
            }
            return;
        }
        for (int i = 0; i < count; ++i) {
            Bitmap bmp = BitmapFactory.decodeResource((Resources)context.getResources(), (int)nSmileResId[i]);
            SmileItem s = new SmileItem();
            s.mText = nSmileCodes[i];
            s.mIcon = bmp;
            s.mDrawable = new BitmapDrawable(context.getResources(), s.mIcon);
            int size = context.getResources().getDimensionPixelOffset(R.dimen.emotion_span_size);
            s.mDrawable.setBounds(0, 0, size, size);
            nSmileList.add(s);
            SmileCompare sc = new SmileCompare();
            sc.mItem = s;
            int length = s.mText.length();
            sc.mKeyBase = 0;
            sc.mKeyLength = length - 2;
            sc.mKey = new char[sc.mKeyLength];
            s.mText.getChars(2, length, sc.mKey, 0);
            try {
                nSmileOrderSet.add(sc);
                continue;
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, "EmoticonFilter createNew" + throwable, new Object[0]);
            }
        }
        SmileCompare.sTemp = new SmileCompare();
    }

    public static void create(Context context) {
        int count = sSmileCodes.length;
        if (context == null) {
            return;
        }
        if (!sSmileList.isEmpty()) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug(TAG, "sSmileList is not empty. return.", new Object[0]);
            }
            return;
        }
        for (int i = 0; i < count; ++i) {
            Bitmap bmp = BitmapFactory.decodeResource((Resources)context.getResources(), (int)sSmileResId[i]);
            SmileItem s = new SmileItem();
            s.mText = sSmileCodes[i];
            s.mIcon = bmp;
            s.mDrawable = new BitmapDrawable(context.getResources(), s.mIcon);
            int size = context.getResources().getDimensionPixelOffset(R.dimen.emotion_span_size);
            s.mDrawable.setBounds(0, 0, size, size);
            sSmileList.add(s);
            SmileCompare sc = new SmileCompare();
            sc.mItem = s;
            int length = s.mText.length();
            sc.mKeyBase = 0;
            sc.mKeyLength = length - 2;
            sc.mKey = new char[sc.mKeyLength];
            s.mText.getChars(2, length, sc.mKey, 0);
            sSmileOrderSet.add(sc);
        }
        SmileCompare.sTemp = new SmileCompare();
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth) {
        this.parseSpannable(context, spannable, maxWidth, null);
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth, int normal) {
        this.parseSpannableAllNew(context, spannable, maxWidth, normal, null);
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth, Object tag) {
        this.parseSpannableAllNew(context, spannable, maxWidth, 0, tag);
    }

    public static boolean isContainSmile(String text, Context context) {
        if (nSmileList.isEmpty()) {
            EmoticonFilter.createNew(context);
        }
        String str = text;
        str = str.replace("\r", "\n");
        int span = 0;
        char[] data = null;
        int len = str.length();
        while (true) {
            if ((span = str.indexOf(FLAG, span)) == -1) {
                return false;
            }
            if (data == null) {
                data = new char[str.length()];
                str.getChars(0, str.length(), data, 0);
            }
            SmileCompare.sTemp.mKey = data;
            SmileCompare.sTemp.mKeyBase = span + 2;
            SmileCompare.sTemp.mKeyLength = len - span - 2;
            if (nSmileOrderSet.contains(SmileCompare.sTemp)) break;
            span += 2;
        }
        return true;
    }

    public static boolean isContainNewSmile(String text, Context context) {
        if (allSmileList.isEmpty()) {
            EmoticonFilter.createAllNew(context);
        }
        String str = text;
        str = str.replace("\r", "\n");
        int span = 0;
        char[] data = null;
        int len = str.length();
        while (true) {
            if ((span = str.indexOf(FLAG, span)) == -1) {
                return false;
            }
            if (data == null) {
                data = new char[str.length()];
                str.getChars(0, str.length(), data, 0);
            }
            SmileCompare.sTemp.mKey = data;
            SmileCompare.sTemp.mKeyBase = span + 2;
            SmileCompare.sTemp.mKeyLength = len - span - 2;
            if (allSmileOrderSet.contains(SmileCompare.sTemp)) break;
            span += 2;
        }
        return true;
    }

    public static float measureWidth(Context context, String text, float x, float y, int width, int height, Paint paint, int smileType) {
        if (smileType == 1) {
            if (sSmileList.isEmpty()) {
                EmoticonFilter.create(context);
            }
            return EmoticonFilter.measureWidthInternal(context, text, x, y, width, height, paint, sSmileOrderSet);
        }
        if (smileType == 2) {
            if (allSmileList.isEmpty()) {
                EmoticonFilter.createAllNew(context);
            }
            return EmoticonFilter.measureWidthInternal(context, text, x, y, width, height, paint, allSmileOrderSet);
        }
        return 0.0f;
    }

    private static float measureWidthInternal(Context context, String text, float x, float y, int width, int height, Paint paint, Set<SmileCompare> smileCompares) {
        String str = text;
        str = str.replace("\r", "\n");
        int span = 0;
        char[] data = null;
        int len = str.length();
        float returnLen = 0.0f;
        while (true) {
            float l;
            String subStr;
            int lastIndex = span;
            if ((span = str.indexOf(FLAG, span)) == -1) {
                if (lastIndex < str.length()) {
                    subStr = str.substring(lastIndex);
                    returnLen += paint.measureText(subStr);
                }
                return returnLen;
            }
            if (data == null) {
                data = new char[str.length()];
                str.getChars(0, str.length(), data, 0);
            }
            SmileCompare.sTemp.mKey = data;
            SmileCompare.sTemp.mKeyBase = span + 2;
            SmileCompare.sTemp.mKeyLength = len - span - 2;
            if (!smileCompares.contains(SmileCompare.sTemp)) {
                subStr = str.substring(lastIndex, span += 2);
                l = paint.measureText(subStr);
                returnLen += l;
                continue;
            }
            if (lastIndex < span) {
                subStr = str.substring(lastIndex, span);
                l = paint.measureText(subStr);
                returnLen += l;
            }
            SmileItem s = SmileCompare.sSearch.mItem;
            int w = s.getBitmap().getWidth() * height / s.getBitmap().getHeight();
            returnLen += (float)w;
            span += s.mText.length();
        }
    }

    public static float parseToBitmap(Context context, Canvas canvas, String text, float x, float y, int width, int height, Paint paint, int smileType) {
        if (smileType == 1) {
            if (sSmileList.isEmpty()) {
                EmoticonFilter.create(context);
            }
            return EmoticonFilter.parseToBitmapInternal(context, canvas, text, x, y, width, height, paint, sSmileOrderSet);
        }
        if (smileType == 2) {
            if (allSmileList.isEmpty()) {
                EmoticonFilter.createAllNew(context);
            }
            return EmoticonFilter.parseToBitmapInternal(context, canvas, text, x, y, width, height, paint, allSmileOrderSet);
        }
        return 0.0f;
    }

    public static float parseToBitmapStroke(Context context, Canvas canvas, String text, float x, float y, int width, int height, Paint paint, int smileType) {
        if (smileType == 1) {
            if (sSmileList.isEmpty()) {
                EmoticonFilter.create(context);
            }
            return EmoticonFilter.parseToBitmapInternalStroke(context, canvas, text, x, y, width, height, paint, sSmileOrderSet);
        }
        if (smileType == 2) {
            if (allSmileList.isEmpty()) {
                EmoticonFilter.createAllNew(context);
            }
            return EmoticonFilter.parseToBitmapInternalStroke(context, canvas, text, x, y, width, height, paint, allSmileOrderSet);
        }
        return 0.0f;
    }

    private static float parseToBitmapInternalStroke(Context context, Canvas canvas, String text, float x, float y, int width, int height, Paint paint, Set<SmileCompare> smileCompares) {
        String str = text;
        str = str.replace("\r", "\n");
        int span = 0;
        char[] data = null;
        float lastOffset = x;
        int len = str.length();
        float returnLen = 0.0f;
        while (true) {
            float l;
            String subStr;
            int lastIndex = span;
            if ((span = str.indexOf(FLAG, span)) == -1) {
                if (lastIndex < str.length()) {
                    subStr = str.substring(lastIndex);
                    Paint strokePaint = new Paint(paint);
                    strokePaint.setShadowLayer(0.0f, 0.0f, 0.0f, -16777216);
                    strokePaint.setStyle(Paint.Style.FILL_AND_STROKE);
                    strokePaint.setStrokeWidth(context.getResources().getDisplayMetrics().density);
                    strokePaint.setColor(-16777216);
                    canvas.drawText(subStr, lastOffset, y, strokePaint);
                    canvas.drawText(subStr, lastOffset, y, paint);
                    returnLen += paint.measureText(subStr);
                }
                return returnLen;
            }
            if (data == null) {
                data = new char[str.length()];
                str.getChars(0, str.length(), data, 0);
            }
            SmileCompare.sTemp.mKey = data;
            SmileCompare.sTemp.mKeyBase = span + 2;
            SmileCompare.sTemp.mKeyLength = len - span - 2;
            if (!smileCompares.contains(SmileCompare.sTemp)) {
                subStr = str.substring(lastIndex, span += 2);
                Paint strokePaint = new Paint(paint);
                strokePaint.setShadowLayer(0.0f, 0.0f, 0.0f, -16777216);
                strokePaint.setStyle(Paint.Style.FILL_AND_STROKE);
                strokePaint.setStrokeWidth(context.getResources().getDisplayMetrics().density);
                strokePaint.setColor(-16777216);
                canvas.drawText(subStr, lastOffset, y, strokePaint);
                canvas.drawText(subStr, lastOffset, y, paint);
                l = paint.measureText(subStr);
                lastOffset += l;
                returnLen += l;
                continue;
            }
            if (lastIndex < span) {
                subStr = str.substring(lastIndex, span);
                Paint strokePaint = new Paint(paint);
                strokePaint.setShadowLayer(0.0f, 0.0f, 0.0f, -16777216);
                strokePaint.setStyle(Paint.Style.FILL_AND_STROKE);
                strokePaint.setStrokeWidth(context.getResources().getDisplayMetrics().density);
                strokePaint.setColor(-16777216);
                canvas.drawText(subStr, lastOffset, y, strokePaint);
                canvas.drawText(subStr, lastOffset, y, paint);
                l = paint.measureText(subStr);
                lastOffset += l;
                returnLen += l;
            }
            SmileItem s = SmileCompare.sSearch.mItem;
            int w = s.getBitmap().getWidth() * height / s.getBitmap().getHeight();
            canvas.drawBitmap(s.mIcon, null, new Rect((int)lastOffset, 0, (int)lastOffset + w, height), paint);
            lastOffset += (float)w;
            returnLen += (float)w;
            span += s.mText.length();
        }
    }

    private static float parseToBitmapInternal(Context context, Canvas canvas, String text, float x, float y, int width, int height, Paint paint, Set<SmileCompare> smileCompares) {
        String str = text;
        str = str.replace("\r", "\n");
        int span = 0;
        char[] data = null;
        float lastOffset = x;
        int len = str.length();
        float returnLen = 0.0f;
        while (true) {
            float l;
            String subStr;
            int lastIndex = span;
            if ((span = str.indexOf(FLAG, span)) == -1) {
                if (lastIndex < str.length()) {
                    subStr = str.substring(lastIndex);
                    canvas.drawText(subStr, lastOffset, y, paint);
                    returnLen += paint.measureText(subStr);
                }
                return returnLen;
            }
            if (data == null) {
                data = new char[str.length()];
                str.getChars(0, str.length(), data, 0);
            }
            SmileCompare.sTemp.mKey = data;
            SmileCompare.sTemp.mKeyBase = span + 2;
            SmileCompare.sTemp.mKeyLength = len - span - 2;
            if (!smileCompares.contains(SmileCompare.sTemp)) {
                subStr = str.substring(lastIndex, span += 2);
                canvas.drawText(subStr, lastOffset, y, paint);
                l = paint.measureText(subStr);
                lastOffset += l;
                returnLen += l;
                continue;
            }
            if (lastIndex < span) {
                subStr = str.substring(lastIndex, span);
                canvas.drawText(subStr, lastOffset, y, paint);
                l = paint.measureText(subStr);
                lastOffset += l;
                returnLen += l;
            }
            SmileItem s = SmileCompare.sSearch.mItem;
            int w = s.getBitmap().getWidth() * height / s.getBitmap().getHeight();
            canvas.drawBitmap(s.mIcon, null, new Rect((int)lastOffset, 0, (int)lastOffset + w, height), paint);
            lastOffset += (float)w;
            returnLen += (float)w;
            span += s.mText.length();
        }
    }

    private void parseSpannableAllNew(Context context, Spannable spannable, int maxWidth, int normalWidth, Object tag) {
        if (allSmileList.isEmpty()) {
            EmoticonFilter.createAllNew(context);
        }
        String str = String.valueOf(spannable);
        str = str.replace("\r", "\n");
        int span = 0;
        char[] data = null;
        int len = str.length();
        while ((span = str.indexOf(FLAG, span)) != -1) {
            Drawable drawable2;
            if (data == null) {
                data = new char[str.length()];
                str.getChars(0, str.length(), data, 0);
            }
            SmileCompare.sTemp.mKey = data;
            SmileCompare.sTemp.mKeyBase = span + 2;
            SmileCompare.sTemp.mKeyLength = len - span - 2;
            if (!allSmileOrderSet.contains(SmileCompare.sTemp)) {
                span += 2;
                continue;
            }
            SmileItem s = SmileCompare.sSearch.mItem;
            if (normalWidth != Integer.MAX_VALUE && normalWidth > 0 && s.mIcon != null) {
                drawable2 = new BitmapDrawable(s.mIcon);
                drawable2.setBounds(0, 0, normalWidth, normalWidth);
            } else {
                drawable2 = s.mDrawable;
            }
            CustomImageSpan imageSpan = new CustomImageSpan(drawable2);
            this.setSpannable((Object)imageSpan, spannable, span, span + s.mText.length(), 33);
            span += s.mText.length();
        }
        return;
    }

    private void parseSpannableNew(Context context, Spannable spannable, int maxWidth, Object tag) {
        if (nSmileList.isEmpty()) {
            EmoticonFilter.createNew(context);
        }
        String str = String.valueOf(spannable);
        str = str.replace("\r", "\n");
        int span = 0;
        char[] data = null;
        int len = str.length();
        while ((span = str.indexOf(FLAG, span)) != -1) {
            if (data == null) {
                data = new char[str.length()];
                str.getChars(0, str.length(), data, 0);
            }
            SmileCompare.sTemp.mKey = data;
            SmileCompare.sTemp.mKeyBase = span + 2;
            SmileCompare.sTemp.mKeyLength = len - span - 2;
            if (!nSmileOrderSet.contains(SmileCompare.sTemp)) {
                span += 2;
                continue;
            }
            SmileItem s = SmileCompare.sSearch.mItem;
            CustomImageSpan imageSpan = new CustomImageSpan(s.mDrawable);
            this.setSpannable((Object)imageSpan, spannable, span, span + s.mText.length(), 33);
            span += s.mText.length();
        }
        return;
    }

    private void parseSpannableOrg(Context context, Spannable spannable, int maxWidth, Object tag) {
        if (sSmileList.isEmpty()) {
            EmoticonFilter.create(context);
        }
        String str = String.valueOf(spannable);
        str = str.replace("\r", "\n");
        int span = 0;
        char[] data = null;
        int len = str.length();
        while ((span = str.indexOf(FLAG, span)) != -1) {
            Drawable drawable2;
            if (data == null) {
                data = new char[str.length()];
                str.getChars(0, str.length(), data, 0);
            }
            SmileCompare.sTemp.mKey = data;
            SmileCompare.sTemp.mKeyBase = span + 2;
            SmileCompare.sTemp.mKeyLength = len - span - 2;
            if (!sSmileOrderSet.contains(SmileCompare.sTemp)) {
                span += 2;
                continue;
            }
            SmileItem s = SmileCompare.sSearch.mItem;
            if (maxWidth != Integer.MAX_VALUE && maxWidth > 0) {
                Bitmap bitmap = s.mIcon.copy(Bitmap.Config.ARGB_8888, true);
                drawable2 = new BitmapDrawable(bitmap);
                drawable2.setBounds(0, 0, maxWidth, maxWidth);
            } else {
                drawable2 = s.mDrawable;
            }
            CustomImageSpan imageSpan = new CustomImageSpan(drawable2);
            this.setSpannable((Object)imageSpan, spannable, span, span + s.mText.length(), 33);
            span += s.mText.length();
        }
        return;
    }

    public static String subSpannableWithLen(String str, int len) {
        if (len <= 0) {
            return str;
        }
        String tmp = str = str.replace("\r", "\n");
        ArrayList<Object> list = new ArrayList<Object>();
        block0: for (String target : sSmileCodes) {
            int start = 0;
            int index = tmp.indexOf(target, start);
            while (index != -1) {
                Pair p = new Pair((Object)index, (Object)target);
                list.add(p);
                if (target.length() <= 0) continue block0;
                start = index + target.length();
                index = tmp.indexOf(target, start);
            }
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = 1; j < list.size() - i; ++j) {
                if ((Integer)((Pair)list.get((int)(j - 1))).first <= (Integer)((Pair)list.get((int)j)).first) continue;
                Pair pair = (Pair)list.get(j - 1);
                list.set(j - 1, list.get(j));
                list.set(j, pair);
            }
        }
        return null;
    }

    public static int parseSpannableLengthWithNum(String str, int num) {
        return EmoticonFilter.parseSpannableLengthWithNum(str, num, true);
    }

    public static int parseSpannableLengthWithNum(String str, int num, boolean useOld) {
        block17: {
            Context context;
            block16: {
                if (useOld) {
                    try {
                        if (!sSmileList.isEmpty()) break block16;
                        context = BasicConfig.getInstance().getAppContext();
                        if (context != null) {
                            EmoticonFilter.create(context);
                            break block16;
                        }
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug(TAG, "EmoticonFilter parseSpannableLength  BasicConfig.getInstance().getAppContext() is nulll", new Object[0]);
                        }
                        return str.length();
                    }
                    catch (Throwable e) {
                        MLog.error((Object)TAG, "EmoticonFilter parseSpannableLength" + e, new Object[0]);
                        return str.length();
                    }
                }
            }
            try {
                if (!nSmileList.isEmpty()) break block17;
                context = BasicConfig.getInstance().getAppContext();
                if (context != null) {
                    EmoticonFilter.createNew(context);
                    break block17;
                }
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(TAG, "EmoticonFilter parseSpannableLength  BasicConfig.getInstance().getAppContext() is nulll", new Object[0]);
                }
                return str.length();
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, "EmoticonFilter parseSpannableLength" + throwable, new Object[0]);
                return str.length();
            }
        }
        str = str.replace("\r", "\n");
        try {
            int i;
            String[] codes = new String[sSmileCodes.length + nSmileCodes.length];
            for (i = 0; i < nSmileCodes.length; ++i) {
                codes[i] = nSmileCodes[i];
            }
            for (i = nSmileCodes.length; i < sSmileCodes.length + nSmileCodes.length; ++i) {
                codes[i] = sSmileCodes[i - nSmileCodes.length];
            }
            if (num > 0) {
                StringBuilder replacement = new StringBuilder();
                for (int j = 0; j < num; ++j) {
                    replacement.append("A");
                }
                String strReplacement = replacement.toString();
                for (String target : codes) {
                    if (!str.contains(target)) continue;
                    str = str.replace(target, strReplacement);
                }
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, "EmoticonFilter parseSpannableLength" + throwable, new Object[0]);
            return str.length();
        }
        return str.length();
    }

    public static String briefString(String src, int targetLength) {
        StringBuffer target = new StringBuffer("");
        int length = 0;
        String[] list = src.split("");
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            if (s.getBytes().length == 1) {
                target.append(s);
                ++length;
            } else if (s.getBytes().length > 1) {
                target.append(s);
                length += 2;
            }
            if (length < targetLength * 2) continue;
            if (i == list.length - 1) {
                return target.toString();
            }
            return target.toString() + "...";
        }
        return target.toString();
    }

    public static int parseSpannableLength(String str) {
        return EmoticonFilter.parseSpannableLengthWithNum(str, 1);
    }

    public static int parseSpannableNum(String str) {
        int num = 0;
        try {
            String tmp = str = str.replace("\r", "\n");
            block2: for (String target : sSmileCodes) {
                int start = 0;
                int index = tmp.indexOf(target, start);
                while (index != -1) {
                    ++num;
                    if (target.length() <= 0) continue block2;
                    start = index + target.length();
                    index = tmp.indexOf(target, start);
                }
            }
            return num;
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, "EmoticonFilter parseSpannableNum" + throwable, new Object[0]);
            return num;
        }
    }

    public static SmileItem findSmile(String str, int offset) {
        int count = sSmileList.size();
        String t = str.substring(offset, offset + Math.min(5, str.length() - offset));
        for (int i = 0; i < count; ++i) {
            SmileItem s = sSmileList.get(i);
            if (!t.startsWith(s.mText)) continue;
            return s;
        }
        return null;
    }

    public static SmileItem findSmile(Context context, String smileCode) {
        if (sSmileList.isEmpty()) {
            sSmileList = EmoticonFilter.getSmileList(context);
        }
        int count = sSmileList.size();
        for (int i = 0; i < count; ++i) {
            SmileItem s = sSmileList.get(i);
            if (!smileCode.equals(s.mText)) continue;
            return s;
        }
        return null;
    }

    public static String replaceEmoticonWithGivenStr(String str, String givenStr) {
        str = str.replace("\r", "\n");
        for (String target : sSmileCodes) {
            str = str.replace(target, givenStr);
        }
        return str;
    }

    public static String replaceEmoticonWithLimited(String str, int num) {
        if (num <= 0) {
            return str;
        }
        String tmp = str = str.replace("\r", "\n");
        ArrayList<Object> list = new ArrayList<Object>();
        block0: for (String target : sSmileCodes) {
            int start = 0;
            int index = tmp.indexOf(target, start);
            while (index != -1) {
                Pair p = new Pair((Object)index, (Object)target);
                list.add(p);
                if (target.length() <= 0) continue block0;
                start = index + target.length();
                index = tmp.indexOf(target, start);
            }
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = 1; j < list.size() - i; ++j) {
                if ((Integer)((Pair)list.get((int)(j - 1))).first <= (Integer)((Pair)list.get((int)j)).first) continue;
                Pair pair = (Pair)list.get(j - 1);
                list.set(j - 1, list.get(j));
                list.set(j, pair);
            }
        }
        String s = "";
        if (num < list.size()) {
            for (int n = num; n < list.size(); ++n) {
                s = n > num ? s + tmp.substring((Integer)((Pair)list.get((int)(n - 1))).first + ((String)((Pair)list.get((int)(n - 1))).second).length(), (Integer)((Pair)list.get((int)n)).first) : s + tmp.substring(0, (Integer)((Pair)list.get((int)n)).first);
            }
            s = s + tmp.substring((Integer)((Pair)list.get((int)(list.size() - 1))).first + ((String)((Pair)list.get((int)(list.size() - 1))).second).length());
        }
        if (s != "" && s != null) {
            str = s;
        }
        return str;
    }

    public static String replaceEmoticonWithLimited2(String str, int num, int eachEmoAsNum) {
        String s;
        int i;
        if (num <= 0) {
            return str;
        }
        if (str.length() <= num) {
            return str;
        }
        String tmp = str = str.replace("\r", "\n");
        ArrayList<Object> list = new ArrayList<Object>();
        String[] codes = new String[sSmileCodes.length + nSmileCodes.length];
        for (i = 0; i < sSmileCodes.length; ++i) {
            codes[i] = sSmileCodes[i];
        }
        for (i = sSmileCodes.length; i < sSmileCodes.length + nSmileCodes.length; ++i) {
            codes[i] = nSmileCodes[i - sSmileCodes.length];
        }
        block2: for (String target : codes) {
            int start = 0;
            int index = tmp.indexOf(target, start);
            while (index != -1) {
                Pair p = new Pair((Object)index, (Object)target);
                list.add(p);
                if (target.length() <= 0) continue block2;
                start = index + target.length();
                index = tmp.indexOf(target, start);
            }
        }
        for (int i2 = 0; i2 < list.size() - 1; ++i2) {
            for (int j = 1; j < list.size() - i2; ++j) {
                if ((Integer)((Pair)list.get((int)(j - 1))).first <= (Integer)((Pair)list.get((int)j)).first) continue;
                Pair pair = (Pair)list.get(j - 1);
                list.set(j - 1, list.get(j));
                list.set(j, pair);
            }
        }
        HashMap<Object, Pair> emoticons = new HashMap<Object, Pair>();
        for (int i3 = 0; i3 < list.size(); ++i3) {
            Pair emoticon = (Pair)list.get(i3);
            emoticons.put(emoticon.first, emoticon);
        }
        int sumLen = 0;
        int curIndex = 0;
        for (int i4 = 0; i4 < tmp.length(); ++i4) {
            if (emoticons.containsKey(i4)) {
                if (sumLen + eachEmoAsNum > num) break;
                sumLen += eachEmoAsNum;
                curIndex = i4 = i4 + ((String)((Pair)emoticons.get((Object)Integer.valueOf((int)i4))).second).length() - 1;
                continue;
            }
            if (sumLen + 1 > num) break;
            ++sumLen;
            curIndex = i4;
        }
        if ((s = tmp.substring(0, curIndex + 1)) != null && s != "") {
            str = s;
        }
        return str;
    }

    public static class SmileCompare
    implements Comparable<SmileCompare> {
        static SmileCompare sSearch = new SmileCompare();
        static SmileCompare sTemp = new SmileCompare();
        SmileItem mItem;
        public char[] mKey;
        public int mKeyBase;
        public int mKeyLength;

        @Override
        public int compareTo(SmileCompare o) {
            int nTempLen = 0;
            SmileCompare src = this;
            SmileCompare obj = o;
            SmileCompare item = null;
            if (sTemp != null) {
                item = this == sTemp ? o : this;
            }
            int pos = 0;
            try {
                while (src.mKeyBase + pos < src.mKey.length && obj.mKeyBase + pos < obj.mKey.length) {
                    if (src.mKey[src.mKeyBase + pos] > obj.mKey[obj.mKeyBase + pos]) {
                        return 1;
                    }
                    if (src.mKey[src.mKeyBase + pos] < obj.mKey[obj.mKeyBase + pos]) {
                        return -1;
                    }
                    ++pos;
                }
            }
            catch (Exception e) {
                MLog.error((Object)EmoticonFilter.TAG, "compile exception : ", e, new Object[0]);
                return 1;
            }
            if (item != null && item.mKeyLength > SmileCompare.sTemp.mKeyLength) {
                if (item == src) {
                    return 1;
                }
                return -1;
            }
            if (sTemp != null) {
                sSearch = item;
                SmileCompare.sTemp.mKeyLength = nTempLen;
            } else {
                sSearch = null;
            }
            return 0;
        }
    }

    public static class SmileItem
    implements IEmoticonsDataInterface {
        public String mText;
        public Bitmap mIcon;
        public Drawable mDrawable;

        public CharSequence getCharSequence(Context c) {
            SpannableString sp = new SpannableString((CharSequence)this.mText);
            sp.setSpan((Object)new ImageSpan(c, this.mIcon), 0, this.mText.length(), 33);
            return sp;
        }

        @Override
        public Bitmap getBitmap() {
            return this.mIcon;
        }

        @Override
        public String getText() {
            return this.mText;
        }

        @Override
        public int getAlphaValue() {
            return 255;
        }
    }
}

