/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.imageloader.transform;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.yy.mobile.imageloader.transform.YYBitmapTransformation;
import java.security.MessageDigest;

public class GlideCircleTransform
extends YYBitmapTransformation {
    protected Bitmap transform(BitmapPool pool, Bitmap toTransform, int outWidth, int outHeight) {
        return this.circleCrop(pool, toTransform);
    }

    private Bitmap circleCrop(BitmapPool pool, Bitmap source) {
        float dstBottom;
        float dstRight;
        float dstTop;
        float dstLeft;
        float right;
        float left;
        float bottom;
        float top;
        float roundPx;
        int height;
        if (source == null) {
            return null;
        }
        int width = source.getWidth();
        if (width <= (height = source.getHeight())) {
            roundPx = width / 2;
            top = 0.0f;
            bottom = width;
            left = 0.0f;
            right = width;
            height = width;
            dstLeft = 0.0f;
            dstTop = 0.0f;
            dstRight = width;
            dstBottom = width;
        } else {
            float clip;
            roundPx = height / 2;
            left = clip = (float)((width - height) / 2);
            right = (float)width - clip;
            top = 0.0f;
            bottom = height;
            width = height;
            dstLeft = 0.0f;
            dstTop = 0.0f;
            dstRight = height;
            dstBottom = height;
        }
        Bitmap output = pool.get(width, height, Bitmap.Config.ARGB_8888);
        if (output == null) {
            output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(output);
        int color2 = -12434878;
        Paint paint = new Paint();
        Rect src = new Rect((int)left, (int)top, (int)right, (int)bottom);
        Rect dst = new Rect((int)dstLeft, (int)dstTop, (int)dstRight, (int)dstBottom);
        RectF rectF = new RectF(dst);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(source, src, dst, paint);
        return output;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
    }
}

