/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.imageloader.customcache;

import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.cache.LruResourceCache;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.util.log.MLog;

public class YYLruResourceCache
extends LruResourceCache {
    private static final String TAG = "YYLruResourceCache";
    private static boolean sDebug = ImageLoader.sDebugSwitch && BasicConfig.getInstance().isDebuggable();

    public YYLruResourceCache(int size) {
        super((long)size);
    }

    public synchronized void setSizeMultiplier(float multiplier) {
        super.setSizeMultiplier(multiplier);
    }

    protected synchronized void trimToSize(long size) {
        super.trimToSize(size);
    }

    public synchronized long getMaxSize() {
        return super.getMaxSize();
    }

    public synchronized long getCurrentSize() {
        return super.getCurrentSize();
    }

    public synchronized boolean contains(Key key) {
        return super.contains((Object)key);
    }

    public synchronized Resource<?> remove(Key key) {
        if (sDebug && key != null && MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "remove key:" + key, new Object[0]);
        }
        return (Resource)super.remove((Object)key);
    }

    public synchronized Resource<?> put(Key key, Resource<?> resource) {
        if (sDebug && key != null && resource != null && MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "put key:" + key + " resource:" + resource.toString(), new Object[0]);
        }
        return (Resource)super.put((Object)key, resource);
    }

    public synchronized Resource<?> get(Key key) {
        Resource resource = (Resource)super.get((Object)key);
        if (sDebug && key != null) {
            if (resource != null) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(TAG, "get key:" + key + " resource:" + resource.toString(), new Object[0]);
                }
            } else if (MLog.isLogLevelAboveDebug()) {
                MLog.debug(TAG, "get key:" + key + " resource null", new Object[0]);
            }
        }
        return resource;
    }

    public synchronized void trimMemory(int level) {
        MLog.info(TAG, "trimMemory, level=" + level, new Object[0]);
        if (level >= 40) {
            super.trimMemory(level);
        } else {
            super.trimToSize(this.getCurrentSize() / 2L);
        }
    }
}

