/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.imageloader;

import android.app.Activity;
import android.app.Application;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.framework.R;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.IRecycler;
import com.yy.mobile.ui.widget.BaseFragment;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import java.lang.ref.WeakReference;

public class GifHandler {
    private static final String TAG = "GifHandler";
    private static WeakReference<BaseFragment.ILifeCycleListener> sOldFragmentListener;
    private static BaseFragment.ILifeCycleListener sFragmentListener;
    private static IRecycler sRecycler;

    public static void init(Application application, IRecycler recycler) {
        sRecycler = recycler;
        if (Build.VERSION.SDK_INT < 24) {
            YYActivityManager.INSTANCE.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivityResumed(Activity activity) {
                    GifHandler.restartGif(activity);
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityStopped(Activity activity) {
                    GifHandler.stopGif(activity);
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            });
        }
        if (BaseFragment.getLifeCycleListener() != null) {
            sOldFragmentListener = new WeakReference<BaseFragment.ILifeCycleListener>(BaseFragment.getLifeCycleListener());
        }
        sFragmentListener = new BaseFragment.ILifeCycleListener(){

            @Override
            public void onResumed(BaseFragment fragment) {
                if (BasicConfig.getInstance().isDebuggable() && MLog.isLogLevelAboveDebug()) {
                    MLog.debug(GifHandler.TAG, "BaseFragment onResumed:" + fragment.toString(), new Object[0]);
                }
                GifHandler.restartGif(fragment);
                BaseFragment.ILifeCycleListener fragmentCycleListener = GifHandler.getOldFragmentListener();
                if (fragmentCycleListener != null && fragmentCycleListener != this) {
                    fragmentCycleListener.onResumed(fragment);
                }
            }

            @Override
            public void onPaused(BaseFragment fragment) {
                if (BasicConfig.getInstance().isDebuggable() && MLog.isLogLevelAboveDebug()) {
                    MLog.debug(GifHandler.TAG, "BaseFragment onpause:" + fragment.toString(), new Object[0]);
                }
                GifHandler.stopGif(fragment);
                BaseFragment.ILifeCycleListener fragmentCycleListener = GifHandler.getOldFragmentListener();
                if (fragmentCycleListener != null && fragmentCycleListener != this) {
                    fragmentCycleListener.onPaused(fragment);
                }
            }

            @Override
            public void onStoped(BaseFragment fragment) {
                BaseFragment.ILifeCycleListener fragmentCycleListener = GifHandler.getOldFragmentListener();
                if (fragmentCycleListener != null && fragmentCycleListener != this) {
                    fragmentCycleListener.onStoped(fragment);
                }
            }

            @Override
            public void onDestroyed(BaseFragment fragment) {
                BaseFragment.ILifeCycleListener fragmentCycleListener = GifHandler.getOldFragmentListener();
                if (fragmentCycleListener != null && fragmentCycleListener != this) {
                    fragmentCycleListener.onDestroyed(fragment);
                }
            }

            @Override
            public void onAttached(BaseFragment fragment) {
                BaseFragment.ILifeCycleListener fragmentCycleListener = GifHandler.getOldFragmentListener();
                if (fragmentCycleListener != null && fragmentCycleListener != this) {
                    fragmentCycleListener.onAttached(fragment);
                }
            }

            @Override
            public void onDetached(BaseFragment fragment) {
                BaseFragment.ILifeCycleListener fragmentCycleListener = GifHandler.getOldFragmentListener();
                if (fragmentCycleListener != null && fragmentCycleListener != this) {
                    fragmentCycleListener.onDetached(fragment);
                }
            }

            @Override
            public void onHiddenChanged(BaseFragment fragment, boolean hidden) {
                if (hidden) {
                    if (BasicConfig.getInstance().isDebuggable() && MLog.isLogLevelAboveDebug()) {
                        MLog.debug(GifHandler.TAG, "BaseFragment hidden:" + fragment.toString(), new Object[0]);
                    }
                    GifHandler.stopGif(fragment);
                } else {
                    if (BasicConfig.getInstance().isDebuggable() && MLog.isLogLevelAboveDebug()) {
                        MLog.debug(GifHandler.TAG, "BaseFragment shown:" + fragment.toString(), new Object[0]);
                    }
                    GifHandler.restartGif(fragment);
                }
                BaseFragment.ILifeCycleListener fragmentCycleListener = GifHandler.getOldFragmentListener();
                if (fragmentCycleListener != null && fragmentCycleListener != this) {
                    fragmentCycleListener.onHiddenChanged(fragment, hidden);
                }
            }

            @Override
            public void onSelectChanged(BaseFragment fragment, boolean selected) {
                if (selected) {
                    if (BasicConfig.getInstance().isDebuggable() && MLog.isLogLevelAboveDebug()) {
                        MLog.debug(GifHandler.TAG, "BaseFragment selected:" + fragment.toString(), new Object[0]);
                    }
                    GifHandler.restartGif(fragment);
                } else {
                    if (BasicConfig.getInstance().isDebuggable() && MLog.isLogLevelAboveDebug()) {
                        MLog.debug(GifHandler.TAG, "BaseFragment unselected:" + fragment.toString(), new Object[0]);
                    }
                    GifHandler.stopGif(fragment);
                }
                BaseFragment.ILifeCycleListener fragmentCycleListener = GifHandler.getOldFragmentListener();
                if (fragmentCycleListener != null && fragmentCycleListener != this) {
                    fragmentCycleListener.onSelectChanged(fragment, selected);
                }
            }
        };
        BaseFragment.setLifeCycleListener(sFragmentListener);
    }

    private static BaseFragment.ILifeCycleListener getOldFragmentListener() {
        if (sOldFragmentListener != null) {
            return (BaseFragment.ILifeCycleListener)sOldFragmentListener.get();
        }
        return null;
    }

    private static void stopGif(Activity activity) {
    }

    private static void restartGif(Activity activity) {
    }

    private static void stopGif(BaseFragment fragment) {
        if (fragment == null) {
            return;
        }
        View view = fragment.getView();
        if (view instanceof ViewGroup) {
            view.setTag(R.id.yy_gif_auto_pause_id, (Object)true);
        }
    }

    private static void restartGif(BaseFragment fragment) {
        View view;
        if (fragment == null || fragment.isHiddened() || !fragment.isSelected() || fragment.isPaused()) {
            if (BasicConfig.getInstance().isDebuggable() && MLog.isLogLevelAboveDebug()) {
                MLog.debug(TAG, "restart gif return:" + fragment.toString(), new Object[0]);
            }
            return;
        }
        if (BasicConfig.getInstance().isDebuggable() && MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "restart fragment gif:" + fragment.toString(), new Object[0]);
        }
        if ((view = fragment.getView()) instanceof ViewGroup) {
            GifHandler.restartGif((ViewGroup)view);
        }
    }

    private static boolean restartGif(ImageView child) {
        if (child == null) {
            return false;
        }
        if (child instanceof RecycleImageView) {
            Drawable drawable2;
            boolean needCheckGifRestart;
            boolean bl = needCheckGifRestart = child.getTag(R.id.yy_gif_set_visible) instanceof Boolean ? (Boolean)child.getTag(R.id.yy_gif_set_visible) : false;
            if (needCheckGifRestart && !GifHandler.needPauseGif((RecycleImageView)child) && (drawable2 = ((RecycleImageView)child).getImageDrawableInner()) instanceof GifDrawable) {
                child.setTag(R.id.yy_gif_set_visible, (Object)false);
                drawable2.setVisible(true, true);
                return true;
            }
        }
        return false;
    }

    public static void restartGif(ViewGroup viewGroup) {
        if (viewGroup == null) {
            return;
        }
        viewGroup.setTag(R.id.yy_gif_auto_pause_id, (Object)false);
        int childSize = viewGroup.getChildCount();
        View child = null;
        for (int i = 0; i < childSize; ++i) {
            child = viewGroup.getChildAt(i);
            if (child == null) continue;
            if (child instanceof ViewGroup) {
                GifHandler.restartGif((ViewGroup)child);
                continue;
            }
            if (!(child instanceof ImageView)) continue;
            GifHandler.restartGif((ImageView)child);
        }
    }

    public static void onImageDrawableUpdated(RecycleImageView imageView, Drawable drawable2) {
    }

    public static void onDraw(RecycleImageView recycleImageView, Drawable drawable2) {
        if (recycleImageView == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 24 && drawable2 instanceof GifDrawable) {
            boolean needCheckGifRestart;
            boolean bl = needCheckGifRestart = recycleImageView.getTag(R.id.yy_gif_set_visible) instanceof Boolean ? (Boolean)recycleImageView.getTag(R.id.yy_gif_set_visible) : false;
            if (needCheckGifRestart) {
                if (!drawable2.isVisible()) {
                    if (!GifHandler.needPauseGif(recycleImageView)) {
                        recycleImageView.setTag(R.id.yy_gif_set_visible, false);
                        drawable2.setVisible(true, true);
                    }
                } else {
                    recycleImageView.setTag(R.id.yy_gif_set_visible, false);
                }
            }
        }
    }

    public static void invalidateDrawable(RecycleImageView recycleImageView, Drawable dr) {
        if (recycleImageView == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 24 && dr instanceof GifDrawable) {
            if (dr.isVisible()) {
                if (GifHandler.needPauseGif(recycleImageView)) {
                    dr.setVisible(false, false);
                    recycleImageView.setTag(R.id.yy_gif_set_visible, true);
                } else {
                    recycleImageView.setTag(R.id.yy_gif_set_visible, false);
                }
            } else {
                boolean needCheckGifRestart;
                boolean bl = needCheckGifRestart = recycleImageView.getTag(R.id.yy_gif_set_visible) instanceof Boolean ? (Boolean)recycleImageView.getTag(R.id.yy_gif_set_visible) : false;
                if (needCheckGifRestart && !GifHandler.needPauseGif(recycleImageView)) {
                    recycleImageView.setTag(R.id.yy_gif_set_visible, false);
                    dr.setVisible(true, true);
                }
            }
        }
    }

    public static void onVisibilityChanged(RecycleImageView view, int visibility) {
        if (visibility != 0) {
            view.setTag(R.id.yy_gif_set_visible, false);
        }
    }

    private static boolean needPauseGif(RecycleImageView recycleImageView) {
        if (recycleImageView == null) {
            return false;
        }
        boolean need = false;
        ViewParent parent = recycleImageView.getParent();
        if (parent == null) {
            need = true;
        } else {
            while (parent instanceof ViewGroup) {
                if (((ViewGroup)parent).getTag(R.id.yy_gif_auto_pause_id) instanceof Boolean && ((Boolean)((ViewGroup)parent).getTag(R.id.yy_gif_auto_pause_id)).booleanValue()) {
                    need = true;
                    break;
                }
                if ((parent = parent.getParent()) != null) continue;
                need = true;
                break;
            }
        }
        return need;
    }
}

