/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.image;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.yy.mobile.framework.R;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.util.log.MLog;

public class PressedRecycleImageView
extends RecycleImageView {
    private static final String TAG = "PressedRecycleImageView";
    public Drawable mPressed;

    public PressedRecycleImageView(Context context) {
        super(context);
        this.init();
    }

    public PressedRecycleImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PressedRecycleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.mPressed = this.getContext().getResources().getDrawable(R.drawable.pressedpecycle_pressed_selector);
        this.mPressed.setCallback((Drawable.Callback)this);
        if (this.mPressed.isStateful()) {
            this.mPressed.setState(this.getDrawableState());
        }
    }

    public void setPressRound() {
        this.mPressed = this.getContext().getResources().getDrawable(R.drawable.pressed_recycle_round_corner_pressed_selector);
        this.mPressed.setCallback((Drawable.Callback)this);
        if (this.mPressed.isStateful()) {
            this.mPressed.setState(this.getDrawableState());
        }
    }

    public void draw(Canvas canvas) {
        try {
            super.draw(canvas);
            this.mPressed.draw(canvas);
        }
        catch (Throwable throwable) {
            MLog.error(TAG, throwable);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mPressed.setBounds(0, 0, w, h);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mPressed != null && this.mPressed.isStateful()) {
            this.mPressed.setState(this.getDrawableState());
        }
        this.invalidate();
    }

    @Override
    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.mPressed != null) {
            this.mPressed.setVisible(visibility == 0, false);
        }
    }

    @Override
    public boolean closeAutoRecycleDrawables() {
        return true;
    }
}

