/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http.dns;

import android.content.Context;
import com.yy.gslbsdk.DnsResultInfo;
import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.HttpDnsService;
import com.yy.gslbsdk.thread.ThreadPoolMgr;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.smartdns.GSLBDnsExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GslbDns {
    private static final String Tag = "GslbDns";
    private final String accountID = "ed37610f-36c7-45db-8e2f-e615cd1e99d6";
    private HttpDnsService mHttpDnsService = null;
    private static GslbDns mInstance = null;

    private GslbDns() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GslbDns inst() {
        if (mInstance != null) return mInstance;
        Class<GslbDns> clazz = GslbDns.class;
        synchronized (GslbDns.class) {
            if (mInstance != null) return mInstance;
            mInstance = new GslbDns();
            mInstance.initHttpDns();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public List<String> getIps(String hostname) {
        DnsResultInfo info = this.mHttpDnsService.getIpsByHost(hostname);
        if (info != null && info.mIps != null && info.mIps.length > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < info.mIps.length; ++i) {
                list.add(info.mIps[i]);
            }
            MLog.info(Tag, "hostname:" + hostname + " mDataSource:" + info.mDataSource + " mErrorCode:" + info.mErrorCode + " res.IPList:" + Arrays.asList(info.mIps), new Object[0]);
            return list;
        }
        MLog.info(Tag, "getIpsByHost error.hostname:" + hostname + " mErrorCode:" + info.mErrorCode, new Object[0]);
        return null;
    }

    private void initHttpDns() {
        this.mHttpDnsService = HttpDnsService.getService((Context)BasicConfig.getInstance().getAppContext(), (String)"ed37610f-36c7-45db-8e2f-e615cd1e99d6", (ThreadPoolMgr.ITaskExecutor)new GSLBDnsExecutor(), (String)"");
        this.mHttpDnsService.setLogEnabled(true);
        this.mHttpDnsService.setGslbEventMessager(new GslbEvent.GslbEventListener(){

            public void onMessage(String s) {
                MLog.info(GslbDns.Tag, "HttpDnsService " + s, new Object[0]);
            }
        });
    }
}

