/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.yy.mobile.http.BaseNetwork;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.ServerError;
import com.yy.mobile.util.YYFileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import okhttp3.Response;

public class DownloadNetwork
extends BaseNetwork {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String TMP_SURFIX = ".tmp";
    protected String mDownloadFilePath;
    protected String mDownloadFileTempPath;

    public DownloadNetwork(String downloadFilePath) {
        if (HttpLog.isDebug()) {
            HttpLog.d("Download file path " + downloadFilePath, new Object[0]);
        }
        this.mDownloadFilePath = downloadFilePath;
        this.mDownloadFileTempPath = DownloadNetwork.createTempPath(this.mDownloadFilePath);
    }

    protected static String createTempPath(String orginalPath) {
        String fileName = TMP_SURFIX;
        fileName = orginalPath.concat(fileName);
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] entityToBytes(Request<?> request, Response response) throws IOException, ServerError {
        block20: {
            statusCode = response.code();
            if (statusCode < 200) return super.entityToBytes(request, response);
            if (statusCode > 299) {
                return super.entityToBytes(request, response);
            }
            HttpLog.v("Download file tmp path " + this.mDownloadFileTempPath, new Object[0]);
            file = new File(this.mDownloadFileTempPath);
            if (!file.exists()) {
                try {
                    tmpFile = YYFileUtils.createFile(file.getPath()).getFile();
                    if (tmpFile != null) {
                        file = tmpFile;
                    }
                }
                catch (Exception e) {
                    HttpLog.e("Create download config error:" + this.mDownloadFileTempPath, new Object[0]);
                }
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            buffer = new byte[4096];
            in = response.body().byteStream();
            try {
                if (in == null) {
                    throw new ServerError();
                }
                total = response.body().contentLength();
                HttpLog.v("Download content length %d", new Object[]{total});
                progress = 0L;
lbl24:
                // 3 sources

                while ((count = in.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, count);
                    progress += (long)count;
                    if (request.isCanceled()) {
                        HttpLog.e("Download cancel.", new Object[0]);
                        this.onCancel(progress);
                        var13_12 = new byte[]{};
                        break block20;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl60
            }
            catch (Throwable var16_17) {
                try {
                    in.close();
                    response.body().close();
                    if (outputStream != null) {
                        outputStream.flush();
                    }
                    outputStream.close();
                    throw var16_17;
                }
                catch (IOException e) {
                    HttpLog.e("entity to bytes consumingContent error", new Object[]{e});
                }
                throw var16_17;
            }
        }
        try {
            in.close();
            response.body().close();
            if (outputStream != null) {
                outputStream.flush();
            }
            outputStream.close();
            return var13_12;
        }
        catch (IOException e) {
            HttpLog.e("entity to bytes consumingContent error", new Object[]{e});
        }
        return var13_12;
lbl-1000:
        // 1 sources

        {
            if (!this.needProgress(count, total, request, progress)) ** GOTO lbl24
            progressInfo = new ProgressInfo(progress, total);
            request.postProgress(progressInfo);
            ** GOTO lbl24
lbl60:
            // 1 sources

            response.body().close();
            renameFileReulst = file.renameTo(new File(this.mDownloadFilePath));
            HttpLog.v("File file.length() %d", new Object[]{file.length()});
            HttpLog.v("File rename completed, result %d", new Object[]{renameFileReulst != false ? 1 : 0});
            var14_15 = this.mDownloadFilePath.getBytes();
        }
        try {
            in.close();
            response.body().close();
            if (outputStream != null) {
                outputStream.flush();
            }
            outputStream.close();
            return var14_15;
        }
        catch (IOException e) {
            HttpLog.e("entity to bytes consumingContent error", new Object[]{e});
        }
        return var14_15;
    }

    protected void onCancel(long progress) throws IOException {
        if (HttpLog.isDebug()) {
            HttpLog.d("OnCancel", new Object[0]);
        }
        this.abort();
    }
}

