/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.SystemClock;
import android.text.TextUtils;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.ByteArrayPool;
import com.yy.mobile.http.Cache;
import com.yy.mobile.http.HttpLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiskCache
implements Cache {
    public static final int VERSION = 20140408;
    public static final int DEFAULT_MAX_CACHE_SIZE = 0xA00000;
    public static final float DEFAULT_MAX_FACTOR = 0.2f;
    public static final int DEFAULT_POOL_SIZE = 5120;
    private File mRootDir;
    private long mMaxCacheSizeInBytes = 0xA00000L;
    private float mFactor = 0.2f;
    private static final ByteArrayPool BYTE_POOL = new ByteArrayPool(5120);

    public DiskCache(File rootDir) {
        this(rootDir, 0xA00000L, 0.2f);
    }

    public DiskCache(File rootDir, long maxCacheSizeInBytes, float maxFactor) {
        if (rootDir == null) {
            throw new IllegalArgumentException("Root dir is not allow null.");
        }
        this.mRootDir = rootDir;
        this.mMaxCacheSizeInBytes = maxCacheSizeInBytes;
        this.mFactor = maxFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Cache.Entry get(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        File file = this.getFileForKey(key);
        FilterInputStream cis = null;
        try {
            if (file == null || !file.exists()) {
                HttpLog.v("Can't find file or not exists key=%s, file=%s", key, file);
                Cache.Entry entry = null;
                return entry;
            }
            cis = new CountingInputStream(new BufferedInputStream(new FileInputStream(file)));
            CacheHeader header = CacheHeader.readHeader(cis);
            byte[] data = DiskCache.streamToBytes(cis, (int)(file.length() - (long)((CountingInputStream)cis).bytesRead));
            Cache.Entry entry = header.toCacheEntry(data);
            HttpLog.v("Get action success key=%s entry=%s", key, entry);
            Cache.Entry entry2 = entry;
            return entry2;
        }
        catch (Exception e) {
            HttpLog.e(e, "Get cache error filePath = " + file.getAbsolutePath(), new Object[0]);
            this.remove(key);
            Cache.Entry entry = null;
            return entry;
        }
        finally {
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (IOException ioe) {
                    return null;
                }
            }
        }
    }

    @Override
    public synchronized void put(String key, Cache.Entry entry) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        File file = this.getFileForKey(key);
        try {
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
            CacheHeader e = new CacheHeader(key, entry);
            e.writeHeader(fos);
            ((OutputStream)fos).write(entry.data);
            ((OutputStream)fos).close();
            HttpLog.v("Put action success key=%s entry=%s file=%s", key, entry, file);
            return;
        }
        catch (IOException e) {
            HttpLog.e(e, "Put error key=%s entry=%s", key, entry);
            boolean deleted = file.delete();
            if (!deleted && HttpLog.isDebug()) {
                HttpLog.d("Could not clean up file %s", file.getAbsolutePath());
            }
            return;
        }
    }

    @Override
    public synchronized void initialize() {
        try {
            if (!this.mRootDir.exists() && !this.mRootDir.mkdirs()) {
                HttpLog.e("Can't create root dir : %s", this.mRootDir.getAbsolutePath());
                return;
            }
        }
        catch (Exception e) {
            HttpLog.e(e, "Initialize error", new Object[0]);
        }
    }

    @Override
    public synchronized void invalidate(String key, boolean fullExpire) {
        Cache.Entry entry = this.get(key);
        if (entry != null) {
            entry.softTtl = 0L;
            if (fullExpire) {
                entry.ttl = 0L;
            }
            this.put(key, entry);
        }
    }

    @Override
    public synchronized void remove(String key) {
        boolean deleted = this.getFileForKey(key).delete();
        if (!deleted && HttpLog.isDebug()) {
            HttpLog.d("Could not delete cache entry for key=%s, filename=%s", key, this.getFilenameForKey(key));
        }
    }

    @Override
    public synchronized void clear() {
        File[] files = this.mRootDir.listFiles();
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
        if (HttpLog.isDebug()) {
            HttpLog.d("Cache cleared count = %d", files == null ? 0 : files.length);
        }
    }

    @Override
    public synchronized void shrink() {
        File[] files = this.mRootDir.listFiles();
        if (files == null) {
            return;
        }
        long totalSize = 0L;
        for (File file : files) {
            totalSize += file.length();
        }
        if (HttpLog.isDebug()) {
            HttpLog.d("Total size %d", totalSize);
        }
        if (totalSize < this.mMaxCacheSizeInBytes) {
            return;
        }
        if (HttpLog.isDebug()) {
            HttpLog.d("Pruning old cache entries.", new Object[0]);
        }
        int prunedFiles = 0;
        long startTime = SystemClock.elapsedRealtime();
        Comparator<File> comparator = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                long diff = o1.lastModified() - o2.lastModified();
                if (diff > 0L) {
                    return 1;
                }
                if (diff < 0L) {
                    return -1;
                }
                return 0;
            }
        };
        List<File> sortFiles = Arrays.asList(files);
        try {
            Collections.sort(sortFiles, comparator);
        }
        catch (Exception e) {
            HttpLog.e("Collections.sort error,i think that other thread modifies the files", new Object[0]);
        }
        for (File file : sortFiles) {
            long size = file.length();
            boolean deleted = file.delete();
            if (deleted) {
                totalSize -= size;
            } else if (HttpLog.isDebug()) {
                HttpLog.d("Could not delete cache entry for filename=%s", file.getAbsolutePath());
            }
            ++prunedFiles;
            if (!((float)totalSize < (float)this.mMaxCacheSizeInBytes * this.mFactor)) continue;
            break;
        }
        HttpLog.v("Shrink %d files, %d bytes remain, %d ms", prunedFiles, totalSize, SystemClock.elapsedRealtime() - startTime);
    }

    public static File getCacheDir(Context context, String uniqueName) {
        return DiskCache.getCacheDir(context, false, uniqueName);
    }

    public static File getCacheDir(Context context, boolean internal, String uniqueName) {
        String cachePath = internal ? context.getCacheDir().getPath() : ("mounted".equals(Environment.getExternalStorageState()) && DiskCache.hasExternalStoragePermission(context) && (BasicConfig.getInstance().isExternalStorageAvailable() || !DiskCache.isExternalStorageRemovable()) ? DiskCache.getExternalCacheDir(context).getPath() : context.getCacheDir().getPath());
        return new File(cachePath + File.separator + uniqueName);
    }

    private static boolean isExternalStorageRemovable() {
        if (Build.VERSION.SDK_INT >= 9) {
            return Environment.isExternalStorageRemovable();
        }
        return true;
    }

    private static boolean hasExternalStoragePermission(Context context) {
        int perm = context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE");
        return perm == 0;
    }

    private static File getExternalCacheDir(Context context) {
        return new File(Environment.getExternalStorageDirectory().getPath());
    }

    public File getFileForKey(String key) {
        return new File(this.mRootDir, this.getFilenameForKey(key));
    }

    private String getFilenameForKey(String key) {
        int firstHalfLength = key.length() / 2;
        String localFilename = String.valueOf(key.substring(0, firstHalfLength).hashCode());
        localFilename = localFilename + String.valueOf(key.substring(firstHalfLength).hashCode());
        return localFilename;
    }

    private static byte[] streamToBytes(InputStream in, int length) throws IOException {
        int pos;
        int count;
        byte[] bytes = BYTE_POOL.getBuf(length);
        for (pos = 0; pos < length && (count = in.read(bytes, pos, length - pos)) != -1; pos += count) {
        }
        if (pos != length) {
            throw new IOException("Expected " + length + " bytes, read " + pos + " bytes");
        }
        return bytes;
    }

    private static int read(InputStream is) throws IOException {
        int b = is.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }

    static void writeInt(OutputStream os, int n) throws IOException {
        os.write(n >> 0 & 0xFF);
        os.write(n >> 8 & 0xFF);
        os.write(n >> 16 & 0xFF);
        os.write(n >> 24 & 0xFF);
    }

    static int readInt(InputStream is) throws IOException {
        int n = 0;
        n |= DiskCache.read(is) << 0;
        n |= DiskCache.read(is) << 8;
        n |= DiskCache.read(is) << 16;
        return n |= DiskCache.read(is) << 24;
    }

    static void writeLong(OutputStream os, long n) throws IOException {
        os.write((byte)(n >>> 0));
        os.write((byte)(n >>> 8));
        os.write((byte)(n >>> 16));
        os.write((byte)(n >>> 24));
        os.write((byte)(n >>> 32));
        os.write((byte)(n >>> 40));
        os.write((byte)(n >>> 48));
        os.write((byte)(n >>> 56));
    }

    static long readLong(InputStream is) throws IOException {
        long n = 0L;
        n |= ((long)DiskCache.read(is) & 0xFFL) << 0;
        n |= ((long)DiskCache.read(is) & 0xFFL) << 8;
        n |= ((long)DiskCache.read(is) & 0xFFL) << 16;
        n |= ((long)DiskCache.read(is) & 0xFFL) << 24;
        n |= ((long)DiskCache.read(is) & 0xFFL) << 32;
        n |= ((long)DiskCache.read(is) & 0xFFL) << 40;
        n |= ((long)DiskCache.read(is) & 0xFFL) << 48;
        return n |= ((long)DiskCache.read(is) & 0xFFL) << 56;
    }

    static void writeString(OutputStream os, String s) throws IOException {
        byte[] b = s.getBytes("UTF-8");
        DiskCache.writeLong(os, b.length);
        os.write(b, 0, b.length);
    }

    static String readString(InputStream is) throws IOException {
        int n = (int)DiskCache.readLong(is);
        byte[] b = DiskCache.streamToBytes(is, n);
        return new String(b, "UTF-8");
    }

    static void writeStringStringMap(Map<String, String> map, OutputStream os) throws IOException {
        if (map != null) {
            DiskCache.writeInt(os, map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                DiskCache.writeString(os, entry.getKey());
                DiskCache.writeString(os, entry.getValue());
            }
        } else {
            DiskCache.writeInt(os, 0);
        }
    }

    static Map<String, String> readStringStringMap(InputStream is) throws IOException {
        int size = DiskCache.readInt(is);
        HashMap<String, String> result = size == 0 ? Collections.emptyMap() : new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            String key = DiskCache.readString(is).intern();
            String value = DiskCache.readString(is).intern();
            result.put(key, value);
        }
        return result;
    }

    private static class CountingInputStream
    extends FilterInputStream {
        private int bytesRead = 0;

        private CountingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int result = super.read();
            if (result != -1) {
                ++this.bytesRead;
            }
            return result;
        }

        @Override
        public int read(byte[] buffer, int offset, int count) throws IOException {
            int result = super.read(buffer, offset, count);
            if (result != -1) {
                this.bytesRead += result;
            }
            return result;
        }
    }

    static class CacheHeader {
        public long size;
        public String key;
        public String etag;
        public long serverDate;
        public long ttl;
        public long softTtl;
        public Map<String, String> responseHeaders;

        private CacheHeader() {
        }

        public CacheHeader(String key, Cache.Entry entry) {
            this.key = key;
            this.size = entry.data.length;
            this.etag = entry.etag;
            this.serverDate = entry.serverDate;
            this.ttl = entry.ttl;
            this.softTtl = entry.softTtl;
            this.responseHeaders = entry.responseHeaders;
        }

        public static CacheHeader readHeader(InputStream is) throws IOException {
            CacheHeader entry = new CacheHeader();
            int magic = DiskCache.readInt(is);
            if (magic != 20140408) {
                throw new IOException();
            }
            entry.key = DiskCache.readString(is);
            entry.etag = DiskCache.readString(is);
            if (entry.etag.equals("")) {
                entry.etag = null;
            }
            entry.serverDate = DiskCache.readLong(is);
            entry.ttl = DiskCache.readLong(is);
            entry.softTtl = DiskCache.readLong(is);
            entry.responseHeaders = DiskCache.readStringStringMap(is);
            return entry;
        }

        public Cache.Entry toCacheEntry(byte[] data) {
            Cache.Entry e = new Cache.Entry();
            e.data = data;
            e.etag = this.etag;
            e.serverDate = this.serverDate;
            e.ttl = this.ttl;
            e.softTtl = this.softTtl;
            e.responseHeaders = this.responseHeaders;
            return e;
        }

        public boolean writeHeader(OutputStream os) {
            try {
                DiskCache.writeInt(os, 20140408);
                DiskCache.writeString(os, this.key);
                DiskCache.writeString(os, this.etag == null ? "" : this.etag);
                DiskCache.writeLong(os, this.serverDate);
                DiskCache.writeLong(os, this.ttl);
                DiskCache.writeLong(os, this.softTtl);
                DiskCache.writeStringStringMap(this.responseHeaders, os);
                os.flush();
                return true;
            }
            catch (IOException e) {
                HttpLog.e("%s", e.toString());
                return false;
            }
        }
    }
}

