/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.file.data;

import android.content.Context;
import com.yy.mobile.file.DefaultFileResponseData;
import com.yy.mobile.file.FileRequestException;
import com.yy.mobile.file.FileResponse;
import com.yy.mobile.file.FileResponseData;
import com.yy.mobile.file.data.BaseFileDataRequest;
import com.yy.mobile.file.data.FileDataParam;
import com.yy.mobile.file.data.FilePutResult;
import com.yy.mobile.util.log.MLog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FilePutRequest
extends BaseFileDataRequest<FilePutResult> {
    private static final String TAG = "FilePutRequest";
    protected File mDataFile;
    protected byte[] mData;

    public FilePutRequest(Context context, FileDataParam config, byte[] data) {
        this.mDataConfig = config;
        this.mData = data;
    }

    @Override
    public String getKey() {
        return this.mDataConfig.getDataKey();
    }

    @Override
    public void parseDataToResponse(FileResponseData responseData) {
        FilePutResult result = new FilePutResult();
        result.setDataDir(this.mDataConfig.getDataDir());
        result.setDataKey(this.mDataConfig.getDataKey());
        result.setSavedPath(this.mDataFile);
        this.mResponse = FileResponse.success(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileResponseData performRequest() throws FileRequestException {
        OutputStream fos = null;
        try {
            this.mDataFile = this.getDataFile(this.mDataConfig.getDataKey());
            if (!this.mDataFile.exists() && !this.mDataFile.createNewFile()) {
                MLog.error((Object)"FileRequest", "Create data file fail: %s", this.mDataFile.getAbsolutePath());
            }
            fos = new BufferedOutputStream(new FileOutputStream(this.mDataFile));
            fos.write(this.mData);
            DefaultFileResponseData defaultFileResponseData = new DefaultFileResponseData(this.getKey().getBytes());
            return defaultFileResponseData;
        }
        catch (Exception e) {
            MLog.error((Object)"FileRequest", "Put data file error path = " + this.mDataFile.getAbsolutePath(), e, new Object[0]);
            FileResponseData fileResponseData = null;
            return fileResponseData;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    return null;
                }
            }
        }
    }

    @Override
    public String toString() {
        return "FilePutRequest{mDataFile=" + this.mDataFile + '}';
    }
}

