/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.file;

import android.os.Process;
import com.yy.mobile.file.FileProcessor;
import com.yy.mobile.file.FileRequest;
import com.yy.mobile.file.FileRequestException;
import com.yy.mobile.file.FileResponseData;
import com.yy.mobile.util.log.MLog;
import java.util.concurrent.BlockingQueue;

public class FileDispatcher
extends Thread {
    private final BlockingQueue<FileRequest> mRequestQueue;
    private volatile boolean mQuit = false;
    private FileProcessor mRequestProcessor;

    public FileDispatcher(BlockingQueue<FileRequest> requestQueue, String name, FileProcessor requestProcessor) {
        super(name + "FileDispatcher");
        this.mRequestQueue = requestQueue;
        this.mRequestProcessor = requestProcessor;
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (true) {
            FileRequest request;
            try {
                while ((request = this.mRequestQueue.take()) == null) {
                }
            }
            catch (InterruptedException e) {
                if (!this.mQuit) continue;
                return;
            }
            try {
                if (request.isCanceled()) {
                    request.finish("FileRequest discard cancelled");
                    continue;
                }
                FileResponseData responseData = request.performRequest();
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose("FileRequest", "FileRequest %s perform complete", request);
                }
                request.parseDataToResponse(responseData);
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose("FileRequest", "FileRequest parse complete", new Object[0]);
                }
                request.markDelivered();
                request.postResponse();
                continue;
            }
            catch (FileRequestException error) {
                this.parseAndDeliverNetworkError(request, error);
                continue;
            }
            catch (Exception e) {
                MLog.error((Object)"FileRequest", "Unhandled exception " + e.toString(), e, new Object[0]);
                request.postError(new FileRequestException(e));
                continue;
            }
            catch (Error e) {
                MLog.error((Object)"FileRequest", "Unhandled error " + e.toString(), e, new Object[0]);
                request.postError(new FileRequestException(e));
                continue;
            }
            break;
        }
    }

    private void parseAndDeliverNetworkError(FileRequest request, FileRequestException error) {
        request.postError(error);
    }
}

