/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.crash;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import java.util.HashMap;
import java.util.Map;

public class UncatchCrashReporter {
    private static final String TAG = "UncatchCrashReporter";
    private static final String STAT_UNCATCH_KEY = "skey";
    private static final String STAT_JAVA_EXCEPTION_KEY = "vlen";
    private static final String STAT_NATIVE_EXCEPTION_KEY = "mem";
    private static final String STAT_UNCATCH_NUM_KEY = "mema";
    private static final String UNCATCH_CRASH_FLAG = "uncatch_crash_flag";
    private static final String JAVA_CATCH_CRASH_FLAG = "java_catch_crash_flag";
    private static final String NATIVE_CATCH_CRASH_FLAG = "native_catch_crash_flag";
    public static final int MSG_ON_APP_CREATE = 1;
    public static final int MSG_ON_JAVA_EXCEPTION = 2;
    public static final int MSG_ON_NATIVE_EXCEPTION = 3;
    public static final int MSG_ON_EXIT_BY_USER = 4;
    private static final int MSG_ON_SHUT_DOWN = 5;
    public static final int MSG_REPORT = 6;
    private static boolean sHasStatExit = true;
    private static Activity sCurrentStartedActivity = null;
    private static boolean sFirstActivityComed = false;
    private static ShutdownBroadcastReceiver sShutdownBroadcastReceiver;

    public static Object handleMessage(int msgId, Object objectData) {
        if (msgId == 1) {
            if (!(objectData instanceof Application)) {
                return null;
            }
            sHasStatExit = false;
            sCurrentStartedActivity = null;
            sFirstActivityComed = false;
            UncatchCrashReporter.increaseNum();
            YYActivityManager.INSTANCE.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                public void onActivityStarted(Activity activity) {
                    if (sFirstActivityComed && sCurrentStartedActivity == null && !sHasStatExit) {
                        UncatchCrashReporter.increaseNum();
                    }
                    sCurrentStartedActivity = activity;
                    sFirstActivityComed = true;
                }

                public void onActivityResumed(Activity activity) {
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityStopped(Activity activity) {
                    if (sCurrentStartedActivity == activity) {
                        if (!sHasStatExit) {
                            UncatchCrashReporter.decreaseNum();
                        }
                        sCurrentStartedActivity = null;
                    }
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            });
            if (sShutdownBroadcastReceiver == null) {
                sShutdownBroadcastReceiver = new ShutdownBroadcastReceiver();
                IntentFilter filter = new IntentFilter("android.intent.action.ACTION_SHUTDOWN");
                ((Application)objectData).registerReceiver((BroadcastReceiver)sShutdownBroadcastReceiver, filter);
            }
        } else if (msgId == 2) {
            if (UncatchCrashReporter.handleExit()) {
                int num = CommonPref.instance().getInt(JAVA_CATCH_CRASH_FLAG);
                num = num <= 0 ? 1 : ++num;
                CommonPref.instance().putInt(JAVA_CATCH_CRASH_FLAG, num);
            }
        } else if (msgId == 3) {
            if (UncatchCrashReporter.handleExit()) {
                int num = CommonPref.instance().getInt(NATIVE_CATCH_CRASH_FLAG);
                num = num <= 0 ? 1 : ++num;
                CommonPref.instance().putInt(NATIVE_CATCH_CRASH_FLAG, num);
            }
        } else if (msgId == 4) {
            UncatchCrashReporter.handleExit();
        } else if (msgId == 5) {
            UncatchCrashReporter.handleExit();
        } else if (msgId == 6) {
            int javaNum;
            if (!(objectData instanceof IReporter)) {
                return null;
            }
            int unCatchNum = CommonPref.instance().getInt(UNCATCH_CRASH_FLAG);
            if (unCatchNum < 1) {
                unCatchNum = 0;
            } else if (sCurrentStartedActivity != null || !sFirstActivityComed) {
                --unCatchNum;
            }
            int nativeNum = CommonPref.instance().getInt(NATIVE_CATCH_CRASH_FLAG);
            if (nativeNum < 0) {
                nativeNum = 0;
            }
            if ((javaNum = CommonPref.instance().getInt(JAVA_CATCH_CRASH_FLAG)) < 0) {
                javaNum = 0;
            }
            HashMap<String, String> keyAndValues = new HashMap<String, String>();
            keyAndValues.put(STAT_UNCATCH_KEY, unCatchNum > 0 ? "1" : "0");
            keyAndValues.put(STAT_UNCATCH_NUM_KEY, String.valueOf(unCatchNum));
            keyAndValues.put(STAT_JAVA_EXCEPTION_KEY, String.valueOf(javaNum));
            keyAndValues.put(STAT_NATIVE_EXCEPTION_KEY, String.valueOf(nativeNum));
            CommonPref.instance().putInt(NATIVE_CATCH_CRASH_FLAG, 0);
            CommonPref.instance().putInt(JAVA_CATCH_CRASH_FLAG, 0);
            CommonPref.instance().putInt(UNCATCH_CRASH_FLAG, sCurrentStartedActivity == null ? 0 : 1);
            ((IReporter)objectData).addStats(keyAndValues);
        }
        return true;
    }

    private static boolean handleExit() {
        if (!sHasStatExit) {
            sHasStatExit = true;
            UncatchCrashReporter.decreaseNum();
            return true;
        }
        return false;
    }

    private static void increaseNum() {
        int num = CommonPref.instance().getInt(UNCATCH_CRASH_FLAG);
        num = num <= 0 ? 1 : ++num;
        CommonPref.instance().putInt(UNCATCH_CRASH_FLAG, num);
    }

    private static void decreaseNum() {
        int num = CommonPref.instance().getInt(UNCATCH_CRASH_FLAG);
        num = num <= 0 ? 0 : --num;
        CommonPref.instance().putInt(UNCATCH_CRASH_FLAG, num);
    }

    public static interface IReporter {
        public void addStats(Map<String, String> var1);
    }

    private static class ShutdownBroadcastReceiver
    extends BroadcastReceiver {
        private static final String TAG = "ShutdownBroadcastReceiver";
        public static final String ACTION_SHUTDOWN = "android.intent.action.ACTION_SHUTDOWN";

        private ShutdownBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(ACTION_SHUTDOWN)) {
                MLog.info(TAG, "Shut down this system, ShutdownBroadcastReceiver onReceive()", new Object[0]);
                UncatchCrashReporter.handleMessage(5, null);
            }
        }
    }
}

