/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.cache;

import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import com.yy.mobile.cache.CacheClient;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class StringDiskCache {
    private static final String TAG = "DiskLruCache";
    private static final boolean DEBUG = false;
    private static final String CACHE_FILENAME_PREFIX = "";
    private static final int MAX_REMOVALS = 4;
    private static final int INITIAL_CAPACITY = 32;
    private static final float LOAD_FACTOR = 0.75f;
    private final File mCacheDir;
    private int cacheSize = 0;
    private int cacheByteSize = 0;
    private final int maxCacheItemSize = 8192;
    private long maxCacheByteSize = 0x1000000L;
    private final Map<String, String> mLinkedHashMap = Collections.synchronizedMap(new LinkedHashMap(32, 0.75f, true));
    private static final FilenameFilter cacheFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return filename.startsWith(StringDiskCache.CACHE_FILENAME_PREFIX);
        }
    };

    public static StringDiskCache openCache(File cacheDir, long maxByteSize) {
        if (cacheDir == null) {
            cacheDir = new File(Environment.getExternalStorageDirectory().getPath() + File.separator + "cacheDir");
        }
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            MLog.error((Object)TAG, "ERROR: Cannot create dir " + cacheDir.toString() + "!!!", new Object[0]);
            return null;
        }
        if (cacheDir.isDirectory() && cacheDir.canWrite() && StringDiskCache.getUsableSpace(cacheDir) > maxByteSize) {
            MLog.info(TAG, "cacheDir :" + cacheDir.toString(), new Object[0]);
            return new StringDiskCache(cacheDir, maxByteSize);
        }
        return null;
    }

    private StringDiskCache(File cacheDir, long maxByteSize) {
        this.mCacheDir = cacheDir;
        this.maxCacheByteSize = maxByteSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putText(String key, String data) {
        block7: {
            try {
                String file = StringDiskCache.createFilePath(this.mCacheDir, key);
                if (BlankUtil.isBlank(file)) break block7;
                String string = file;
                synchronized (string) {
                    if (this.writeTextFile(data, file)) {
                        this.put(key, file);
                        this.flushCache();
                    }
                }
            }
            catch (FileNotFoundException e) {
                MLog.error((Object)TAG, "Error in put: " + e.getMessage(), new Object[0]);
            }
            catch (IOException e) {
                MLog.error((Object)TAG, "Error in put: " + e.getMessage(), new Object[0]);
            }
        }
    }

    private void put(String key, String file) {
        this.mLinkedHashMap.put(key, file);
        this.cacheSize = this.mLinkedHashMap.size();
        this.cacheByteSize = (int)((long)this.cacheByteSize + new File(file).length());
    }

    private void flushCache() {
        for (int count = 0; count < 4 && (this.cacheSize > 8192 || (long)this.cacheByteSize > this.maxCacheByteSize); ++count) {
            Map.Entry<String, String> eldestEntry = this.mLinkedHashMap.entrySet().iterator().next();
            File eldestFile = new File(eldestEntry.getValue());
            long eldestFileSize = eldestFile.length();
            this.mLinkedHashMap.remove(eldestEntry.getKey());
            eldestFile.delete();
            this.cacheSize = this.mLinkedHashMap.size();
            this.cacheByteSize = (int)((long)this.cacheByteSize - eldestFileSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) throws FileNotFoundException, IOException {
        String file = this.mLinkedHashMap.get(key);
        if (BlankUtil.isBlank(file)) {
            file = StringDiskCache.createFilePath(this.mCacheDir, key);
        }
        if (!BlankUtil.isBlank(file)) {
            String string = file;
            synchronized (string) {
                File fis = new File(file);
                if (fis.exists()) {
                    try {
                        String json = this.checkExpire(fis);
                        if (!BlankUtil.isBlank(json)) {
                            this.put(key, file);
                        }
                        return json;
                    }
                    catch (FileNotFoundException e) {
                        MLog.error((Object)TAG, "Error in get: " + e.getMessage(), new Object[0]);
                        throw new FileNotFoundException();
                    }
                    catch (IOException e) {
                        MLog.error((Object)TAG, "Error in get: " + e.getMessage(), new Object[0]);
                        throw e;
                    }
                }
            }
        }
        throw new FileNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRaw(String key) throws FileNotFoundException, IOException {
        String file = this.mLinkedHashMap.get(key);
        if (BlankUtil.isBlank(file)) {
            file = StringDiskCache.createFilePath(this.mCacheDir, key);
        }
        if (!BlankUtil.isBlank(file)) {
            String string = file;
            synchronized (string) {
                File f = new File(file);
                if (f.exists()) {
                    try {
                        FileInputStream fis = new FileInputStream(f);
                        String raw = this.readIs2Bytes(fis);
                        if (!BlankUtil.isBlank(raw)) {
                            this.put(key, file);
                        }
                        return raw;
                    }
                    catch (FileNotFoundException e) {
                        MLog.error((Object)TAG, "Error in get: " + e.getMessage(), new Object[0]);
                        throw new FileNotFoundException();
                    }
                    catch (Exception e) {
                        MLog.error((Object)TAG, "Error in get: " + e.getMessage(), new Object[0]);
                        throw e;
                    }
                }
            }
        }
        throw new FileNotFoundException();
    }

    private String checkExpire(File newfile) throws FileNotFoundException, UnsupportedEncodingException {
        FileInputStream fis = new FileInputStream(newfile);
        String json = this.readIs2Bytes(fis);
        if (json != null) {
            CacheClient.CachePacket packet = JsonParser.parseJsonObject(json, CacheClient.CachePacket.class);
            long expiredTime = System.currentTimeMillis() - packet.getHeader().getCreateTime();
            if (expiredTime > packet.getHeader().getExpired()) {
                newfile.delete();
                return null;
            }
        }
        return json;
    }

    private OutputStream readIs2Os(InputStream is, OutputStream os) {
        try {
            byte[] bytes = new byte[1024];
            int length = 0;
            while ((length = is.read(bytes)) != -1) {
                os.write(bytes, 0, length);
            }
            try {
                is.close();
                os.close();
            }
            catch (Exception e) {
                Log.e((String)"StringDiskCache", (String)"Empty Catch on readIs2Os", (Throwable)e);
            }
        }
        catch (IOException e) {
            Log.e((String)"StringDiskCache", (String)"printStackTrace", (Throwable)e);
        }
        return os;
    }

    public String readIs2Bytes(InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.readIs2Os(is, baos);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            Log.e((String)"StringDiskCache", (String)"printStackTrace", (Throwable)e);
            return null;
        }
    }

    public boolean containsKey(String key) {
        return this.mLinkedHashMap.containsKey(key);
    }

    public void clearCache() {
        StringDiskCache.clearCache(this.mCacheDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(String key) {
        String file = this.mLinkedHashMap.get(key);
        if (BlankUtil.isBlank(file)) {
            file = StringDiskCache.createFilePath(this.mCacheDir, key);
        }
        if (!BlankUtil.isBlank(file)) {
            String string = file;
            synchronized (string) {
                File newfile = new File(file);
                if (newfile.exists()) {
                    newfile.delete();
                }
            }
        }
    }

    private static void clearCache(File cacheDir) {
        if (cacheDir == null) {
            return;
        }
        File[] files = cacheDir.listFiles(cacheFileFilter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null) continue;
                files[i].delete();
            }
        }
    }

    public static String createFilePath(File cacheDir, String key) {
        try {
            return cacheDir.getPath() + File.separator + CACHE_FILENAME_PREFIX + URLEncoder.encode(key.replace("*", CACHE_FILENAME_PREFIX), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            MLog.error((Object)TAG, "createFilePath - " + e, new Object[0]);
            return null;
        }
    }

    public String createFilePath(String key) {
        return StringDiskCache.createFilePath(this.mCacheDir, key);
    }

    private boolean writeTextFile(String str, String file) throws IOException, FileNotFoundException {
        if (BlankUtil.isBlank(str)) {
            return false;
        }
        BufferedOutputStream out = null;
        long begin0 = System.currentTimeMillis();
        out = new BufferedOutputStream(new FileOutputStream(file));
        ((OutputStream)out).write(str.getBytes("UTF-8"));
        ((OutputStream)out).flush();
        if (out != null) {
            try {
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                Log.e((String)"StringDiskCache", (String)"Empty Catch on writeTextFile", (Throwable)e);
            }
            long end0 = System.currentTimeMillis();
            MLog.info(TAG, file + ":BufferedOutputStream\u6267\u884c\u8017\u65f6:" + (end0 - begin0) + " \u8c6a\u79d2", new Object[0]);
        }
        return true;
    }

    private static long getUsableSpace(File path) {
        if (Build.VERSION.SDK_INT >= 9) {
            return path.getUsableSpace();
        }
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
    }
}

