/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.cache;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import com.yy.mobile.cache.Cache;
import com.yy.mobile.cache.CacheException;
import com.yy.mobile.cache.CacheManager;
import com.yy.mobile.cache.ErrorCallback;
import com.yy.mobile.cache.NoSuchKeyException;
import com.yy.mobile.cache.ReturnCallback;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.IQueueTaskExecutor;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yy.mobile.util.valid.BlankUtil;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

@SuppressLint(value={"HandlerLeak"})
public class CacheClient
implements Cache {
    private static final String TAG = "CacheClient";
    private long defaultExpire;
    private IQueueTaskExecutor asyncTask = YYTaskExecutor.createAQueueExcuter();
    private Map<String, BlockingQueue<CallbackWrapper>> manager = new ConcurrentHashMap<String, BlockingQueue<CallbackWrapper>>();
    private CacheManager cacheManager;
    private String uri;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            ErrorCallback errorCallback;
            CallbackWrapper wrapper = (CallbackWrapper)msg.obj;
            ReturnCallback returnCallback = wrapper.getReturnCallback();
            if (returnCallback != null) {
                try {
                    wrapper.getReturnCallback().onReturn(wrapper.getData());
                }
                catch (Exception e) {
                    MLog.error(CacheClient.TAG, e);
                }
            }
            if ((errorCallback = wrapper.getErrorCallback()) != null) {
                try {
                    wrapper.getErrorCallback().onError(wrapper.getError());
                }
                catch (Exception e) {
                    MLog.error(CacheClient.TAG, e);
                }
            }
        }
    };

    protected CacheClient(String uri) {
        this(uri, 3600000L);
    }

    protected CacheClient(String uri, long defaultExpire) {
        this.defaultExpire = defaultExpire;
        this.uri = uri;
        this.cacheManager = new CacheManager(uri);
    }

    @Override
    public void get(String key, ReturnCallback returncallback) {
        this.get(key, returncallback, null);
    }

    @Override
    public void get(String key, ReturnCallback returncallback, ErrorCallback errorCallback) {
        if (BlankUtil.isBlank(key)) {
            return;
        }
        final String mKey = key;
        BlockingQueue<CallbackWrapper> handlers = this.manager.get(mKey);
        if (handlers == null) {
            handlers = new LinkedBlockingQueue<CallbackWrapper>();
        }
        CallbackWrapper wrapper = new CallbackWrapper();
        wrapper.setReturnCallback(returncallback);
        wrapper.setErrorCallback(errorCallback);
        handlers.add(wrapper);
        this.manager.put(mKey, handlers);
        YYTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                CallbackWrapper wrapper;
                String data = "";
                CacheException error = null;
                BlockingQueue handlers = (BlockingQueue)CacheClient.this.manager.get(mKey);
                if (handlers.isEmpty()) {
                    return;
                }
                try {
                    String json = CacheClient.this.cacheManager.getCache(mKey);
                    CachePacket packet = JsonParser.parseJsonObject(json, CachePacket.class);
                    data = packet.getContent().toString();
                }
                catch (NoSuchKeyException e) {
                    error = e;
                    MLog.error(CacheClient.TAG, e);
                }
                catch (Exception e) {
                    error = new CacheException(mKey, "Wrap otherwise exceptions", e);
                    MLog.error(CacheClient.TAG, error);
                }
                while ((wrapper = (CallbackWrapper)handlers.poll()) != null) {
                    wrapper.setData(data);
                    wrapper.setError(error);
                    Message msg = Message.obtain();
                    msg.obj = wrapper;
                    CacheClient.this.handler.sendMessage(msg);
                }
            }
        }, 0L);
    }

    @Override
    public void put(String key, String value) {
        this.put(key, value, this.defaultExpire);
    }

    @Override
    public void put(String key, String value, long expire) {
        if (BlankUtil.isBlank(key)) {
            return;
        }
        final String mKey = key;
        final long mexpire = expire;
        CacheHeader header = new CacheHeader(key, expire, System.currentTimeMillis());
        CachePacket packet = new CachePacket(header, value);
        final String json = JsonParser.toJson(packet);
        this.asyncTask.execute(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)10);
                CacheClient.this.cacheManager.putCache(mKey, json, mexpire);
            }
        }, 0L);
    }

    @Override
    public void remove(String key) {
        this.cacheManager.remove(key);
    }

    @Override
    public void clear() {
        this.cacheManager.clear();
    }

    public String getUri() {
        return this.uri;
    }

    public static void main(String[] args) {
    }

    public class CachePacket {
        private CacheHeader header;
        private Object content;

        public CachePacket(CacheHeader header, Object content) {
            this.header = header;
            this.content = content;
        }

        public CacheHeader getHeader() {
            return this.header;
        }

        public void setHeader(CacheHeader header) {
            this.header = header;
        }

        public Object getContent() {
            return this.content;
        }

        public void setContents(Object content) {
            this.content = content;
        }
    }

    public class CacheHeader {
        private String key;
        private long expired;
        private long createTime;

        public CacheHeader(String key, long expired, long createTime) {
            this.key = key;
            this.expired = expired;
            this.createTime = createTime;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public long getExpired() {
            return this.expired;
        }

        public void setExpired(long expired) {
            this.expired = expired;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(long createTime) {
            this.createTime = createTime;
        }
    }

    public class CallbackWrapper {
        private String data;
        private CacheException error;
        private ReturnCallback returnCallback;
        private ErrorCallback errorCallback;

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public ReturnCallback getReturnCallback() {
            return this.returnCallback;
        }

        public void setReturnCallback(ReturnCallback returnCallback) {
            this.returnCallback = returnCallback;
        }

        public ErrorCallback getErrorCallback() {
            return this.errorCallback;
        }

        public void setErrorCallback(ErrorCallback errorCallback) {
            this.errorCallback = errorCallback;
        }

        public CacheException getError() {
            return this.error;
        }

        public void setError(CacheException error) {
            this.error = error;
        }
    }
}

