/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.arclayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import com.yy.mobile.framework.R;
import com.yy.mobile.ui.widget.arclayout.RotateAndTranslateAnimation;

public class ArcLayout
extends ViewGroup {
    private int mChildSize;
    private int mChildPadding = 20;
    private int mLayoutPadding = 10;
    public static final float DEFAULT_FROM_DEGREES = 270.0f;
    public static final float DEFAULT_TO_DEGREES = 360.0f;
    private float mFromDegrees = 270.0f;
    private float mToDegrees = 360.0f;
    private static final int MIN_RADIUS = 100;
    private int mRadius;
    private boolean mExpanded = false;
    private OnLastHideListener mOnLastHideListener;
    private OnFirstShowListener mOnFirstShowListener;
    private boolean isAllAnimationEnd = true;

    public ArcLayout(Context context) {
        super(context);
    }

    public ArcLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ArcLayout, 0, 0);
            this.mFromDegrees = a.getFloat(R.styleable.ArcLayout_fromDegrees, 270.0f);
            this.mToDegrees = a.getFloat(R.styleable.ArcLayout_toDegrees, 360.0f);
            this.mChildSize = Math.max(a.getDimensionPixelSize(R.styleable.ArcLayout_childSize, 0), 0);
            a.recycle();
        }
    }

    private static int computeRadius(float arcDegrees, int childCount, int childSize, int childPadding, int minRadius) {
        if (childCount < 2) {
            return minRadius;
        }
        float perDegrees = arcDegrees / (float)(childCount - 1);
        float perHalfDegrees = perDegrees / 2.0f;
        int perSize = childSize + childPadding;
        int radius = (int)((double)(perSize / 2) / Math.sin(Math.toRadians(perHalfDegrees)));
        return Math.max(radius, minRadius);
    }

    private static Rect computeChildFrame(int centerX, int centerY, int radius, float degrees, int size) {
        double childCenterX = (double)centerX + (double)radius * Math.cos(Math.toRadians(degrees));
        double childCenterY = (double)centerY + (double)radius * Math.sin(Math.toRadians(degrees));
        return new Rect((int)(childCenterX - (double)(size / 2)), (int)(childCenterY - (double)(size / 2)), (int)(childCenterX + (double)(size / 2)), (int)(childCenterY + (double)(size / 2)));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int radius = this.mRadius = ArcLayout.computeRadius(Math.abs(this.mToDegrees - this.mFromDegrees), this.getChildCount(), this.mChildSize, this.mChildPadding, 100);
        int size = radius * 2 + this.mChildSize + this.mChildPadding + this.mLayoutPadding * 2;
        this.setMeasuredDimension(size, size);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.getChildAt(i).measure(View.MeasureSpec.makeMeasureSpec((int)this.mChildSize, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mChildSize, (int)0x40000000));
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        int radius = this.mExpanded ? this.mRadius : 0;
        int childCount = this.getChildCount();
        float perDegrees = (this.mToDegrees - this.mFromDegrees) / (float)(childCount - 1);
        float degrees = this.mFromDegrees;
        for (int i = 0; i < childCount; ++i) {
            Rect frame = ArcLayout.computeChildFrame(centerX, centerY, radius, degrees, this.mChildSize);
            degrees += perDegrees;
            this.getChildAt(i).layout(frame.left, frame.top, frame.right, frame.bottom);
        }
    }

    private static long computeStartOffset(int childCount, boolean expanded, int index, float delayPercent, long duration, Interpolator interpolator) {
        float delay = delayPercent * (float)duration;
        long viewDelay = (long)((float)ArcLayout.getTransformedIndex(expanded, childCount, index) * delay);
        float totalDelay = delay * (float)childCount;
        float normalizedDelay = (float)viewDelay / totalDelay;
        normalizedDelay = interpolator.getInterpolation(normalizedDelay);
        return (long)(normalizedDelay * totalDelay);
    }

    private static int getTransformedIndex(boolean expanded, int count, int index) {
        if (expanded) {
            return count - 1 - index;
        }
        return index;
    }

    private static Animation createExpandAnimation(float fromXDelta, float toXDelta, float fromYDelta, float toYDelta, long duration, Interpolator interpolator) {
        RotateAndTranslateAnimation animation = new RotateAndTranslateAnimation(0.0f, toXDelta, 0.0f, toYDelta, 0.0f, 720.0f);
        animation.setDuration(duration);
        animation.setInterpolator(interpolator);
        animation.setFillAfter(true);
        return animation;
    }

    private static Animation createShrinkAnimation(float fromXDelta, float toXDelta, float fromYDelta, float toYDelta, long duration, Interpolator interpolator) {
        AnimationSet animationSet = new AnimationSet(false);
        animationSet.setFillAfter(true);
        RotateAndTranslateAnimation translateAnimation = new RotateAndTranslateAnimation(0.0f, toXDelta, 0.0f, toYDelta, 360.0f, 720.0f);
        translateAnimation.setDuration(duration);
        translateAnimation.setInterpolator(interpolator);
        translateAnimation.setFillAfter(true);
        animationSet.addAnimation((Animation)translateAnimation);
        return animationSet;
    }

    private void bindChildAnimation(View child, int index, long duration) {
        boolean expanded = this.mExpanded;
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        int radius = expanded ? 0 : this.mRadius;
        int childCount = this.getChildCount();
        float perDegrees = (this.mToDegrees - this.mFromDegrees) / (float)(childCount - 1);
        Rect frame = ArcLayout.computeChildFrame(centerX, centerY, radius, this.mFromDegrees + (float)index * perDegrees, this.mChildSize);
        int toXDelta = frame.left - child.getLeft();
        int toYDelta = frame.top - child.getTop();
        AccelerateInterpolator interpolator = null;
        if (Build.VERSION.SDK_INT >= 22) {
            interpolator = this.mExpanded ? new AccelerateInterpolator() : new OvershootInterpolator(2.0f);
        }
        Animation animation = this.mExpanded ? ArcLayout.createShrinkAnimation(0.0f, toXDelta, 0.0f, toYDelta, duration, (Interpolator)interpolator) : ArcLayout.createExpandAnimation(0.0f, toXDelta, 0.0f, toYDelta, duration, (Interpolator)interpolator);
        final boolean isLast = ArcLayout.getTransformedIndex(expanded, childCount, index) == childCount - 1;
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (isLast) {
                    ArcLayout.this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ArcLayout.this.onAllAnimationsEnd();
                            ArcLayout.this.isAllAnimationEnd = true;
                        }
                    }, 0L);
                    if (!ArcLayout.this.mExpanded) {
                        ArcLayout.this.post(new Runnable(){

                            @Override
                            public void run() {
                                if (ArcLayout.this.mOnLastHideListener != null) {
                                    ArcLayout.this.mOnLastHideListener.onLastHide();
                                }
                            }
                        });
                    }
                }
            }
        });
        child.setAnimation(animation);
    }

    public boolean isExpanded() {
        return this.mExpanded;
    }

    public void setArc(float fromDegrees, float toDegrees) {
        if (this.mFromDegrees == fromDegrees && this.mToDegrees == toDegrees) {
            return;
        }
        this.mFromDegrees = fromDegrees;
        this.mToDegrees = toDegrees;
        this.requestLayout();
    }

    public void setChildSize(int size) {
        if (this.mChildSize == size || size < 0) {
            return;
        }
        this.mChildSize = size;
        this.requestLayout();
    }

    public int getChildSize() {
        return this.mChildSize;
    }

    public void switchState(boolean showAnimation) {
        if (showAnimation) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                this.bindChildAnimation(this.getChildAt(i), i, 300L);
            }
        }
        if (!this.mExpanded && this.mOnFirstShowListener != null) {
            this.mOnFirstShowListener.onFirstShow();
        }
        boolean bl = this.mExpanded = !this.mExpanded;
        if (!showAnimation) {
            this.requestLayout();
        }
        this.invalidate();
        this.isAllAnimationEnd = false;
    }

    private void onAllAnimationsEnd() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.getChildAt(i).clearAnimation();
        }
        this.requestLayout();
    }

    public void setOnLastHideListener(OnLastHideListener listener) {
        this.mOnLastHideListener = listener;
    }

    public void setOnFirstShowListener(OnFirstShowListener mOnFirstShowListener) {
        this.mOnFirstShowListener = mOnFirstShowListener;
    }

    public void setChildPadding(int childPadding) {
        this.mChildPadding = childPadding;
    }

    public boolean isAllAnimationEnd() {
        return this.isAllAnimationEnd;
    }

    public void clearAnim() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.getChildAt(i).clearAnimation();
        }
    }

    public static interface OnFirstShowListener {
        public void onFirstShow();
    }

    public static interface OnLastHideListener {
        public void onLastHide();
    }
}

