/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ScrollView;

public class BounceScrollView
extends ScrollView {
    private static final float MOVE_FACTOR = 0.3f;
    private static final int ANIM_TIME = 200;
    private View contentView;
    private float startY;
    private Rect originalRect = new Rect();
    private boolean canPullDown = false;
    private boolean canPullUp = false;
    private boolean isMoved = false;
    private int mTouchSlop;

    public BounceScrollView(Context context) {
        super(context);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
    }

    public BounceScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() > 0) {
            this.contentView = this.getChildAt(0);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.contentView == null) {
            return;
        }
        this.originalRect.set(this.contentView.getLeft(), this.contentView.getTop(), this.contentView.getRight(), this.contentView.getBottom());
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.contentView == null) {
            return super.dispatchTouchEvent(ev);
        }
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.canPullDown = this.isCanPullDown();
                this.canPullUp = this.isCanPullUp();
                this.startY = ev.getY();
                break;
            }
            case 1: 
            case 3: {
                if (!this.isMoved) break;
                TranslateAnimation anim = new TranslateAnimation(0.0f, 0.0f, (float)this.contentView.getTop(), (float)this.originalRect.top);
                anim.setDuration(200L);
                this.contentView.startAnimation((Animation)anim);
                this.contentView.layout(this.originalRect.left, this.originalRect.top, this.originalRect.right, this.originalRect.bottom);
                this.canPullDown = false;
                this.canPullUp = false;
                this.isMoved = false;
                break;
            }
            case 2: {
                boolean shouldMove;
                if (!this.canPullDown && !this.canPullUp) {
                    this.startY = ev.getY();
                    this.canPullDown = this.isCanPullDown();
                    this.canPullUp = this.isCanPullUp();
                    break;
                }
                float nowY = ev.getY();
                int deltaY = (int)(nowY - this.startY);
                boolean bl = shouldMove = this.canPullDown && deltaY > 0 || this.canPullUp && deltaY < 0 || this.canPullUp && this.canPullDown;
                if (!shouldMove || Math.abs(deltaY) <= this.mTouchSlop) break;
                int offset = (int)((float)deltaY * 0.3f);
                this.contentView.layout(this.originalRect.left, this.originalRect.top + offset, this.originalRect.right, this.originalRect.bottom + offset);
                this.isMoved = true;
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private boolean isCanPullDown() {
        return this.getScrollY() == 0 || this.contentView.getHeight() < this.getHeight() + this.getScrollY();
    }

    private boolean isCanPullUp() {
        return this.contentView.getHeight() <= this.getHeight() + this.getScrollY();
    }
}

