/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext;

import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.yy.mobile.richtext.BaseRichTextFilter;
import com.yy.mobile.richtext.XmlChannelMessage;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import java.io.ByteArrayInputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XmlFilter
extends BaseRichTextFilter {
    public static Document parserXml(String message) {
        if (!XmlFilter.checkValid(message)) {
            return null;
        }
        try {
            message = message.replaceAll("&(?!amp;)", "&amp;");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(new ByteArrayInputStream(message.getBytes()));
        }
        catch (Throwable e) {
            MLog.error((Object)"XmlFilter", "parserXml error! " + e, new Object[0]);
            return null;
        }
    }

    public static XmlChannelMessage parseNobleChannelMessage(String message) {
        XmlChannelMessage xmlChannelMessage = new XmlChannelMessage();
        if (!XmlFilter.checkValid(message)) {
            xmlChannelMessage.text = message;
            return xmlChannelMessage;
        }
        try {
            String fixedMsg = message.replaceFirst("\\u2029", "");
            Document parserDoc = XmlFilter.parserXml(fixedMsg);
            if (parserDoc == null) {
                xmlChannelMessage.text = message;
                return xmlChannelMessage;
            }
            return XmlFilter.parseNobleChannelMessage(xmlChannelMessage, parserDoc, message);
        }
        catch (Throwable e) {
            MLog.error((Object)"XmlFilter", "parseNobleChannelMessage error! " + e, new Object[0]);
            if (TextUtils.isEmpty((CharSequence)xmlChannelMessage.text)) {
                xmlChannelMessage.text = message;
            }
            return xmlChannelMessage;
        }
    }

    public static XmlChannelMessage parseNobleChannelMessage(XmlChannelMessage xmlChannelMessage, Document parserDoc, String errMessage) {
        block15: {
            if (parserDoc == null) {
                return xmlChannelMessage;
            }
            try {
                NodeList imgNodeList;
                Element element = parserDoc.getDocumentElement();
                NodeList nodeList = element.getElementsByTagName("txt");
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        NamedNodeMap attrs;
                        Node node = nodeList.item(i);
                        if (node == null || node.getParentNode() == null || !"msg".equals(node.getParentNode().getNodeName()) || (node = (attrs = node.getAttributes()).getNamedItem("data")) == null) continue;
                        xmlChannelMessage.text = node.getNodeValue();
                    }
                }
                if ((imgNodeList = element.getElementsByTagName("img")) == null) break block15;
                for (int i = 0; i < imgNodeList.getLength(); ++i) {
                    String value;
                    String data;
                    NamedNodeMap attrs;
                    Node node = imgNodeList.item(i);
                    if (node == null || node.getParentNode() == null || !"extra".equals(node.getParentNode().getNodeName()) || node.getParentNode().getAttributes().getNamedItem("id") == null) continue;
                    String idValue = node.getParentNode().getAttributes().getNamedItem("id").getNodeValue();
                    if ("live".equals(idValue)) {
                        attrs = node.getAttributes();
                        if ((node = attrs.getNamedItem("url")) == null) continue;
                        xmlChannelMessage.avatarUrl = URLDecoder.decode(node.getNodeValue());
                        break;
                    }
                    if ("AnonymityKey".equals(idValue)) {
                        String data2;
                        attrs = node.getAttributes();
                        if ((node = attrs.getNamedItem("data")) == null || StringUtils.isEmpty(data2 = node.getNodeValue()).booleanValue()) continue;
                        xmlChannelMessage.treeholeName = data2.split("/")[1];
                        continue;
                    }
                    if (TextUtils.isEmpty((CharSequence)idValue) || !idValue.startsWith("medal_")) continue;
                    String[] imgIds = null;
                    String[] poss = null;
                    String[] prioritys = null;
                    NamedNodeMap attrs2 = node.getAttributes();
                    if ((node = attrs2.getNamedItem("data")) != null && !StringUtils.isEmpty(data = node.getNodeValue()).booleanValue()) {
                        imgIds = data.split("[,]");
                    }
                    if ((node = attrs2.getNamedItem("pos")) != null) {
                        value = node.getNodeValue();
                        poss = value.split("[,]");
                    }
                    if ((node = attrs2.getNamedItem("priority")) != null) {
                        value = node.getNodeValue();
                        prioritys = value.split("[,]");
                    }
                    if (imgIds == null) continue;
                    int length = imgIds.length;
                    ArrayList medals = new ArrayList();
                    for (int k = 0; k < length; ++k) {
                        HashMap<String, String> medal = new HashMap<String, String>();
                        medal.put("imgKey", imgIds[k]);
                        String pos = poss != null && poss.length > k ? poss[k] : "";
                        medal.put("pos", pos);
                        String priority = prioritys != null && prioritys.length > k ? prioritys[k] : "";
                        medal.put("priority", priority);
                        medals.add(medal);
                    }
                    if (xmlChannelMessage.commonMedals == null) {
                        xmlChannelMessage.commonMedals = new ArrayList<Map<String, String>>();
                    }
                    xmlChannelMessage.commonMedals.addAll(medals);
                }
            }
            catch (Throwable e) {
                MLog.error((Object)"XmlFilter", "parseNobleChannelMessage error! " + e, new Object[0]);
                if (TextUtils.isEmpty((CharSequence)xmlChannelMessage.text)) {
                    xmlChannelMessage.text = errMessage;
                }
                return xmlChannelMessage;
            }
        }
        if (TextUtils.isEmpty((CharSequence)xmlChannelMessage.text)) {
            xmlChannelMessage.text = errMessage;
        }
        return xmlChannelMessage;
    }

    public static boolean checkValid(String str) {
        return str != null && str.length() > 5 && str.startsWith("<?xml");
    }

    public static String creatXmlNobleChannelMessage(String message, CreateMedalXmlInfo medalXmlInfo) {
        try {
            message = XmlFilter.fixXmlString(message);
        }
        catch (Throwable throwable) {
            MLog.error("XmlFilter", throwable);
        }
        StringBuilder earningXml = new StringBuilder();
        for (String xml : medalXmlInfo.medalXmlList) {
            earningXml.append(xml);
        }
        StringBuilder commonMedalXml = new StringBuilder();
        String medalTemplateXml = "<extra id=\"medal_%s\"><img data=\"%s\" pos=\"%s\" priority=\"%s\"></img></extra>";
        if (medalXmlInfo != null && !FP.empty(medalXmlInfo.commonMedals)) {
            for (Map.Entry<String, List<Map<String, String>>> medalInfos : medalXmlInfo.commonMedals.entrySet()) {
                String key = medalInfos.getKey();
                List<Map<String, String>> medals = medalInfos.getValue();
                StringBuilder data = new StringBuilder();
                StringBuilder pos = new StringBuilder();
                StringBuilder priority = new StringBuilder();
                for (Map<String, String> info : medals) {
                    data.append(info.get("imgKey")).append(",");
                    pos.append(info.get("pos")).append(",");
                    priority.append(info.get("priority")).append(",");
                }
                data = new StringBuilder(data.substring(0, data.length() - 1));
                pos = new StringBuilder(pos.substring(0, pos.length() - 1));
                priority = new StringBuilder(priority.substring(0, priority.length() - 1));
                String medalXml = String.format(medalTemplateXml, key, data.toString(), pos.toString(), priority.toString());
                commonMedalXml.append(medalXml);
            }
        }
        return "<?xml version=\"1.0\"?>\n<msg>\n" + earningXml + commonMedalXml + "<txt data=\"" + message + "\" />\n </msg>";
    }

    public static String creatXmlMobileLiveChannelMessage(String message, String headUrl) {
        message = XmlFilter.fixXmlString(message);
        headUrl = XmlFilter.fixXmlString(URLEncoder.encode(headUrl));
        return "<?xml version=\"1.0\"?>\n<msg>\n<extra id=\"live\">\n<img data=\"live\" url=\"" + headUrl + "\" ></img>\n</extra>\n<txt data=\"" + message + "\" />\n </msg>";
    }

    private static String fixXmlString(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            string = string.replaceAll("\\u0026", "&amp;");
            string = string.replaceAll("\\u003C", "&lt;");
            string = string.replaceAll("\\u003E", "&gt;");
            string = string.replaceAll("\\u0027", "&apos;");
            string = string.replaceAll("\\u0022", "&quot;");
        }
        catch (Throwable throwable) {
            MLog.error((Object)"XmlFilter", "fixXmlString error!" + throwable, new Object[0]);
        }
        return string;
    }

    public static class CreateMedalXmlInfo {
        public int userNobleInfoLevel;
        public String uid;
        public String trueLovelevel;
        public String medalName;
        public int knightMedalLv;
        public String matchId;
        public String actMedalLevel;
        public String actMedalUrl;
        public boolean isCBA;
        public Map<String, String> tailMap = new ArrayMap();
        public Map<String, List<Map<String, String>>> commonMedals;
        private List<String> medalXmlList = new ArrayList<String>();

        public CreateMedalXmlInfo(int userNobleInfoLevel, String uid, String trueLovelevel, String medalName, int knightMedalLv, String matchId, String activityMedalLevel, String activityMedalUrl, boolean isCBA) {
            this(userNobleInfoLevel, uid, trueLovelevel, medalName, knightMedalLv, matchId, activityMedalLevel, activityMedalUrl, isCBA, (Map<String, String>)new ArrayMap());
        }

        public CreateMedalXmlInfo(int userNobleInfoLevel, String uid, String trueLovelevel, String medalName, int knightMedalLv, String matchId, String activityMedalLevel, String activityMedalUrl, boolean isCBA, Map<String, String> tailMap) {
            this.userNobleInfoLevel = userNobleInfoLevel;
            this.uid = uid;
            this.trueLovelevel = trueLovelevel;
            this.medalName = medalName;
            this.knightMedalLv = knightMedalLv;
            this.matchId = matchId;
            this.actMedalLevel = activityMedalLevel;
            this.actMedalUrl = activityMedalUrl;
            this.isCBA = isCBA;
            this.tailMap = tailMap;
        }

        public CreateMedalXmlInfo(String uid, String matchId, List<String> medalXmlList) {
            this.uid = uid;
            this.matchId = matchId;
            this.medalXmlList = medalXmlList;
        }
    }
}

