/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.yy.mobile.http.dns.GslbDns;
import com.yy.mobile.http.dnsparser.DnsParser;
import com.yy.mobile.util.log.MLog;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.Dns;

public class OkHttpDns
implements Dns {
    private static final String TAG = "OkHttpDns";
    private static OkHttpDns instance = null;
    public static boolean useGslb = true;

    private OkHttpDns() {
    }

    public static OkHttpDns getInstance() {
        if (instance == null) {
            instance = new OkHttpDns();
        }
        MLog.info(TAG, "getInstance", new Object[0]);
        return instance;
    }

    public List<InetAddress> lookup(String hostname) throws UnknownHostException {
        List<String> info;
        MLog.info(TAG, "lookup getByName.hostname: %s, useGslb = %b", hostname, useGslb);
        if (DnsParser.needsConvertOnly(hostname) && useGslb && (info = GslbDns.inst().getIps(hostname)) != null && info.size() > 0) {
            ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>();
            for (int i = 0; i < info.size(); ++i) {
                InetAddress addr = InetAddress.getByName(info.get(i));
                inetAddresses.add(addr);
            }
            MLog.info(TAG, "get info from gslb = " + inetAddresses, new Object[0]);
            return inetAddresses;
        }
        List res = Dns.SYSTEM.lookup(hostname);
        MLog.info(TAG, "get info from SYSTEM dns = " + res, new Object[0]);
        if (res == null) {
            return Collections.emptyList();
        }
        return res;
    }
}

