/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.facebook.stetho.okhttp3.StethoInterceptor;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.OkHttpDns;
import com.yy.mobile.util.taskexecutor.YYTaskExecutorHelper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class BaseHttpClient {
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String ENCODING_GZIP = "gzip";
    public static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private static OkHttpClient okHttpClient = null;

    private static OkHttpClient initDefaultOkhttp() {
        try {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (BasicConfig.getInstance().isDebuggable()) {
                builder.addInterceptor((Interceptor)new StethoInterceptor());
            }
            builder.connectTimeout(10000L, TimeUnit.MILLISECONDS);
            builder.readTimeout(10000L, TimeUnit.MILLISECONDS);
            builder.writeTimeout(10000L, TimeUnit.MILLISECONDS);
            builder.dispatcher(new Dispatcher((ExecutorService)YYTaskExecutorHelper.INSTANCE.getIOThreadPool()));
            builder.retryOnConnectionFailure(true);
            return builder.dns((Dns)OkHttpDns.getInstance()).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void initOkHttpClient(OkHttpClient client) {
        if (client != null) {
            okHttpClient = client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getOkHttpClient() {
        if (okHttpClient != null) return okHttpClient;
        Class<BaseHttpClient> clazz = BaseHttpClient.class;
        synchronized (BaseHttpClient.class) {
            if (okHttpClient != null) return okHttpClient;
            okHttpClient = BaseHttpClient.initDefaultOkhttp();
            // ** MonitorExit[var0] (shouldn't be in output)
            return okHttpClient;
        }
    }
}

