/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.log.logger;

import com.yy.mobile.util.log.logger.ILogger;
import com.yy.mobile.util.log.logger.Utils;

public abstract class AbstractLogger
implements ILogger {
    protected int mOutputLevel = 1;

    @Override
    public void v(String tag, String message, Object ... args) {
        if (this.mOutputLevel > 1) {
            return;
        }
        this.log("V/:", tag, null, message, args);
    }

    @Override
    public void d(String tag, String message, Object ... args) {
        if (this.mOutputLevel > 2) {
            return;
        }
        this.log("D/:", tag, null, message, args);
    }

    @Override
    public void i(String tag, String message, Object ... args) {
        if (this.mOutputLevel > 3) {
            return;
        }
        this.log("I/:", tag, null, message, args);
    }

    @Override
    public void w(String tag, String message, Object ... args) {
        if (this.mOutputLevel > 4) {
            return;
        }
        this.log("W/:", tag, null, message, args);
    }

    @Override
    public void e(String tag, String message, Object ... args) {
        if (this.mOutputLevel > 5) {
            return;
        }
        this.log("E/:", tag, null, message, args);
    }

    @Override
    public void e(String tag, Throwable throwable, String message, Object ... args) {
        if (this.mOutputLevel > 5) {
            return;
        }
        this.log("E/:", tag, throwable, message, args);
    }

    @Override
    public void v(Object tag, String message, Object ... args) {
        if (this.mOutputLevel > 1) {
            return;
        }
        this.log("V/:", AbstractLogger.tag(tag), null, message, args);
    }

    @Override
    public void d(Object tag, String message, Object ... args) {
        if (this.mOutputLevel > 2) {
            return;
        }
        this.log("D/:", AbstractLogger.tag(tag), null, message, args);
    }

    @Override
    public void i(Object tag, String message, Object ... args) {
        if (this.mOutputLevel > 3) {
            return;
        }
        this.log("I/:", AbstractLogger.tag(tag), null, message, args);
    }

    @Override
    public void w(Object tag, String message, Object ... args) {
        if (this.mOutputLevel > 4) {
            return;
        }
        this.log("W/:", AbstractLogger.tag(tag), null, message, args);
    }

    @Override
    public void e(Object tag, String message, Object ... args) {
        if (this.mOutputLevel > 5) {
            return;
        }
        this.log("E/:", AbstractLogger.tag(tag), null, message, args);
    }

    @Override
    public void e(Object tag, Throwable throwable, String message, Object ... args) {
        if (this.mOutputLevel > 5) {
            return;
        }
        this.log("E/:", AbstractLogger.tag(tag), throwable, message, args);
    }

    private static String tag(Object tag) {
        if (tag == null) {
            return "";
        }
        return tag instanceof String ? (String)tag : tag.getClass().getSimpleName();
    }

    private void log(String level, String tag, Throwable throwable, String message, Object ... args) {
        this.log(level, System.currentTimeMillis(), Utils.getCurrentThreadName(), tag, throwable, message, args);
    }

    public abstract void log(String var1, long var2, String var4, String var5, Throwable var6, String var7, Object ... var8);

    public void setOutputLevel(int level) {
        this.mOutputLevel = level;
    }
}

