/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext.media;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.style.ClickableSpan;
import android.view.View;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.framework.R;
import com.yy.mobile.http.BytesQueryRequest;
import com.yy.mobile.http.Cache;
import com.yy.mobile.http.CacheForeverCacheController;
import com.yy.mobile.http.DefaultRequestParam;
import com.yy.mobile.http.DefaultRetryPolicy;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.richtext.media.ImCacheSetting;
import com.yy.mobile.richtext.media.ImSwitchUrlNetwork;
import com.yy.mobile.richtext.media.MediaFilter;
import com.yy.mobile.richtext.media.SafeDynamicDrawableSpan;
import com.yy.mobile.util.HttpsUrlHelpers;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.YYImageUtils;
import com.yy.mobile.util.log.MLog;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageFilter
extends MediaFilter {
    public static final String TAG = "ImageFilter";
    public static final String IMAGE_BEGIN = "[dyimg]";
    public static final String IMAGE_END = "[/dyimg]";
    public static final String DXIMSCREENSHOT = "dximscreenshot";
    public static final String WTIMSCREENSHOT = "wtimscreenshot";
    protected static final Pattern IMAGE_PATTERN = ImageFilter.createPattern("[dyimg]", "[/dyimg]");
    private static final float PORTRAIT_RATIO = 1.3333334f;
    private static final float LANDSCAPE_RATIO = 0.75f;

    public static String createImageMessage(String message) {
        return ImageFilter.createMessage(IMAGE_BEGIN, IMAGE_END, message);
    }

    public static String createImageMessage(String message, int progress) {
        return ImageFilter.createMessage(IMAGE_BEGIN, IMAGE_END, message, progress);
    }

    public static boolean isImageMessage(String message) {
        return IMAGE_PATTERN.matcher(message).find();
    }

    public static Matcher getImageMatcher(String message) {
        return IMAGE_PATTERN.matcher(message);
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth) {
        this.parseSpannable(context, spannable, maxWidth, null);
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth, Object tag) {
        List<MediaFilter.MediaInfo> infos = ImageFilter.getImageInfo(spannable.toString());
        for (MediaFilter.MediaInfo info : infos) {
            ImageClickSpan clickableSpan;
            ImImageSpan span;
            Drawable drawable2;
            info.index = infos.indexOf(info);
            info.tag = tag;
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug(TAG, "parseSpannable--info.content = " + info.content, new Object[0]);
            }
            if (ImageFilter.isUrl(info.content)) {
                info.content = HttpsUrlHelpers.translateToValidHttpsImDownUrl(info.content);
                MLog.info(TAG, "parseSpannable  info.content = " + info.content, new Object[0]);
                drawable2 = ImageLoader.getBitmapFromCache(info.content);
                MLog.info(TAG, "parseSpannable--drawable == null " + (drawable2 == null), new Object[0]);
                if (drawable2 == null) {
                    MLog.info(TAG, "parseSpannable drawable == null", new Object[0]);
                    Drawable tmpDrawable = this.getImImageDrawable(R.drawable.icon_loading);
                    span = new ImImageDownloadSpan(tmpDrawable, "\u52a0\u8f7d\u4e2d");
                    spannable.setSpan((Object)span, info.start, info.end, 33);
                    this.requestImage(info, context, spannable, tmpDrawable);
                } else {
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug(TAG, "ImImageSpan", new Object[0]);
                    }
                    span = new ImImageSpan(drawable2);
                    clickableSpan = new ImageClickSpan(context, info);
                    spannable.setSpan((Object)clickableSpan, info.start, info.end, 33);
                    spannable.setSpan((Object)span, info.start, info.end, 33);
                }
            } else {
                drawable2 = this.getImImageDrawable(info.content);
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(TAG, "getImImageDrawable info.content == " + info.content, new Object[0]);
                }
                if (drawable2 == null) {
                    MLog.info(TAG, "parseSpannable--drawable is null", new Object[0]);
                    continue;
                }
                MLog.info(TAG, "parseSpannable--info.progress = " + info.progress, new Object[0]);
                if (info.progress == -1) {
                    MLog.info(TAG, "info.progress == FAILED_STATE", new Object[0]);
                    span = new ImImageSpan(drawable2);
                    clickableSpan = new ImageClickSpan(context, info);
                    spannable.setSpan((Object)clickableSpan, info.start, info.end, 33);
                } else {
                    span = new ImImageLoadingSpan(drawable2, "\u4e0a\u4f20\u4e2d");
                    spannable.setSpan((Object)span, info.start, info.end, 33);
                    MLog.info(TAG, "\u4e0a\u4f20\u4e2d", new Object[0]);
                }
            }
            MLog.info(TAG, "start end %d, %d", info.start, info.end);
        }
    }

    public void requestImage(final MediaFilter.MediaInfo info, final Context context, final Spannable spannable, final Drawable tmpDrawable) {
        ImImageLoadingSpan[] spans;
        DefaultRequestParam requestParam = new DefaultRequestParam();
        requestParam.setCacheController(new CacheForeverCacheController());
        String url = info.content;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "requestImage url == " + url, new Object[0]);
        }
        Cache cache = ImCacheSetting.instance().getImageCache();
        BytesQueryRequest req = new BytesQueryRequest(cache, url, (ResponseListener<String>)new ResponseListener<BytesQueryRequest.BytesWrapper>(){

            @Override
            public void onResponse(BytesQueryRequest.BytesWrapper response) {
                Drawable d;
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(ImageFilter.TAG, "requestImage--respone = " + response, new Object[0]);
                }
                if ((d = ImageFilter.this.getImImageDrawableFromBytes(info.content, response.data)) == null) {
                    MLog.info(ImageFilter.TAG, "requestImage--Drawable d is null", new Object[0]);
                    return;
                }
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(ImageFilter.TAG, "requestImage--d = " + d, new Object[0]);
                }
                ImImageSpan imImageSpan = new ImImageSpan(d);
                spannable.setSpan((Object)imImageSpan, info.start, info.end, 33);
                ImageClickSpan clickableSpan = new ImageClickSpan(context, info);
                spannable.setSpan((Object)clickableSpan, info.start, info.end, 33);
            }
        }, new ResponseErrorListener(){

            @Override
            public void onErrorResponse(RequestError error) {
                MLog.info(ImageFilter.TAG, "requestImage--error = " + error, new Object[0]);
                ImImageDownloadSpan loadingSpan = new ImImageDownloadSpan(tmpDrawable, "\u52a0\u8f7d\u5931\u8d25");
                spannable.setSpan((Object)loadingSpan, info.start, info.end, 33);
            }
        }, new ProgressListener(){

            @Override
            public void onProgress(ProgressInfo info) {
                int percent = (int)(info.getProgress() * 100L / info.getTotal());
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(ImageFilter.TAG, "requestImage--ProgressInfo = " + info + " percent = " + percent, new Object[0]);
                }
            }
        });
        for (ImImageLoadingSpan s : spans = (ImImageLoadingSpan[])spannable.getSpans(info.start, info.end, ImImageLoadingSpan.class)) {
            spannable.removeSpan((Object)s);
        }
        ImImageDownloadSpan loadingSpan = new ImImageDownloadSpan(tmpDrawable, "\u52a0\u8f7d\u4e2d");
        spannable.setSpan((Object)loadingSpan, info.start, info.end, 33);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "requestImage \u52a0\u8f7d\u4e2d ", new Object[0]);
        }
        req.setRetryPolicy(new DefaultRetryPolicy(4000, 1, 0.0f));
        req.setNetwork(new ImSwitchUrlNetwork());
        req.setRunOnUIThread(true);
        if (url != null) {
            if (requestParam != null && requestParam.getCacheController() != null) {
                req.setCacheController(requestParam.getCacheController());
            }
            RequestManager.instance().submitRequest(req);
        }
    }

    public Drawable getImImageDrawable(String path) {
        BitmapDrawable drawable2 = ImageLoader.getBitmapFromCache(path);
        if (drawable2 == null) {
            drawable2 = ImageFilter.getImImageDrawable(BasicConfig.getInstance().getAppContext(), path);
            ImageLoader.addBitmapToCache(path, drawable2);
        }
        return drawable2;
    }

    public Drawable getImImageDrawableFromBytes(String path, byte[] data) {
        Bitmap bitmap = ImageUtil.decodeSampledBitmapFromByteArray(data, ImageConfig.defaultImageConfig());
        BitmapDrawable drawable2 = ImageFilter.getImImageDrawable(BasicConfig.getInstance().getAppContext(), bitmap);
        ImageLoader.addBitmapToCache(path, drawable2);
        return drawable2;
    }

    public Drawable getImImageDrawable(int resourceId) {
        BitmapDrawable drawable2 = ImageLoader.getBitmapFromCache(String.valueOf(resourceId));
        if (drawable2 == null) {
            drawable2 = ImageFilter.getImImageDrawable(BasicConfig.getInstance().getAppContext(), resourceId);
            ImageLoader.addBitmapToCache(String.valueOf(resourceId), drawable2);
        }
        return drawable2;
    }

    public static List<MediaFilter.MediaInfo> getImageInfo(String message) {
        Matcher m = IMAGE_PATTERN.matcher(message);
        return ImageFilter.parseMediaInfo(message, m, IMAGE_BEGIN, IMAGE_END);
    }

    public static String replaceImageWithGivenStr(String message, String givenStr) {
        String reg = ImageFilter.convertReg(IMAGE_BEGIN) + "[^\\[\\]]+" + ImageFilter.convertReg(IMAGE_END);
        return message.replaceAll(reg, givenStr);
    }

    public static BitmapDrawable getImImageDrawable(Context context, int resId) {
        Bitmap bitmap = ImageUtil.decodeSampledBitmapFromResourceId(context, resId, ImageConfig.defaultImageConfig());
        return ImageFilter.getImImageDrawable(context, bitmap);
    }

    public static BitmapDrawable getImImageDrawable(Context context, String path) {
        Bitmap bitmap = ImageUtil.decodeSampledBitmapFile(path, ImageConfig.defaultImageConfig());
        return ImageFilter.getImImageDrawable(context, bitmap);
    }

    public static BitmapDrawable getImImageDrawable(Context context, Bitmap bitmap) {
        if (bitmap == null) {
            MLog.error(YYImageUtils.class, "bitmap is null", new Object[0]);
            return null;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float screenWidth = ResolutionUtils.getScreenWidth(context);
        float screenHeight = ResolutionUtils.getScreenHeight(context);
        float maxWidth = screenWidth / 3.0f;
        float maxHeight = maxWidth * 1.3333334f;
        Rect rect = new Rect();
        if (screenWidth / (float)width > 15.0f) {
            if (height > width * 2 && screenHeight / (float)height < 2.0f) {
                rect.left = 0;
                rect.right = width;
                rect.bottom = (int)((float)width * 1.3333334f);
                rect.top = (height - rect.bottom) / 2;
                rect.bottom = rect.top + rect.bottom;
                bitmap = YYImageUtils.createClipBitmap(bitmap, rect);
                bitmap = YYImageUtils.resize(bitmap, (int)maxWidth, (int)maxHeight);
            } else {
                width = (int)ResolutionUtils.convertDpToPixel(width, context);
                height = (int)ResolutionUtils.convertDpToPixel(height, context);
                bitmap = YYImageUtils.resize(bitmap, width, height);
            }
        } else if (screenHeight / (float)height < 2.0f) {
            rect.left = 0;
            rect.right = width;
            rect.bottom = (int)((float)width * 1.3333334f);
            rect.top = (height - rect.bottom) / 2;
            rect.bottom = rect.top + rect.bottom;
            bitmap = YYImageUtils.createClipBitmap(bitmap, rect);
            bitmap = YYImageUtils.resize(bitmap, (int)maxWidth, (int)maxHeight);
        } else if (height > width * 2) {
            rect.left = 0;
            rect.right = width;
            rect.bottom = (int)((float)width * 1.3333334f);
            rect.top = (height - rect.bottom) / 2;
            rect.bottom = rect.top + rect.bottom;
            bitmap = YYImageUtils.createClipBitmap(bitmap, rect);
            bitmap = YYImageUtils.resize(bitmap, (int)maxWidth, (int)maxHeight);
        } else if (width > height * 2 && screenWidth / (float)width < 2.0f) {
            rect.bottom = height;
            rect.right = (int)((float)height * 1.3333334f);
            rect.left = (width - rect.right) / 2;
            rect.right = rect.left + rect.right;
            bitmap = YYImageUtils.createClipBitmap(bitmap, rect);
            bitmap = YYImageUtils.resize(bitmap, (int)maxWidth, (int)maxHeight);
        } else {
            bitmap = screenWidth / (float)width < 2.0f ? YYImageUtils.resize(bitmap, width /= 2, height /= 2) : YYImageUtils.resize(bitmap, (int)maxWidth, (int)maxHeight);
        }
        BitmapDrawable drawable2 = new BitmapDrawable(context.getResources(), bitmap);
        width = drawable2.getIntrinsicWidth();
        height = drawable2.getIntrinsicHeight();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug("hjinw", "width = " + width + "; height = " + height, new Object[0]);
        }
        drawable2.setBounds(0, 0, width > 0 ? width : 0, height > 0 ? height : 0);
        return drawable2;
    }

    class ImImageDownloadSpan
    extends ImImageLoadingSpan {
        public ImImageDownloadSpan(Drawable drawable2, String percent) {
            super(drawable2, percent);
        }

        @Override
        public Drawable getDrawable() {
            return this.drawable;
        }
    }

    class ImImageLoadingSpan
    extends ImImageSpan {
        final String percent;

        public ImImageLoadingSpan(Context context, Bitmap bitmap, String percent) {
            super(context, bitmap);
            this.percent = percent;
        }

        public ImImageLoadingSpan(Drawable drawable2, String percent) {
            super(drawable2);
            this.percent = percent;
        }

        @Override
        public Drawable getDrawable() {
            this.drawable.setAlpha(40);
            return this.drawable;
        }

        @Override
        public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
            super.draw(canvas, text, start, end, x, top, y, bottom, paint);
            canvas.save();
            Paint.FontMetricsInt fm = paint.getFontMetricsInt();
            float textHeight = (float)Math.ceil(fm.descent - fm.ascent);
            float textWidth = paint.measureText(this.percent);
            Rect rect = this.getDrawable().getBounds();
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose("hjinw", "rect = " + rect, new Object[0]);
            }
            float transX = x + (float)((rect.left + rect.right) / 2) - textWidth / 2.0f;
            float transY = (float)(top + (rect.top + rect.bottom) / 2) - textHeight / 2.0f;
            canvas.translate(transX, transY);
            paint.setColor(-1);
            canvas.drawText(this.percent, 0.0f, 0.0f, paint);
            canvas.restore();
        }
    }

    class ImImageSpan
    extends SafeDynamicDrawableSpan {
        protected Drawable drawable;

        public ImImageSpan(Context context, Bitmap bitmap) {
            super(1);
        }

        public ImImageSpan(Drawable drawable2) {
            super(0);
            this.drawable = drawable2;
        }

        @Override
        public Drawable getDrawable() {
            this.drawable.setAlpha(255);
            return this.drawable;
        }

        @Override
        public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
            canvas.save();
            Drawable d = this.getDrawable();
            int transY = bottom - d.getBounds().bottom;
            if (this.mVerticalAlignment == 1) {
                int textLength = text.length();
                for (int i = 0; i < textLength; ++i) {
                    if (!Character.isLetterOrDigit(text.charAt(i))) continue;
                    transY -= paint.getFontMetricsInt().descent;
                    break;
                }
            }
            canvas.translate(x, (float)transY);
            d.draw(canvas);
            canvas.restore();
        }
    }

    class ImageClickSpan
    extends ClickableSpan {
        private Context context;
        private MediaFilter.MediaInfo mediaInfo;

        public ImageClickSpan(Context context, MediaFilter.MediaInfo info) {
            this.context = context;
            this.mediaInfo = info;
        }

        public void onClick(View view) {
            if (ImageFilter.this.mOnSpanClickListener != null) {
                ImageFilter.this.mOnSpanClickListener.onClick(view, this.mediaInfo);
            }
        }
    }
}

