/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.toast;

import android.app.Activity;
import android.content.Context;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.framework.R;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.ui.widget.toast.ToastClickListener;

public class YYToast
extends Toast {
    public YYToast(Context context) {
        super(context);
    }

    private static View fulfilToastLayout(Context context, int layoutID, int txtViewID, CharSequence text) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View toastLayout = inflater.inflate(layoutID, null);
        TextView tv = (TextView)toastLayout.findViewById(txtViewID);
        if (!TextUtils.isEmpty((CharSequence)text)) {
            tv.setText(text);
            tv.setLongClickable(false);
        }
        return toastLayout;
    }

    private static View fulfilToastLayout(Context context, int layoutID, int imgViewID, int imgResID, int txtViewID, CharSequence text) {
        View toastLayout = YYToast.fulfilToastLayout(context, layoutID, txtViewID, text);
        ImageView iv = (ImageView)toastLayout.findViewById(imgViewID);
        iv.setImageResource(imgResID);
        return toastLayout;
    }

    private static Toast createToastWithLayout(Context context, View toastLayout, int duration) {
        Toast toast = new Toast(context);
        toast.setView(toastLayout);
        toast.setGravity(16, 0, 0);
        toast.setDuration(duration);
        return toast;
    }

    public static Toast makeText(Context context, CharSequence text, int duration) {
        View toastLayout = YYToast.fulfilToastLayout(context, R.layout.yy_new_toast_style1, R.id.toast_text, text);
        return YYToast.createToastWithLayout(context, toastLayout, duration);
    }

    public static Toast makeText(Context context, int resId, int duration) {
        return YYToast.makeText(context, context.getResources().getText(resId), duration);
    }

    public static Toast makeText(Context context, int imageResId, CharSequence text, int duration) {
        if (imageResId != 0) {
            View toastLayout = YYToast.fulfilToastLayout(context, R.layout.yy_new_toast_style2, R.id.toast_image, imageResId, R.id.toast_text, text);
            return YYToast.createToastWithLayout(context, toastLayout, duration);
        }
        return YYToast.makeText(context, text, duration);
    }

    public static Toast makeText(Context context, int imageResId, int resId, int duration) {
        return YYToast.makeText(context, imageResId, context.getResources().getText(resId), duration);
    }

    private static void removeViewFromParent(View view) {
        ViewParent parent = view.getParent();
        if (parent != null && parent instanceof ViewGroup) {
            ViewGroup parentView = (ViewGroup)parent;
            parentView.removeView(view);
        }
    }

    public static void showToastWithCloseBtn(Activity activity, String txt, int start, int end, final ToastClickListener listener) {
        if (activity == null || activity.findViewById(R.id.toast_style3) != null) {
            return;
        }
        final View toastLayout = LayoutInflater.from((Context)activity).inflate(R.layout.yy_new_toast_style3, null);
        SpannableString msp = new SpannableString((CharSequence)txt);
        msp.setSpan((Object)new ClickableSpan(){

            public void onClick(View widget) {
                if (listener != null && listener.onClick(widget)) {
                    YYToast.removeViewFromParent(toastLayout);
                }
            }

            public void updateDrawState(TextPaint ds) {
                super.updateDrawState(ds);
                if (listener != null) {
                    listener.updateDrawState(ds);
                }
            }
        }, start, end, 33);
        TextView tv = (TextView)toastLayout.findViewById(R.id.toast_text);
        tv.setText((CharSequence)msp);
        tv.setLongClickable(false);
        tv.setHighlightColor(0);
        tv.setMovementMethod(LinkMovementMethod.getInstance());
        ImageView iv = (ImageView)toastLayout.findViewById(R.id.toast_close);
        iv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                YYToast.removeViewFromParent(toastLayout);
            }
        });
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        activity.addContentView(toastLayout, lp);
    }
}

