/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.quickreturn;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.widget.AbsListView;
import android.widget.ListView;
import java.util.Dictionary;
import java.util.Hashtable;

public class QuickReturnUtils {
    private static TypedValue sTypedValue = new TypedValue();
    private static int sActionBarHeight;
    private static Dictionary<Integer, Integer> sListViewItemHeights;
    private static Dictionary<Integer, Integer> sRecyclerViewItemHeights;

    public static int dp2px(Context context, int dp) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics displaymetrics = new DisplayMetrics();
        display.getMetrics(displaymetrics);
        return (int)((float)dp * displaymetrics.density + 0.5f);
    }

    public static int px2dp(Context context, int px) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics displaymetrics = new DisplayMetrics();
        display.getMetrics(displaymetrics);
        return (int)((float)px / displaymetrics.density + 0.5f);
    }

    public static int getScrollY(ListView lv) {
        View c = lv.getChildAt(0);
        if (c == null) {
            return 0;
        }
        int firstVisiblePosition = lv.getFirstVisiblePosition();
        int top = c.getTop();
        int scrollY = -top + firstVisiblePosition * c.getHeight();
        return scrollY;
    }

    public static int getScrollY(AbsListView lv) {
        View c = lv.getChildAt(0);
        if (c == null) {
            return 0;
        }
        int firstVisiblePosition = lv.getFirstVisiblePosition();
        int scrollY = -c.getTop();
        sListViewItemHeights.put(lv.getFirstVisiblePosition(), c.getHeight());
        if (scrollY < 0) {
            scrollY = 0;
        }
        for (int i = 0; i < firstVisiblePosition; ++i) {
            if (sListViewItemHeights.get(i) == null) continue;
            scrollY += sListViewItemHeights.get(i).intValue();
        }
        return scrollY;
    }

    public static int getScrollY(RecyclerView rv, int columnCount) {
        View c = rv.getChildAt(0);
        if (c == null) {
            return 0;
        }
        LinearLayoutManager layoutManager = (LinearLayoutManager)rv.getLayoutManager();
        int firstVisiblePosition = layoutManager.findFirstVisibleItemPosition();
        int scrollY = -c.getTop();
        if (columnCount > 1) {
            sRecyclerViewItemHeights.put(firstVisiblePosition, c.getHeight() + QuickReturnUtils.dp2px(rv.getContext(), 8) / columnCount);
        } else {
            sRecyclerViewItemHeights.put(firstVisiblePosition, c.getHeight());
        }
        if (scrollY < 0) {
            scrollY = 0;
        }
        for (int i = 0; i < firstVisiblePosition; ++i) {
            if (sRecyclerViewItemHeights.get(i) == null) continue;
            scrollY += sRecyclerViewItemHeights.get(i).intValue();
        }
        return scrollY;
    }

    public static int getActionBarHeight(Context context) {
        if (sActionBarHeight != 0) {
            return sActionBarHeight;
        }
        context.getTheme().resolveAttribute(16843499, sTypedValue, true);
        sActionBarHeight = TypedValue.complexToDimensionPixelSize((int)QuickReturnUtils.sTypedValue.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
        return sActionBarHeight;
    }

    static {
        sListViewItemHeights = new Hashtable<Integer, Integer>();
        sRecyclerViewItemHeights = new Hashtable<Integer, Integer>();
    }
}

