/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.menudrawer.compat;

import android.app.Activity;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.lang.reflect.Method;

final class ActionBarHelperCompat {
    private static final String TAG = "ActionBarHelperCompat";

    private ActionBarHelperCompat() {
    }

    public static void setActionBarUpIndicator(Object info, Activity activity, Drawable drawable2, int contentDescRes) {
        SetIndicatorInfo sii = (SetIndicatorInfo)info;
        if (sii.mUpIndicatorView != null) {
            sii.mUpIndicatorView.setImageDrawable(drawable2);
            String contentDescription = contentDescRes == 0 ? null : activity.getString(contentDescRes);
            sii.mUpIndicatorView.setContentDescription((CharSequence)contentDescription);
        }
    }

    public static void setActionBarDescription(Object info, Activity activity, int contentDescRes) {
        SetIndicatorInfo sii = (SetIndicatorInfo)info;
        if (sii.mUpIndicatorView != null) {
            String contentDescription = contentDescRes == 0 ? null : activity.getString(contentDescRes);
            sii.mUpIndicatorView.setContentDescription((CharSequence)contentDescription);
        }
    }

    public static Drawable getThemeUpIndicator(Object info) {
        SetIndicatorInfo sii = (SetIndicatorInfo)info;
        if (sii.mUpIndicatorView != null) {
            return sii.mUpIndicatorView.getDrawable();
        }
        return null;
    }

    public static Object getIndicatorInfo(Activity activity) {
        return new SetIndicatorInfo(activity);
    }

    public static void setDisplayHomeAsUpEnabled(Object info, boolean enabled) {
        SetIndicatorInfo sii = (SetIndicatorInfo)info;
        if (sii.mHomeAsUpEnabled != null) {
            try {
                sii.mHomeAsUpEnabled.invoke(sii.mActionBar, enabled);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class SetIndicatorInfo {
        public ImageView mUpIndicatorView;
        public Object mActionBar;
        public Method mHomeAsUpEnabled;

        SetIndicatorInfo(Activity activity) {
            try {
                int upId;
                ViewGroup parent;
                View v;
                int homeId2;
                String appPackage = activity.getPackageName();
                try {
                    homeId2 = activity.getResources().getIdentifier("abs__home", "id", appPackage);
                    v = activity.findViewById(homeId2);
                    parent = (ViewGroup)v.getParent();
                    upId = activity.getResources().getIdentifier("abs__up", "id", appPackage);
                    this.mUpIndicatorView = (ImageView)parent.findViewById(upId);
                }
                catch (Throwable homeId2) {
                    // empty catch block
                }
                if (this.mUpIndicatorView == null) {
                    homeId2 = activity.getResources().getIdentifier("home", "id", appPackage);
                    v = activity.findViewById(homeId2);
                    parent = (ViewGroup)v.getParent();
                    upId = activity.getResources().getIdentifier("up", "id", appPackage);
                    this.mUpIndicatorView = (ImageView)parent.findViewById(upId);
                }
                Class<?> supportActivity = activity.getClass();
                Method getActionBar = supportActivity.getMethod("getSupportActionBar", new Class[0]);
                this.mActionBar = getActionBar.invoke((Object)activity, new Object[0]);
                Class<?> supportActionBar = this.mActionBar.getClass();
                this.mHomeAsUpEnabled = supportActionBar.getMethod("setDisplayHomeAsUpEnabled", Boolean.TYPE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

