/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.menudrawer;

import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;

class FloatScroller {
    private float mStart;
    private float mFinal;
    private float mCurr;
    private long mStartTime;
    private int mDuration;
    private float mDurationReciprocal;
    private float mDeltaX;
    private boolean mFinished = true;
    private Interpolator mInterpolator;

    public FloatScroller(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public final boolean isFinished() {
        return this.mFinished;
    }

    public final void forceFinished(boolean finished) {
        this.mFinished = finished;
    }

    public final int getDuration() {
        return this.mDuration;
    }

    public final float getCurr() {
        return this.mCurr;
    }

    public final float getStart() {
        return this.mStart;
    }

    public final float getFinal() {
        return this.mFinal;
    }

    public boolean computeScrollOffset() {
        if (this.mFinished) {
            return false;
        }
        int timePassed = (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
        if (timePassed < this.mDuration) {
            float x = (float)timePassed * this.mDurationReciprocal;
            x = this.mInterpolator.getInterpolation(x);
            this.mCurr = this.mStart + x * this.mDeltaX;
        } else {
            this.mCurr = this.mFinal;
            this.mFinished = true;
        }
        return true;
    }

    public void startScroll(float start, float delta, int duration) {
        this.mFinished = false;
        this.mDuration = duration;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStart = start;
        this.mFinal = start + delta;
        this.mDeltaX = delta;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
    }

    public void abortAnimation() {
        this.mCurr = this.mFinal;
        this.mFinished = true;
    }

    public void extendDuration(int extend) {
        int passed = this.timePassed();
        this.mDuration = passed + extend;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
        this.mFinished = false;
    }

    public int timePassed() {
        return (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
    }

    public void setFinal(float newVal) {
        this.mFinal = newVal;
        this.mDeltaX = this.mFinal - this.mStart;
        this.mFinished = false;
    }
}

